/*
 * Decompiled with CFR 0.152.
 */
package mod.crend.dynamiccrosshair.style;

import com.mojang.blaze3d.platform.NativeImage;
import it.unimi.dsi.fastutil.io.FastByteArrayInputStream;
import it.unimi.dsi.fastutil.io.FastByteArrayOutputStream;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.imageio.ImageIO;
import mod.crend.dynamiccrosshair.style.AbstractCrosshairStyle;
import mod.crend.dynamiccrosshair.style.BuiltinCrosshairStyle;
import mod.crend.dynamiccrosshair.style.CustomCrosshairStyle;
import mod.crend.dynamiccrosshairapi.registry.DynamicCrosshairStyles;
import mod.crend.libbamboo.PlatformUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;

public class CrosshairStyleManager {
    public static final CrosshairStyleManager INSTANCE = new CrosshairStyleManager();
    public static final TextureManager textureManager = Minecraft.m_91087_().m_91097_();
    public static final Path crosshairDirectory = PlatformUtils.resolveConfigFile((String)"crosshairs");
    Map<ResourceLocation, CustomCrosshairStyle> styles = new LinkedHashMap<ResourceLocation, CustomCrosshairStyle>();

    private CrosshairStyleManager() {
    }

    public void init() {
        File directory = crosshairDirectory.toFile();
        directory.mkdirs();
        for (File file : Objects.requireNonNull(directory.listFiles())) {
            this.registerCustomCrosshair(file);
        }
    }

    public boolean has(ResourceLocation identifier) {
        return this.styles.containsKey(identifier);
    }

    public boolean isCustomStyle(ResourceLocation identifier) {
        return this.has(identifier) && this.get(identifier).isCustom();
    }

    public AbstractCrosshairStyle get(ResourceLocation identifier) {
        if (BuiltinCrosshairStyle.BUILTIN_STYLES.containsKey(identifier)) {
            return BuiltinCrosshairStyle.BUILTIN_STYLES.get(identifier);
        }
        if (this.has(identifier)) {
            return this.styles.get(identifier);
        }
        return new CustomCrosshairStyle(identifier, "unknown");
    }

    public CustomCrosshairStyle getCustomStyle(ResourceLocation identifier) {
        return this.styles.get(identifier);
    }

    public Collection<BuiltinCrosshairStyle> getBuiltinStyles() {
        return BuiltinCrosshairStyle.BUILTIN_STYLES.values();
    }

    public Collection<CustomCrosshairStyle> getCustomStyles() {
        return this.styles.values();
    }

    public void delete(ResourceLocation identifier) {
        if (this.has(identifier)) {
            File file = crosshairDirectory.resolve(this.styles.get(identifier).getName() + ".png").toFile();
            file.delete();
        }
        this.remove(identifier);
    }

    public void remove(ResourceLocation identifier) {
        this.styles.remove(identifier);
    }

    public CustomCrosshairStyle create() {
        String name = this.getFirstUnusedName();
        ResourceLocation identifier = DynamicCrosshairStyles.of((String)("custom-" + name));
        CustomCrosshairStyle style = new CustomCrosshairStyle(identifier, name);
        this.styles.put(identifier, style);
        return style;
    }

    private String getFirstUnusedName() {
        int i = 0;
        while (crosshairDirectory.resolve(++i + ".png").toFile().exists()) {
        }
        return Integer.toString(i);
    }

    private void registerCustomCrosshair(File file) {
        String name = file.getName().split("\\.")[0];
        ResourceLocation identifier = DynamicCrosshairStyles.of((String)("custom-" + name));
        this.styles.put(identifier, new CustomCrosshairStyle(identifier, name));
        try {
            NativeImage nativeImage = NativeImage.m_85058_((InputStream)new FileInputStream(file));
            textureManager.m_118495_(identifier, (AbstractTexture)new DynamicTexture(nativeImage));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void save(CustomCrosshairStyle style, BufferedImage image) {
        this.styles.put(style.identifier, style);
        File file = crosshairDirectory.resolve(style.getName() + ".png").toFile();
        try {
            ImageIO.write((RenderedImage)image, "png", file);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean reload(CustomCrosshairStyle editStyle) {
        try {
            File file = crosshairDirectory.resolve(editStyle.name + ".png").toFile();
            if (file.exists()) {
                NativeImage nativeImage = NativeImage.m_85058_((InputStream)new FileInputStream(file));
                textureManager.m_118495_(editStyle.identifier, (AbstractTexture)new DynamicTexture(nativeImage));
                return true;
            }
            textureManager.m_118513_(editStyle.identifier);
            return false;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public void registerTexture(BufferedImage editImage, ResourceLocation identifier) {
        try (FastByteArrayOutputStream outputStream = new FastByteArrayOutputStream();){
            ImageIO.write((RenderedImage)editImage, "PNG", (OutputStream)outputStream);
            NativeImage nativeImage = NativeImage.m_85058_((InputStream)new FastByteArrayInputStream(outputStream.array));
            textureManager.m_118495_(identifier, (AbstractTexture)new DynamicTexture(nativeImage));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public NativeImage getTexture(ResourceLocation identifier) {
        return ((DynamicTexture)textureManager.m_118506_(identifier)).m_117991_();
    }
}

