/*
 * Decompiled with CFR 0.152.
 */
package mod.crend.dynamiccrosshair.mixin;

import java.util.Objects;
import mod.crend.dynamiccrosshairapi.crosshair.CrosshairContext;
import mod.crend.dynamiccrosshairapi.interaction.InteractionType;
import mod.crend.dynamiccrosshairapi.type.DynamicCrosshairItem;
import mod.crend.dynamiccrosshairapi.type.DynamicCrosshairRangedItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;

@Mixin(value={Item.class})
public abstract class DynamicCrosshairBaseItem
implements DynamicCrosshairItem,
DynamicCrosshairRangedItem {
    public InteractionType dynamiccrosshair$compute(CrosshairContext context) {
        ItemStack itemStack = context.getItemStack();
        if (itemStack.m_41614_() && (context.getPlayer().m_36391_(false) || Objects.requireNonNull(itemStack.m_41720_().m_41473_()).m_38747_())) {
            return InteractionType.CONSUME_ITEM;
        }
        InteractionType interactionType = (InteractionType)context.withApisUntilNonNull(api -> {
            if (api.isAlwaysUsable(itemStack)) {
                return InteractionType.USE_ITEM;
            }
            if (api.isAlwaysUsableOnBlock(itemStack) && context.isWithBlock()) {
                return InteractionType.USE_ITEM_ON_BLOCK;
            }
            if (api.isAlwaysUsableOnEntity(itemStack) && context.isWithEntity()) {
                return InteractionType.USE_ITEM_ON_ENTITY;
            }
            if (api.isAlwaysUsableOnMiss(itemStack) && !context.isTargeting()) {
                return InteractionType.USE_ITEM;
            }
            if (api.isTool(itemStack)) {
                return InteractionType.TOOL;
            }
            if (api.isThrowable(itemStack)) {
                return InteractionType.THROW_ITEM;
            }
            if (api.isShield(itemStack)) {
                return InteractionType.SHIELD;
            }
            if (api.isMeleeWeapon(itemStack)) {
                return InteractionType.MELEE_WEAPON;
            }
            if (api.isRangedWeapon(itemStack)) {
                return InteractionType.RANGED_WEAPON;
            }
            if (api.isBlock(itemStack)) {
                return InteractionType.PLACE_BLOCK;
            }
            return null;
        });
        if (interactionType == null) {
            return InteractionType.EMPTY;
        }
        return interactionType;
    }

    public boolean dynamiccrosshair$isCharging(CrosshairContext context) {
        return context.isActiveItem() && context.getPlayer().m_21212_() > 0;
    }

    public boolean dynamiccrosshair$isCharged(CrosshairContext context) {
        return true;
    }
}

