/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.packager;

import com.simibubi.create.content.logistics.stockTicker.PackageOrderWithCrafts;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableInt;

public record PackagingRequest(ItemStack item, MutableInt count, String address, int linkIndex, MutableBoolean finalLink, MutableInt packageCounter, int orderId, @Nullable PackageOrderWithCrafts context) {
    public static PackagingRequest create(ItemStack item, int count, String address, int linkIndex, MutableBoolean finalLink, int packageCount, int orderId, @Nullable PackageOrderWithCrafts context) {
        return new PackagingRequest(item, new MutableInt(count), address, linkIndex, finalLink, new MutableInt(packageCount), orderId, context);
    }

    public int getCount() {
        return this.count.intValue();
    }

    public void subtract(int toSubtract) {
        this.count.setValue(this.getCount() - toSubtract);
    }

    public boolean isEmpty() {
        return this.getCount() == 0;
    }

    public static PackagingRequest fromNBT(CompoundTag tag) {
        ItemStack item = ItemStack.m_41712_((CompoundTag)tag.m_128469_("Item"));
        int count = tag.m_128451_("Count");
        String address = tag.m_128461_("Address");
        int linkIndex = tag.m_128451_("LinkIndex");
        MutableBoolean finalLink = new MutableBoolean(tag.m_128471_("FinalLink"));
        int packageCount = tag.m_128451_("PackageCount");
        int orderId = tag.m_128451_("OrderId");
        PackageOrderWithCrafts context = tag.m_128441_("OrderContext") ? PackageOrderWithCrafts.read(tag.m_128469_("OrderContext")) : null;
        return PackagingRequest.create(item, count, address, linkIndex, finalLink, packageCount, orderId, context);
    }

    public CompoundTag toNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("Count", this.count.intValue());
        tag.m_128365_("Item", (Tag)this.item.serializeNBT());
        tag.m_128359_("Address", this.address);
        tag.m_128405_("LinkIndex", this.linkIndex);
        tag.m_128379_("FinalLink", this.finalLink.booleanValue());
        tag.m_128405_("PackageCount", this.packageCounter.intValue());
        tag.m_128405_("OrderId", this.orderId);
        if (this.context != null) {
            tag.m_128365_("OrderContext", (Tag)this.context.write());
        }
        return tag;
    }
}

