/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.decoration;

import com.simibubi.create.AllShapes;
import com.simibubi.create.content.equipment.extendoGrip.ExtendoGripItem;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.infrastructure.config.AllConfigs;
import java.util.function.Predicate;
import net.createmod.catnip.placement.IPlacementHelper;
import net.createmod.catnip.placement.PlacementHelpers;
import net.createmod.catnip.placement.PlacementOffset;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeMod;

public class MetalLadderBlock
extends LadderBlock
implements IWrenchable {
    private static final int placementHelperId = PlacementHelpers.register((IPlacementHelper)new PlacementHelper());

    public MetalLadderBlock(BlockBehaviour.Properties p_54345_) {
        super(p_54345_);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean supportsExternalFaceHiding(BlockState state) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean m_6104_(BlockState pState, BlockState pAdjacentBlockState, Direction pDirection) {
        if (pDirection != null && pDirection.m_122434_().m_122479_()) {
            return pAdjacentBlockState.m_60795_() || !pAdjacentBlockState.m_280555_();
        }
        return pDirection == Direction.UP && pAdjacentBlockState.m_60734_() instanceof LadderBlock;
    }

    public VoxelShape m_7952_(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return AllShapes.SIX_VOXEL_POLE.get(Direction.Axis.Y);
    }

    public BlockState m_7417_(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        if (!pState.m_60710_((LevelReader)pLevel, pCurrentPos)) {
            return Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }

    public boolean m_7898_(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        BlockState otherState = pLevel.m_8055_(pPos.m_121945_(Direction.UP));
        return super.m_7898_(pState, pLevel, pPos) || otherState.m_60713_((Block)this) && ((Direction)pState.m_61143_((Property)f_54337_)).equals((Object)otherState.m_61143_((Property)f_54337_));
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult ray) {
        if (player.m_6144_() || !player.m_36326_()) {
            return InteractionResult.PASS;
        }
        ItemStack heldItem = player.m_21120_(hand);
        IPlacementHelper helper = PlacementHelpers.get((int)placementHelperId);
        if (helper.matchesItem(heldItem)) {
            return helper.getOffset(player, world, state, pos, ray).placeInWorld(world, (BlockItem)heldItem.m_41720_(), player, hand, ray);
        }
        return InteractionResult.PASS;
    }

    @MethodsReturnNonnullByDefault
    private static class PlacementHelper
    implements IPlacementHelper {
        private PlacementHelper() {
        }

        public Predicate<ItemStack> getItemPredicate() {
            return i -> i.m_41720_() instanceof BlockItem && ((BlockItem)i.m_41720_()).m_40614_() instanceof MetalLadderBlock;
        }

        public Predicate<BlockState> getStatePredicate() {
            return s -> s.m_60734_() instanceof LadderBlock;
        }

        public int attachedLadders(Level world, BlockPos pos, Direction direction) {
            BlockPos checkPos = pos.m_121945_(direction);
            BlockState state = world.m_8055_(checkPos);
            int count = 0;
            while (this.getStatePredicate().test(state)) {
                ++count;
                checkPos = checkPos.m_121945_(direction);
                state = world.m_8055_(checkPos);
            }
            return count;
        }

        public PlacementOffset getOffset(Player player, Level world, BlockState state, BlockPos pos, BlockHitResult ray) {
            int ladders;
            AttributeInstance reach;
            Direction dir = player.m_146909_() < 0.0f ? Direction.UP : Direction.DOWN;
            int range = (Integer)AllConfigs.server().equipment.placementAssistRange.get();
            if (player != null && (reach = player.m_21051_((Attribute)ForgeMod.BLOCK_REACH.get())) != null && reach.m_22109_(ExtendoGripItem.singleRangeAttributeModifier)) {
                range += 4;
            }
            if ((ladders = this.attachedLadders(world, pos, dir)) >= range) {
                return PlacementOffset.fail();
            }
            BlockPos newPos = pos.m_5484_(dir, ladders + 1);
            BlockState newState = world.m_8055_(newPos);
            if (!state.m_60710_((LevelReader)world, newPos)) {
                return PlacementOffset.fail();
            }
            if (newState.m_247087_()) {
                return PlacementOffset.success((Vec3i)newPos, bState -> (BlockState)bState.m_61124_((Property)LadderBlock.f_54337_, (Comparable)((Direction)state.m_61143_((Property)LadderBlock.f_54337_))));
            }
            return PlacementOffset.fail();
        }
    }
}

