/*
 * Decompiled with CFR 0.152.
 */
package net.combatroll.client.gui;

import net.minecraft.world.phys.Vec2;

public class HudElement {
    public Origin origin;
    public Vec2 offset;

    public HudElement(Origin origin, Vec2 offset) {
        this.origin = origin;
        this.offset = offset;
    }

    public static enum Origin {
        TOP,
        TOP_LEFT,
        TOP_RIGHT,
        BOTTOM,
        BOTTOM_LEFT,
        BOTTOM_RIGHT;


        public Vec2 getPoint(int screenWidth, int screenHeight) {
            switch (this) {
                case TOP: {
                    return new Vec2((float)screenWidth / 2.0f, 0.0f);
                }
                case TOP_LEFT: {
                    return new Vec2(0.0f, 0.0f);
                }
                case TOP_RIGHT: {
                    return new Vec2((float)screenWidth, 0.0f);
                }
                case BOTTOM: {
                    return new Vec2((float)screenWidth / 2.0f, (float)screenHeight);
                }
                case BOTTOM_LEFT: {
                    return new Vec2(0.0f, (float)screenHeight);
                }
                case BOTTOM_RIGHT: {
                    return new Vec2((float)screenWidth, (float)screenHeight);
                }
            }
            return new Vec2((float)screenWidth / 2.0f, (float)screenHeight / 2.0f);
        }

        public Vec2 initialOffset() {
            int offset = 12;
            switch (this) {
                case TOP: {
                    return new Vec2(0.0f, (float)offset);
                }
                case TOP_LEFT: {
                    return new Vec2((float)offset, (float)offset);
                }
                case TOP_RIGHT: {
                    return new Vec2((float)(-1 * offset), (float)offset);
                }
                case BOTTOM: {
                    return new Vec2(0.0f, (float)(-1 * offset));
                }
                case BOTTOM_LEFT: {
                    return new Vec2((float)offset, (float)(-1 * offset));
                }
                case BOTTOM_RIGHT: {
                    return new Vec2((float)(-1 * offset), (float)(-1 * offset));
                }
            }
            return new Vec2(0.0f, 0.0f);
        }
    }
}

