/*
 * Decompiled with CFR 0.152.
 */
package bettercommandblockui.main.ui.screen;

import bettercommandblockui.main.BetterCommandBlockUI;
import bettercommandblockui.main.ChainHandler;
import bettercommandblockui.main.ui.CyclingTexturedButtonWidget;
import bettercommandblockui.main.ui.MultiLineTextFieldWidget;
import bettercommandblockui.main.ui.screen.AbstractBetterCommandBlockScreen;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundSetCommandBlockPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.level.BaseCommandBlock;
import net.minecraft.world.level.block.CommandBlock;
import net.minecraft.world.level.block.entity.CommandBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

@Environment(value=EnvType.CLIENT)
public class BetterCommandBlockScreen
extends AbstractBetterCommandBlockScreen {
    private CyclingTexturedButtonWidget<CommandBlockEntity.Mode> modeButton;
    private CyclingTexturedButtonWidget<Boolean> conditionalModeButton;
    private CyclingTexturedButtonWidget<Boolean> redstoneTriggerButton;
    private CommandBlockEntity.Mode mode = CommandBlockEntity.Mode.REDSTONE;
    private BlockState blockState;
    private ChainHandler chainHandler;
    private Button chainNext;
    private List<Button> chainPrior;
    CommandBlockEntity blockEntity;
    private boolean conditional;
    private boolean autoActivate;
    public static BetterCommandBlockScreen instance;

    public BetterCommandBlockScreen(Minecraft client, CommandBlockEntity blockEntity, BaseCommandBlock commandExecutor) {
        this.blockEntity = blockEntity;
        this.commandExecutor = commandExecutor;
        this.f_96541_ = client;
        this.chainHandler = new ChainHandler(this, this.commandExecutor);
        this.chainPrior = new LinkedList<Button>();
        instance = this;
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        int textBoxWidth = this.f_96543_ - (2 * screenMarginX + 2 * cycleButtonWidth + 2 * buttonMargin);
        int sideButtonX = this.f_96543_ / 2 - (cycleButtonWidth + buttonMargin + textBoxWidth / 2);
        Component[] modeTooltips = new Component[]{Component.m_237115_((String)"advMode.mode.redstone"), Component.m_237115_((String)"advMode.mode.sequence"), Component.m_237115_((String)"advMode.mode.auto")};
        this.modeButton = (CyclingTexturedButtonWidget)this.m_142416_((GuiEventListener)new CyclingTexturedButtonWidget<CommandBlockEntity.Mode>(sideButtonX, this.f_96544_ / 2 - (buttonHeight + buttonHeight / 2 + buttonMargin), cycleButtonWidth, buttonHeight, Component.m_130674_((String)""), button -> {
            this.mode = (CommandBlockEntity.Mode)button.getValue();
        }, this.f_96541_.f_91080_, BetterCommandBlockUI.BUTTON_MODE, 0, new CommandBlockEntity.Mode[]{CommandBlockEntity.Mode.REDSTONE, CommandBlockEntity.Mode.SEQUENCE, CommandBlockEntity.Mode.AUTO}, modeTooltips));
        Component[] conditionalTooltips = new Component[]{Component.m_237115_((String)"advMode.mode.unconditional"), Component.m_237115_((String)"advMode.mode.conditional")};
        this.conditionalModeButton = (CyclingTexturedButtonWidget)this.m_142416_((GuiEventListener)new CyclingTexturedButtonWidget<Boolean>(sideButtonX, this.f_96544_ / 2 - buttonHeight / 2, cycleButtonWidth, buttonHeight, Component.m_130674_((String)""), button -> {
            this.conditional = (Boolean)button.getValue();
        }, this.f_96541_.f_91080_, BetterCommandBlockUI.BUTTON_CONDITIONAL, 0, new Boolean[]{false, true}, conditionalTooltips));
        Component[] activeTooltips = new Component[]{Component.m_237115_((String)"advMode.mode.redstoneTriggered"), Component.m_237115_((String)"advMode.mode.autoexec.bat")};
        this.redstoneTriggerButton = (CyclingTexturedButtonWidget)this.m_142416_((GuiEventListener)new CyclingTexturedButtonWidget<Boolean>(sideButtonX, this.f_96544_ / 2 + buttonHeight / 2 + buttonMargin, cycleButtonWidth, buttonHeight, Component.m_130674_((String)""), button -> {
            this.autoActivate = (Boolean)button.getValue();
        }, this.f_96541_.f_91080_, BetterCommandBlockUI.BUTTON_ACTIVE, 0, new Boolean[]{false, true}, activeTooltips));
        if (this.chainHandler.isInChain()) {
            BlockState next = this.chainHandler.getNext();
            List<Tuple<BlockState, Direction>> prior = this.chainHandler.getPrior();
            BlockPos position = BlockPos.m_274446_((Position)this.commandExecutor.m_6607_());
            this.blockState = Minecraft.m_91087_().f_91073_.m_8055_(position);
            if (next != null && next.m_60734_().equals(BuiltInRegistries.f_256975_.m_7745_(ResourceLocation.m_214293_((String)"minecraft", (String)"chain_command_block")))) {
                Direction dir = (Direction)Minecraft.m_91087_().f_91073_.m_8055_(position).m_61143_((Property)CommandBlock.f_51793_);
                this.chainNext = (Button)this.m_142416_((GuiEventListener)new ImageButton(49, 5, 20, 20, 0, 20, 20, BetterCommandBlockUI.BlockStateToButtonTexture(next), 20, 60, button -> this.moveAlongChain(dir), Component.m_130674_((String)"")));
                this.chainNext.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"bcbui.chain.next")));
            }
            if (!prior.isEmpty()) {
                int y = 5;
                for (Tuple<BlockState, Direction> entry : prior) {
                    this.chainPrior.add((Button)this.m_142416_((GuiEventListener)new ImageButton(5, y, 20, 20, 0, 20, 20, BetterCommandBlockUI.BlockStateToButtonTexture((BlockState)entry.m_14418_()), 20, 60, button -> this.moveAlongChain((Direction)entry.m_14419_()), Component.m_130674_((String)""))));
                    this.chainPrior.get(this.chainPrior.size() - 1).m_257544_(Tooltip.m_257550_((Component)BetterCommandBlockUI.DirectionToText((Direction)entry.m_14419_())));
                    y += 22;
                }
            }
        }
        this.setButtonsActive(false);
    }

    @Override
    protected void setButtonsActive(boolean value) {
        super.setButtonsActive(value);
        this.modeButton.setActive(value);
        this.conditionalModeButton.setActive(value);
        this.redstoneTriggerButton.setActive(value);
    }

    public void moveAlongChain(Direction dir) {
        BlockPos position = BlockPos.m_274446_((Position)this.commandExecutor.m_6607_());
        assert (Minecraft.m_91087_().f_91072_ != null);
        Minecraft.m_91087_().f_91072_.m_233732_(Minecraft.m_91087_().f_91074_, InteractionHand.MAIN_HAND, new BlockHitResult(position.m_121955_(dir.m_122436_()).m_252807_(), Direction.UP, position.m_121955_(dir.m_122436_()), false));
    }

    @Override
    protected boolean wasModified() {
        boolean bl = super.wasModified();
        return bl || this.modeButton.getValue() != this.priorState.type || this.conditionalModeButton.getValue() != this.priorState.conditional || this.redstoneTriggerButton.getValue() != this.priorState.needsRedstone;
    }

    @Override
    public void returnFromConfig() {
        this.updateCommandBlock();
        super.returnFromConfig();
    }

    public void updateCommandBlock() {
        this.updated = true;
        BaseCommandBlock commandBlockExecutor = this.blockEntity.m_59141_();
        ((MultiLineTextFieldWidget)this.consoleCommandTextField).setRawText(commandBlockExecutor.m_45438_());
        this.trackOutput = commandBlockExecutor.m_45440_();
        this.mode = this.blockEntity.m_59148_();
        this.conditional = this.blockEntity.m_59151_();
        this.autoActivate = this.blockEntity.m_59143_();
        this.priorState = new AbstractBetterCommandBlockScreen.CommandBlockState(this.mode, this.conditional, this.autoActivate, this.trackOutput);
        if (!BetterCommandBlockUI.TRACK_OUTPUT_DEFAULT_USED) {
            int trackingOutputIndex = this.trackOutput ? 0 : 1;
            this.toggleTrackingOutputButton.setIndex(trackingOutputIndex);
        }
        int modeIndex = 0;
        this.mode = this.blockEntity.m_59148_();
        switch (this.mode) {
            case SEQUENCE: {
                modeIndex = 1;
                break;
            }
            case AUTO: {
                modeIndex = 2;
            }
        }
        this.modeButton.setIndex(modeIndex);
        int conditionalIndex = this.conditional ? 1 : 0;
        this.conditionalModeButton.setIndex(conditionalIndex);
        int autoIndex = this.autoActivate ? 1 : 0;
        this.redstoneTriggerButton.setIndex(autoIndex);
        this.setPreviousOutputText(this.trackOutput);
        this.setButtonsActive(true);
    }

    @Override
    protected void commit() {
        super.commit();
        this.priorState.needsRedstone = this.redstoneTriggerButton.getValue();
        this.priorState.type = this.modeButton.getValue();
        this.priorState.conditional = this.conditional;
    }

    @Override
    protected void syncSettingsToServer(BaseCommandBlock commandExecutor) {
        assert (this.f_96541_ != null);
        Objects.requireNonNull(this.f_96541_.m_91403_()).m_104955_((Packet)new ServerboundSetCommandBlockPacket(BlockPos.m_274446_((Position)commandExecutor.m_6607_()), this.consoleCommandTextField.m_94155_(), this.mode, this.trackOutput, this.conditional, this.autoActivate));
    }

    @Override
    public void m_88315_(GuiGraphics context, int mouseX, int mouseY, float delta) {
        super.m_88315_(context, mouseX, mouseY, delta);
        this.renderAsterisk(context, (LayoutElement)this.modeButton, this.modeButton.getValue() != this.priorState.type);
        this.renderAsterisk(context, (LayoutElement)this.conditionalModeButton, this.conditionalModeButton.getValue() != this.priorState.conditional);
        this.renderAsterisk(context, (LayoutElement)this.redstoneTriggerButton, this.redstoneTriggerButton.getValue() != this.priorState.needsRedstone);
        if (this.chainHandler.isInChain()) {
            ResourceLocation texture = BetterCommandBlockUI.BlockStateToButtonTexture(this.blockState);
            context.m_280163_(texture, 27, 5, 0.0f, 20.0f, 20, 20, 20, 60);
            context.m_280509_(27, 5, 46, 24, -1895825408);
            this.renderAsterisk(context, 47, 1, this.wasModified());
            if (!this.updated) {
                if (this.showOutput) {
                    context.m_280509_(this.previousOutputTextField.m_252754_(), this.previousOutputTextField.m_252907_(), this.previousOutputTextField.m_252754_() + this.previousOutputTextField.m_5711_(), this.previousOutputTextField.m_252907_() + this.previousOutputTextField.m_93694_(), -1895825408);
                } else {
                    context.m_280509_(this.consoleCommandTextField.m_252754_(), this.consoleCommandTextField.m_252907_(), this.consoleCommandTextField.m_252754_() + this.consoleCommandTextField.m_5711_(), this.consoleCommandTextField.m_252907_() + this.consoleCommandTextField.m_93694_(), -1895825408);
                }
                context.m_280653_(this.f_96547_, (Component)Component.m_237115_((String)"bcbui.chain.tooFar"), this.f_96543_ / 2, this.f_96544_ / 2, -6250336);
            }
        }
    }
}

