/*
 * Decompiled with CFR 0.152.
 */
package bettercommandblockui.main.ui.screen;

import bettercommandblockui.main.BetterCommandBlockUI;
import bettercommandblockui.main.config.ConfigScreen;
import bettercommandblockui.main.ui.CyclingTexturedButtonWidget;
import bettercommandblockui.main.ui.MultiLineCommandSuggestor;
import bettercommandblockui.main.ui.MultiLineTextFieldWidget;
import bettercommandblockui.main.ui.SideWindow;
import bettercommandblockui.mixin.ScreenAccessor;
import com.mojang.blaze3d.vertex.PoseStack;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.GameNarrator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.CommandSuggestions;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BaseCommandBlock;
import net.minecraft.world.level.block.entity.CommandBlockEntity;

@Environment(value=EnvType.CLIENT)
public abstract class AbstractBetterCommandBlockScreen
extends Screen {
    protected static final Component SET_COMMAND_TEXT = Component.m_237115_((String)"advMode.setCommand");
    protected static final Component COMMAND_TEXT = Component.m_237115_((String)"advMode.command");
    protected static final Component PREVIOUS_OUTPUT_TEXT = Component.m_237115_((String)"advMode.previousOutput");
    protected static final ResourceLocation BUTTON_SAVE = new ResourceLocation("bettercommandblockui", "textures/gui/bettercommandblockui/button_save.png");
    protected CommandBlockState priorState;
    protected EditBox consoleCommandTextField;
    protected EditBox previousOutputTextField;
    protected Button doneButton;
    protected Button cancelButton;
    protected CyclingTexturedButtonWidget<Boolean> toggleTrackingOutputButton;
    protected Checkbox setTrackingOutputDefaultCheckbox;
    protected CyclingTexturedButtonWidget<Boolean> showOutputButton;
    protected Checkbox setShowOutputDefaultCheckbox;
    protected ImageButton showSideWindowButton;
    protected ImageButton saveButton;
    protected SideWindow sideWindow;
    protected BaseCommandBlock commandExecutor;
    protected CommandSuggestions commandSuggestor;
    protected boolean trackOutput = true;
    protected boolean showOutput = BetterCommandBlockUI.SHOW_OUTPUT_DEFAULT;
    protected boolean updated = false;
    protected static boolean showSideWindow = false;
    protected static int buttonHeight = 20;
    protected static int sliderHeight = 10;
    protected static int textHeight = 10;
    protected static int cycleButtonWidth = buttonHeight;
    protected static int buttonMargin = 10;
    protected static int textMargin = 5;
    protected static int screenMarginX = 40;
    protected static int screenMarginY = 20;

    protected AbstractBetterCommandBlockScreen() {
        super(GameNarrator.f_93310_);
    }

    public void m_7856_() {
        assert (this.f_96541_ != null);
        this.priorState = new CommandBlockState(CommandBlockEntity.Mode.REDSTONE, false, false, this.commandExecutor.m_45440_());
        int textBoxHeight = this.f_96544_ - (2 * screenMarginY + textHeight + textMargin + buttonHeight + 2 * buttonMargin + sliderHeight);
        int textBoxWidth = this.f_96543_ - (2 * screenMarginX + 2 * cycleButtonWidth + 2 * buttonMargin);
        int lowerButtonWidth = Math.min(textBoxWidth / 2 - buttonMargin / 2, 160);
        this.doneButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)CommonComponents.f_130655_, button -> this.commitAndClose()).m_252987_(this.f_96543_ / 2 - (lowerButtonWidth + buttonMargin / 2), this.f_96544_ / 2 + (5 + buttonMargin + textBoxHeight / 2), lowerButtonWidth, buttonHeight).m_253136_());
        this.cancelButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)CommonComponents.f_130656_, button -> this.m_7379_()).m_252987_(this.f_96543_ / 2 + buttonMargin / 2, this.f_96544_ / 2 + (5 + buttonMargin + textBoxHeight / 2), lowerButtonWidth, buttonHeight).m_253136_());
        this.trackOutput = this.commandExecutor.m_45440_();
        if (BetterCommandBlockUI.TRACK_OUTPUT_DEFAULT_USED) {
            this.trackOutput = BetterCommandBlockUI.TRACK_OUTPUT_DEFAULT_VALUE;
        }
        Component[] trackOutputTooltips = new Component[]{Component.m_237115_((String)"bcbui.trackOutput.true"), Component.m_237115_((String)"bcbui.trackOutput.false")};
        this.toggleTrackingOutputButton = (CyclingTexturedButtonWidget)this.m_142416_((GuiEventListener)new CyclingTexturedButtonWidget<Boolean>(this.f_96543_ / 2 + (textBoxWidth / 2 + buttonMargin + buttonMargin / 2), this.f_96544_ / 2 - (buttonHeight + buttonMargin), cycleButtonWidth, buttonHeight, Component.m_130674_((String)""), button -> {
            this.trackOutput = (Boolean)button.getValue();
            this.commandExecutor.m_45428_(this.trackOutput);
            this.setPreviousOutputText(this.trackOutput);
            this.setTrackingOutputDefaultCheckbox.f_93623_ = !this.setTrackingOutputDefaultCheckbox.m_93840_() || this.trackOutput == BetterCommandBlockUI.TRACK_OUTPUT_DEFAULT_VALUE;
        }, this.f_96541_.f_91080_, BetterCommandBlockUI.BUTTON_TRACK_OUTPUT, this.trackOutput ? 0 : 1, new Boolean[]{true, false}, trackOutputTooltips));
        this.setTrackingOutputDefaultCheckbox = (Checkbox)this.m_142416_((GuiEventListener)new Checkbox(this.toggleTrackingOutputButton.m_252754_() + this.toggleTrackingOutputButton.m_5711_() + 2, this.toggleTrackingOutputButton.m_252907_(), 20, 20, (Component)Component.m_237119_(), BetterCommandBlockUI.TRACK_OUTPUT_DEFAULT_USED, false){

            public void m_5691_() {
                super.m_5691_();
                BetterCommandBlockUI.setConfig("track_output_default_used", "" + this.m_93840_());
                BetterCommandBlockUI.setConfig("track_output_default_value", "" + AbstractBetterCommandBlockScreen.this.trackOutput);
            }
        });
        this.setTrackingOutputDefaultCheckbox.f_93623_ = !this.setTrackingOutputDefaultCheckbox.m_93840_() || this.trackOutput == BetterCommandBlockUI.TRACK_OUTPUT_DEFAULT_VALUE;
        this.setTrackingOutputDefaultCheckbox.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"bcbui.trackOutput.setDefault")));
        Component[] outputTooltips = new Component[]{Component.m_237115_((String)"bcbui.view.command"), Component.m_237115_((String)"bcbui.view.output")};
        this.showOutputButton = (CyclingTexturedButtonWidget)this.m_142416_((GuiEventListener)new CyclingTexturedButtonWidget<Boolean>(this.f_96543_ / 2 + (textBoxWidth / 2 + buttonMargin + buttonMargin / 2), this.f_96544_ / 2, cycleButtonWidth, buttonHeight, Component.m_130674_((String)""), button -> {
            this.showOutput = (Boolean)button.getValue();
            this.consoleCommandTextField.m_94194_(!this.showOutput);
            this.previousOutputTextField.m_94194_(this.showOutput);
            this.setShowOutputDefaultCheckbox.f_93623_ = this.showOutput;
        }, this.f_96541_.f_91080_, BetterCommandBlockUI.BUTTON_OUTPUT, BetterCommandBlockUI.SHOW_OUTPUT_DEFAULT ? 1 : 0, new Boolean[]{false, true}, outputTooltips));
        this.setShowOutputDefaultCheckbox = (Checkbox)this.m_142416_((GuiEventListener)new Checkbox(this.showOutputButton.m_252754_() + this.showOutputButton.m_5711_() + 2, this.showOutputButton.m_252907_(), 20, 20, (Component)Component.m_237119_(), BetterCommandBlockUI.SHOW_OUTPUT_DEFAULT, false){

            public void m_5691_() {
                super.m_5691_();
                BetterCommandBlockUI.setConfig("show_output_default", "" + this.m_93840_());
            }
        });
        this.setShowOutputDefaultCheckbox.f_93623_ = this.showOutput;
        this.setShowOutputDefaultCheckbox.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"bcbui.view.outputDefault")));
        this.showSideWindowButton = (ImageButton)this.m_142416_((GuiEventListener)new ImageButton(this.f_96543_ - (buttonMargin + cycleButtonWidth), this.f_96544_ - (buttonMargin + cycleButtonWidth), cycleButtonWidth, buttonHeight, 0, 20, 20, BetterCommandBlockUI.BUTTON_SIDE_WINDOW, 20, 60, button -> {
            showSideWindow = !showSideWindow;
            this.sideWindow.setVisible(showSideWindow);
            this.showOutputButton.setTooltipVisible(!showSideWindow);
            this.setShowOutputDefaultCheckbox.m_257427_(showSideWindow ? Integer.MAX_VALUE : 0);
            this.toggleTrackingOutputButton.setTooltipVisible(!showSideWindow);
            this.setTrackingOutputDefaultCheckbox.m_257427_(showSideWindow ? Integer.MAX_VALUE : 0);
        }, (Component)Component.m_237115_((String)"bcbui.tools")));
        Tooltip showSideWindowTooltip = Tooltip.m_257550_((Component)Component.m_237115_((String)"bcbui.tools"));
        this.showSideWindowButton.m_257544_(showSideWindowTooltip);
        this.consoleCommandTextField = new MultiLineTextFieldWidget(this.f_96547_, this.f_96543_ / 2 - textBoxWidth / 2, this.f_96544_ / 2 - textBoxHeight / 2, textBoxWidth, textBoxHeight, (Component)Component.m_237115_((String)"advMode.command"), this){

            protected MutableComponent m_5646_() {
                return super.m_5646_().m_7220_(AbstractBetterCommandBlockScreen.this.commandSuggestor.m_272218_());
            }
        };
        this.commandSuggestor = new MultiLineCommandSuggestor(this.f_96541_, this, this.consoleCommandTextField, this.f_96547_, true, true, 0, 7, false, Integer.MIN_VALUE);
        this.commandSuggestor.m_93922_(true);
        this.commandSuggestor.m_93881_();
        ((MultiLineTextFieldWidget)this.consoleCommandTextField).setCommandSuggestor((MultiLineCommandSuggestor)this.commandSuggestor);
        this.consoleCommandTextField.m_94199_(32500);
        this.consoleCommandTextField.m_94151_(this::onCommandChanged);
        this.m_7787_((GuiEventListener)this.consoleCommandTextField);
        this.previousOutputTextField = new MultiLineTextFieldWidget(this.f_96547_, this.f_96543_ / 2 - textBoxWidth / 2, this.f_96544_ / 2 - textBoxHeight / 2, textBoxWidth, 16, (Component)Component.m_237115_((String)"advMode.previousOutput"), this);
        this.previousOutputTextField.m_94199_(32500);
        this.previousOutputTextField.m_94186_(false);
        ((MultiLineTextFieldWidget)this.consoleCommandTextField).setRawText("-");
        this.m_7787_((GuiEventListener)this.previousOutputTextField);
        this.setPreviousOutputText(this.trackOutput);
        this.consoleCommandTextField.m_94144_(this.commandExecutor.m_45438_());
        this.sideWindow = (SideWindow)this.m_169394_(new SideWindow(3 * this.f_96543_ / 4, 20, this.f_96543_ / 4, 7 * this.f_96544_ / 10, (MultiLineTextFieldWidget)this.consoleCommandTextField, this));
        this.sideWindow.setVisible(showSideWindow);
        this.sideWindow.m_93692_(false);
        this.showOutputButton.setTooltipVisible(!showSideWindow);
        this.setShowOutputDefaultCheckbox.m_257427_(showSideWindow ? Integer.MAX_VALUE : 0);
        this.toggleTrackingOutputButton.setTooltipVisible(!showSideWindow);
        this.setTrackingOutputDefaultCheckbox.m_257427_(showSideWindow ? Integer.MAX_VALUE : 0);
        this.consoleCommandTextField.m_94194_(!this.showOutput);
        this.previousOutputTextField.m_94194_(this.showOutput);
        this.m_264313_((GuiEventListener)(this.showOutput ? this.previousOutputTextField : this.consoleCommandTextField));
        if (this.showOutput) {
            this.previousOutputTextField.m_93692_(true);
        } else {
            this.consoleCommandTextField.m_93692_(true);
        }
        this.saveButton = (ImageButton)this.m_142416_((GuiEventListener)new ImageButton(27, 27, cycleButtonWidth, buttonHeight, 0, 20, 20, BUTTON_SAVE, 20, 60, button -> {
            if (this.wasModified()) {
                this.commit();
            }
        }, (Component)Component.m_237115_((String)"bcbui.save")));
        Tooltip saveTooltip = Tooltip.m_257550_((Component)Component.m_237115_((String)"bcbui.save"));
        this.saveButton.m_257544_(saveTooltip);
    }

    public void m_7379_() {
        super.m_7379_();
    }

    public void m_6574_(Minecraft client, int width, int height) {
        String string = this.consoleCommandTextField.m_94155_();
        this.m_6575_(client, width, height);
        ((MultiLineTextFieldWidget)this.consoleCommandTextField).setRawText(string);
        this.commandSuggestor.m_93881_();
        this.setButtonsActive(true);
    }

    public void openConfig() {
        assert (this.f_96541_ != null);
        BetterCommandBlockUI.commandBuffer = this.consoleCommandTextField.m_94155_();
        this.f_96541_.m_91152_((Screen)new ConfigScreen(this, this.f_96541_, this.f_96543_, this.f_96544_));
    }

    public void returnFromConfig() {
        this.consoleCommandTextField.m_94144_(BetterCommandBlockUI.commandBuffer);
    }

    public void sideWindowFocused() {
        this.consoleCommandTextField.m_93692_(false);
    }

    public boolean scroll(double amount) {
        return this.commandSuggestor.m_93882_(Mth.m_14008_((double)amount, (double)-1.0, (double)1.0));
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (showSideWindow && this.sideWindow.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        if (this.commandSuggestor.m_93884_(mouseX, mouseY, button)) {
            return true;
        }
        if (this.consoleCommandTextField.m_6375_(mouseX, mouseY, button)) {
            this.m_7522_((GuiEventListener)this.consoleCommandTextField);
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (button == 0) {
            if (showSideWindow && this.sideWindow.m_7979_(mouseX, mouseY, button, deltaX, deltaY)) {
                return true;
            }
            if (this.showOutput) {
                return this.previousOutputTextField.m_7979_(mouseX, mouseY, button, deltaX, deltaY);
            }
            return this.consoleCommandTextField.m_7979_(mouseX, mouseY, button, deltaX, deltaY);
        }
        return false;
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (showSideWindow && this.sideWindow.m_6348_(mouseX, mouseY, button)) {
            return true;
        }
        if (button == 0) {
            if (this.showOutput) {
                return this.previousOutputTextField.m_6348_(mouseX, mouseY, button);
            }
            return this.consoleCommandTextField.m_6348_(mouseX, mouseY, button);
        }
        return false;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (showSideWindow && this.sideWindow.m_93696_() && this.sideWindow.m_7933_(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (keyCode == 340 || keyCode == 344) {
            if (this.showOutput) {
                this.previousOutputTextField.m_7933_(keyCode, scanCode, modifiers);
            } else {
                this.consoleCommandTextField.m_7933_(keyCode, scanCode, modifiers);
            }
        }
        if (this.commandSuggestor.m_93888_(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (keyCode == 258 && this.sideWindow.m_93696_()) {
            return true;
        }
        if (super.m_7933_(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (this.updated && !BetterCommandBlockUI.IGNORE_ENTER && (keyCode == 257 || keyCode == 335)) {
            this.commitAndClose();
            return true;
        }
        return false;
    }

    public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 340 || keyCode == 344) {
            if (this.showOutput) {
                this.previousOutputTextField.m_7920_(keyCode, scanCode, modifiers);
            } else {
                this.consoleCommandTextField.m_7920_(keyCode, scanCode, modifiers);
            }
        }
        return super.m_7920_(keyCode, scanCode, modifiers);
    }

    public boolean m_5534_(char c, int modifiers) {
        if (showSideWindow && this.sideWindow.m_5534_(c, modifiers)) {
            return true;
        }
        if (this.showOutput) {
            return false;
        }
        return this.consoleCommandTextField.m_5534_(c, modifiers);
    }

    protected void onCommandChanged(String s) {
        this.commandSuggestor.m_93881_();
    }

    protected void setButtonsActive(boolean active) {
        this.doneButton.f_93623_ = active;
        this.toggleTrackingOutputButton.f_93623_ = active;
        this.consoleCommandTextField.m_94186_(active);
        this.saveButton.f_93623_ = active;
    }

    protected void setPreviousOutputText(boolean trackOutput) {
        ((MultiLineTextFieldWidget)this.previousOutputTextField).setRawText(trackOutput ? this.commandExecutor.m_45437_().getString() : "-");
    }

    protected void commit() {
        this.trackOutput = this.toggleTrackingOutputButton.getValue();
        this.syncSettingsToServer(this.commandExecutor);
        if (!this.commandExecutor.m_45440_()) {
            this.commandExecutor.m_45433_(null);
        }
        ((MultiLineTextFieldWidget)this.consoleCommandTextField).resetModified();
        this.priorState.trackOutput = this.trackOutput;
    }

    protected void commitAndClose() {
        this.commit();
        assert (this.f_96541_ != null);
        this.m_7379_();
    }

    protected boolean wasModified() {
        return ((MultiLineTextFieldWidget)this.consoleCommandTextField).wasModified() || this.toggleTrackingOutputButton.getValue() != this.priorState.trackOutput;
    }

    protected abstract void syncSettingsToServer(BaseCommandBlock var1);

    public void m_88315_(GuiGraphics context, int mouseX, int mouseY, float delta) {
        this.m_280273_(context);
        context.m_280653_(this.f_96547_, SET_COMMAND_TEXT, this.f_96543_ / 2, 20, 0xFFFFFF);
        if (this.showOutput) {
            context.m_280430_(this.f_96547_, PREVIOUS_OUTPUT_TEXT, this.f_96543_ / 2 - 150, 40, 0xA0A0A0);
            this.previousOutputTextField.m_88315_(context, mouseX, mouseY, delta);
        } else {
            context.m_280430_(this.f_96547_, COMMAND_TEXT, this.f_96543_ / 2 - 150, 40, 0xA0A0A0);
            this.consoleCommandTextField.m_88315_(context, mouseX, mouseY, delta);
        }
        this.renderAsterisk(context, (LayoutElement)this.toggleTrackingOutputButton, this.toggleTrackingOutputButton.getValue() != this.priorState.trackOutput);
        for (Renderable drawable : ((ScreenAccessor)((Object)this)).getDrawables()) {
            if (drawable.equals((Object)this.sideWindow)) continue;
            drawable.m_88315_(context, mouseX, mouseY, delta);
        }
        this.darkenCheckbox(context, this.setTrackingOutputDefaultCheckbox);
        this.darkenCheckbox(context, this.setShowOutputDefaultCheckbox);
        PoseStack matrixStack = context.m_280168_();
        matrixStack.m_85836_();
        matrixStack.m_252880_(0.0f, 0.0f, 1.0f);
        this.sideWindow.m_88315_(context, mouseX, mouseY, delta);
        matrixStack.m_85849_();
    }

    private void darkenCheckbox(GuiGraphics context, Checkbox checkbox) {
        if (checkbox.f_93623_) {
            return;
        }
        context.m_280509_(checkbox.m_252754_(), checkbox.m_252907_(), checkbox.m_252754_() + checkbox.m_5711_(), checkbox.m_252907_() + checkbox.m_93694_(), -1610612736);
    }

    protected void renderAsterisk(GuiGraphics context, LayoutElement widget, boolean draw) {
        if (!draw) {
            return;
        }
        this.renderAsterisk(context, widget.m_252754_() + widget.m_5711_(), widget.m_252907_() - 4, draw);
    }

    protected void renderAsterisk(GuiGraphics context, int x, int y, boolean draw) {
        if (!draw) {
            return;
        }
        context.m_280488_(this.f_96547_, "*", x, y, 0xFFC000);
    }

    protected class CommandBlockState {
        public CommandBlockEntity.Mode type = CommandBlockEntity.Mode.REDSTONE;
        boolean conditional = false;
        public boolean needsRedstone = true;
        public boolean trackOutput = true;

        public CommandBlockState(CommandBlockEntity.Mode type, boolean conditional, boolean needsRedstone, boolean trackOutput) {
            this.type = type;
            this.conditional = conditional;
            this.needsRedstone = needsRedstone;
            this.trackOutput = trackOutput;
        }
    }
}

