/*
 * Decompiled with CFR 0.152.
 */
package bettercommandblockui.main.ui;

import bettercommandblockui.main.BetterCommandBlockUI;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class ScrollbarWidget
extends AbstractWidget {
    protected boolean dragging = false;
    protected boolean horizontal = false;
    protected double prevMouseX = 0.0;
    protected double prevMouseY = 0.0;
    protected double pos = 0.0;
    protected double scale;
    protected int length;
    protected int barLength;
    protected Consumer<Double> changedListener;

    public ScrollbarWidget(int x, int y, int width, int height, Component message, boolean horizontal) {
        super(x, y, width, height, message);
        this.horizontal = horizontal;
        this.scale = 1.0;
        this.length = horizontal ? width : height;
        this.barLength = (int)((double)this.length / this.scale);
    }

    public void m_87963_(GuiGraphics context, int mouseX, int mouseY, float delta) {
        if (!this.f_93624_) {
            return;
        }
        this.f_93622_ = this.checkHovered(mouseX, mouseY);
        this.renderFrame(context);
        this.renderSlider(context, mouseX, mouseY, delta);
    }

    protected void renderFrame(GuiGraphics context) {
        if (this.horizontal) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)BetterCommandBlockUI.SCROLLBAR_HORIZONTAL);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            context.m_280398_(BetterCommandBlockUI.SCROLLBAR_HORIZONTAL, this.m_252754_(), this.m_252907_(), 0, 0.0f, 0.0f, this.f_93618_ / 2, this.f_93619_, 256, 30);
            context.m_280398_(BetterCommandBlockUI.SCROLLBAR_HORIZONTAL, this.m_252754_() + this.f_93618_ / 2, this.m_252907_(), 0, (float)(256 - this.f_93618_ / 2), 0.0f, this.f_93618_ / 2, this.f_93619_, 256, 30);
        } else {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)BetterCommandBlockUI.SCROLLBAR_VERTICAL);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            context.m_280398_(BetterCommandBlockUI.SCROLLBAR_VERTICAL, this.m_252754_(), this.m_252907_(), 0, 0.0f, 0.0f, this.f_93618_, this.f_93619_ / 2, 30, 256);
            context.m_280398_(BetterCommandBlockUI.SCROLLBAR_VERTICAL, this.m_252754_(), this.m_252907_() + this.f_93619_ / 2, 0, 0.0f, (float)(256 - this.f_93619_ / 2), this.f_93618_, this.f_93619_ / 2, 30, 256);
        }
    }

    protected void renderSlider(GuiGraphics context, int mouseX, int mouseY, float delta) {
        int i;
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.f_93625_);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        int n = i = this.f_93622_ || this.dragging ? 1 : 0;
        if (this.horizontal) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)BetterCommandBlockUI.SCROLLBAR_HORIZONTAL);
            context.m_280398_(BetterCommandBlockUI.SCROLLBAR_HORIZONTAL, this.m_252754_() + (int)(this.pos * (double)(this.length - this.barLength)), this.m_252907_(), 0, 0.0f, (float)(10 + i * 10), this.barLength / 2, this.f_93619_, 256, 30);
            context.m_280398_(BetterCommandBlockUI.SCROLLBAR_HORIZONTAL, this.m_252754_() + (int)(this.pos * (double)(this.length - this.barLength)) + this.barLength / 2, this.m_252907_(), 0, (float)(256 - this.barLength / 2), (float)(10 + i * 10), this.barLength / 2, this.f_93619_, 256, 30);
        } else {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)BetterCommandBlockUI.SCROLLBAR_VERTICAL);
            context.m_280398_(BetterCommandBlockUI.SCROLLBAR_VERTICAL, this.m_252754_(), this.m_252907_() + (int)(this.pos * (double)(this.length - this.barLength)), 0, (float)(10 + i * 10), 0.0f, this.f_93618_, this.barLength / 2, 30, 256);
            context.m_280398_(BetterCommandBlockUI.SCROLLBAR_VERTICAL, this.m_252754_(), this.m_252907_() + (int)(this.pos * (double)(this.length - this.barLength)) + this.barLength / 2, 0, (float)(10 + i * 10), (float)(256 - this.barLength / 2), this.f_93618_, this.barLength / 2, 30, 256);
        }
    }

    public void setChangedListener(Consumer<Double> changedListener) {
        this.changedListener = changedListener;
    }

    protected boolean m_93680_(double mouseX, double mouseY) {
        if (!this.f_93624_) {
            return false;
        }
        return this.checkHovered(mouseX, mouseY);
    }

    protected boolean checkHovered(double mouseX, double mouseY) {
        if (this.horizontal) {
            return mouseX >= (double)this.m_252754_() + this.pos * (double)(this.length - this.barLength) && mouseY >= (double)this.m_252907_() && mouseX < (double)this.m_252754_() + this.pos * (double)(this.length - this.barLength) + (double)this.barLength && mouseY < (double)(this.m_252907_() + this.f_93619_);
        }
        return mouseX >= (double)this.m_252754_() && mouseY >= (double)this.m_252907_() + this.pos * (double)(this.length - this.barLength) && mouseX < (double)(this.m_252754_() + this.f_93618_) && mouseY < (double)this.m_252907_() + this.pos * (double)(this.length - this.barLength) + (double)this.barLength;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.m_7972_(button) && this.m_93680_(mouseX, mouseY)) {
            this.m_7435_(Minecraft.m_91087_().m_91106_());
            this.m_5716_(mouseX, mouseY);
            return true;
        }
        return false;
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.m_7972_(button)) {
            this.m_7691_(mouseX, mouseY);
            return true;
        }
        return false;
    }

    public void m_5716_(double mouseX, double mouseY) {
        if (!this.f_93624_) {
            return;
        }
        this.dragging = true;
        this.prevMouseX = mouseX;
        this.prevMouseY = mouseY;
    }

    public void m_7691_(double mouseX, double mouseY) {
        if (!this.f_93624_) {
            return;
        }
        this.dragging = false;
    }

    public void m_94757_(double mouseX, double mouseY) {
        super.m_94757_(mouseX, mouseY);
        if (this.dragging) {
            double distX = mouseX - this.prevMouseX;
            double distY = mouseY - this.prevMouseY;
            this.prevMouseX = mouseX;
            this.prevMouseY = mouseY;
            this.m_7212_(mouseX, mouseY, distX, distY);
        }
    }

    public void m_7212_(double mouseX, double mouseY, double distX, double distY) {
        if (this.dragging) {
            double posBefore = this.pos;
            this.pos = this.horizontal ? Math.min(Math.max(this.pos + distX / (double)(this.length - this.barLength), 0.0), 1.0) : Math.min(Math.max(this.pos + distY / (double)(this.length - this.barLength), 0.0), 1.0);
            if (this.changedListener != null && Math.abs(posBefore - this.pos) > 0.0) {
                this.changedListener.accept(this.pos);
            }
        }
    }

    public void setScale(double newScale) {
        this.scale = Math.max(newScale, 1.0);
        this.barLength = (int)((double)this.length / Math.min(this.scale, 8.0));
    }

    public void setHeight(int value) {
        this.f_93619_ = value;
    }

    public void updatePos(double newPos) {
        this.pos = Math.max(Math.min(newPos, 1.0), 0.0);
    }

    public double getPos() {
        return this.pos;
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        return super.m_6050_(mouseX, mouseY, amount);
    }

    public boolean m_5534_(char chr, int modifiers) {
        return super.m_5534_(chr, modifiers);
    }

    public void m_168797_(NarrationElementOutput builder) {
    }
}

