/*
 * Decompiled with CFR 0.152.
 */
package bettercommandblockui.main.ui;

import bettercommandblockui.main.BetterCommandBlockUI;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;

public class NotchedSlider
extends AbstractWidget {
    protected int subdivisions = 4;
    protected double pos = 0.0;
    protected boolean dragging = false;
    protected int length;
    protected double prevMouseX = 0.0;
    protected double prevMouseY = 0.0;
    protected Consumer<Double> changedListener;

    public NotchedSlider(int x, int y, int width, int height, Component message) {
        super(x, y, width, height, message);
        this.length = width;
    }

    public void m_87963_(GuiGraphics context, int mouseX, int mouseY, float delta) {
        context.m_280163_(BetterCommandBlockUI.SLIDER, this.m_252754_() - 2, this.m_252907_(), 0.0f, 0.0f, 4, 16, 512, 16);
        context.m_280163_(BetterCommandBlockUI.SLIDER, this.m_252754_() + 2, this.m_252907_(), 4.0f, 0.0f, this.m_5711_() - 4, 16, 512, 16);
        context.m_280163_(BetterCommandBlockUI.SLIDER, this.m_252754_() + this.m_5711_() - 2, this.m_252907_(), 508.0f, 0.0f, 4, 16, 512, 16);
        float step = 1.0f / (float)this.subdivisions;
        for (int i = 1; i < this.subdivisions; ++i) {
            context.m_280163_(BetterCommandBlockUI.SLIDER_NOTCH, (int)((float)this.m_252754_() + (float)i * step * (float)this.m_5711_()) - 2, this.m_252907_(), 0.0f, 0.0f, 4, 16, 4, 16);
        }
        context.m_280163_(BetterCommandBlockUI.SLIDER_PICK, (int)((double)this.m_252754_() + this.pos * (double)this.m_5711_() - 4.0), this.m_252907_(), 0.0f, this.f_93622_ ? 16.0f : 0.0f, 8, 16, 8, 32);
    }

    public void setChangedListener(Consumer<Double> changedListener) {
        this.changedListener = changedListener;
    }

    public double getValue() {
        return this.pos;
    }

    public int getSubdivisions() {
        return this.subdivisions;
    }

    protected void m_168797_(NarrationElementOutput builder) {
    }

    public void setPos(double value) {
        this.pos = this.snap(Math.min(Math.max(value, 0.0), 1.0), 1.0 / (double)this.subdivisions);
    }

    protected boolean m_93680_(double mouseX, double mouseY) {
        if (!this.f_93624_) {
            return false;
        }
        return this.checkHovered(mouseX, mouseY);
    }

    private boolean checkHovered(double mouseX, double mouseY) {
        return mouseX >= (double)this.m_252754_() && mouseY >= (double)this.m_252907_() && mouseX < (double)(this.m_252754_() + this.length) && mouseY < (double)(this.m_252907_() + this.f_93619_);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.m_7972_(button) && this.checkHovered(mouseX, mouseY) && this.m_93680_(mouseX, mouseY)) {
            this.dragging = true;
            this.m_7435_(Minecraft.m_91087_().m_91106_());
            this.m_5716_(mouseX, mouseY);
            return true;
        }
        this.dragging = false;
        return false;
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.m_7972_(button)) {
            this.dragging = false;
            this.m_7691_(mouseX, mouseY);
            return true;
        }
        return false;
    }

    public void m_5716_(double mouseX, double mouseY) {
        if (!this.f_93624_ || !this.checkHovered(mouseX, mouseY)) {
            this.dragging = false;
            return;
        }
        this.dragging = true;
        this.prevMouseX = mouseX;
        this.prevMouseY = mouseY;
        this.pos = this.snap(Math.min(Math.max((mouseX - (double)this.m_252754_()) / (double)this.length, 0.0), 1.0), 1.0 / (double)this.subdivisions);
        if (this.changedListener != null) {
            this.changedListener.accept(this.pos);
        }
    }

    public void m_7691_(double mouseX, double mouseY) {
        if (!this.f_93624_) {
            return;
        }
        this.dragging = false;
    }

    public void m_94757_(double mouseX, double mouseY) {
        super.m_94757_(mouseX, mouseY);
        if (this.dragging) {
            double distX = mouseX - this.prevMouseX;
            double distY = mouseY - this.prevMouseY;
            this.prevMouseX = mouseX;
            this.prevMouseY = mouseY;
            this.m_7212_(mouseX, mouseY, distX, distY);
        }
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.dragging) {
            this.m_7212_(mouseX, mouseY, deltaX, deltaY);
            return true;
        }
        return false;
    }

    public void m_7212_(double mouseX, double mouseY, double distX, double distY) {
        if (this.dragging) {
            double posBefore = this.pos;
            this.pos = this.snap(Math.min(Math.max((mouseX - (double)this.m_252754_()) / (double)this.length, 0.0), 1.0), 1.0 / (double)this.subdivisions);
            if (this.changedListener != null && Math.abs(posBefore) > 0.0) {
                this.changedListener.accept(this.pos);
            }
        }
    }

    public void setSubdivisions(int value) {
        this.subdivisions = value;
    }

    double snap(double x, double step) {
        return (double)Math.round(x / step) * step;
    }
}

