/*
 * Decompiled with CFR 0.152.
 */
package bettercommandblockui.main.ui;

import bettercommandblockui.main.BetterCommandBlockUI;
import bettercommandblockui.main.ui.MultiLineCommandSuggestor;
import bettercommandblockui.main.ui.ScrollbarWidget;
import bettercommandblockui.main.ui.TextFieldScrollbarWidget;
import bettercommandblockui.main.ui.screen.AbstractBetterCommandBlockScreen;
import bettercommandblockui.mixin.TextFieldWidgetAccessor;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Stack;
import net.minecraft.ChatFormatting;
import net.minecraft.SharedConstants;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.util.Tuple;

public class MultiLineTextFieldWidget
extends EditBox
implements GuiEventListener {
    private final int visibleChars = 20;
    private AbstractBetterCommandBlockScreen screen;
    private ScrollbarWidget scrollX;
    private ScrollbarWidget scrollY;
    private List<String> lines;
    private List<Integer> lineOffsets;
    private List<Integer> textOffsets;
    private List<Tuple<Style, Integer>> textColors;
    private int visibleLines = 11;
    private int scrolledLines = 0;
    private int horizontalOffset = 0;
    private int maxLineWidth = 30;
    private Tuple<Integer, Integer> cursorPosPreference;
    private boolean LShiftPressed;
    private boolean RShiftPressed = false;
    private boolean hasCommandSuggestor = false;
    private boolean textModified = false;
    private MultiLineCommandSuggestor suggestor;
    private TextFieldWidgetAccessor accessor = (TextFieldWidgetAccessor)((Object)this);
    private float timeSinceClick = 0.0f;

    public MultiLineTextFieldWidget(Font textRenderer, int x, int y, int width, int height, Component text, AbstractBetterCommandBlockScreen screen) {
        super(textRenderer, x, y, width, height, text);
        this.lines = new LinkedList<String>();
        this.lineOffsets = new LinkedList<Integer>();
        this.textOffsets = new LinkedList<Integer>();
        this.visibleLines = (height - 4) / 10;
        this.scrolledLines = 0;
        this.screen = screen;
        this.scrollX = new TextFieldScrollbarWidget(x, y + height + 1, width, 10, Component.m_130674_((String)""), this, true);
        this.scrollY = new TextFieldScrollbarWidget(x + width + 1, y, 10, height, Component.m_130674_((String)""), this, false);
        this.cursorPosPreference = new Tuple((Object)0, (Object)0);
    }

    public void m_93674_(int width) {
        this.f_93618_ = width;
        this.scrollX.m_93674_(width);
    }

    public void setHeight(int height) {
        this.f_93619_ = height;
        this.visibleLines = (height - 4) / 10;
        this.scrollY.setHeight(height);
    }

    public void m_252865_(int x) {
        super.m_252865_(x);
        this.scrollX.m_252865_(x);
        this.scrollY.m_252865_(x + this.f_93618_ + 1);
    }

    public void m_253211_(int y) {
        super.m_253211_(y);
        this.scrollX.m_253211_(y + this.f_93619_ + 1);
        this.scrollY.m_253211_(y);
    }

    public void m_88315_(GuiGraphics context, int mouseX, int mouseY, float delta) {
        int color;
        this.timeSinceClick += delta / 20.0f;
        if (!this.m_94213_()) {
            return;
        }
        if (this.accessor.getDrawsBackground()) {
            color = this.m_93696_() ? -1 : -6250336;
            context.m_280509_(this.m_252754_() - 1, this.m_252907_() - 1, this.m_252754_() + this.f_93618_ + 1, this.m_252907_() + this.f_93619_ + 1, color);
            context.m_280509_(this.m_252754_(), this.m_252907_(), this.m_252754_() + this.f_93618_, this.m_252907_() + this.f_93619_, -16777216);
        }
        int n = color = this.accessor.getEditable() ? this.accessor.getEditableColor() : this.accessor.getUneditableColor();
        if (this.hasCommandSuggestor) {
            if (this.lines.isEmpty()) {
                this.renderSuggestor(context, mouseX, mouseY);
                return;
            }
            for (int i = this.scrolledLines; i < this.scrolledLines + this.visibleLines && i < this.lines.size(); ++i) {
                String line = this.lines.get(i);
                if (line.length() < this.horizontalOffset) continue;
                line = line.substring(this.horizontalOffset);
                line = this.accessor.getTextRenderer().m_92834_(line, this.m_94210_());
                this.drawColoredLine(context, line, this.m_252754_() + 5, this.m_252907_() + 10 * (i - this.scrolledLines) + 5, i);
            }
        } else {
            this.drawRawText(context, this.accessor.getText(), this.m_252754_() + 5, this.m_252907_() + 5, color);
        }
        this.scrollX.m_88315_(context, mouseX, mouseY, delta);
        this.scrollY.m_88315_(context, mouseX, mouseY, delta);
        if (!this.hasCommandSuggestor) {
            return;
        }
        int selectionStart = this.accessor.getSelectionStart();
        int selectionEnd = this.accessor.getSelectionEnd();
        boolean selectingBackwards = false;
        if (selectionStart > selectionEnd) {
            int temp = selectionEnd;
            selectionEnd = selectionStart;
            selectionStart = temp;
            selectingBackwards = true;
        }
        Tuple<Integer, Integer> start = this.indexToLineAndOffset(selectionStart);
        Tuple<Integer, Integer> end = this.indexToLineAndOffset(selectionEnd);
        int firstSelectedLine = (Integer)start.m_14418_();
        int selectionStartOffset = (Integer)start.m_14419_();
        int lastSelectedLine = (Integer)end.m_14418_();
        int selectionEndOffset = (Integer)end.m_14419_();
        selectionStartOffset -= this.horizontalOffset;
        selectionEndOffset -= this.horizontalOffset;
        selectionStartOffset = Math.max(selectionStartOffset, 0);
        selectionEndOffset = Math.max(selectionEndOffset, 0);
        boolean renderVerticalCursor = selectionStart < this.accessor.getText().length();
        boolean verticalCursorVisible = this.m_93696_() && this.accessor.getFocusedTicks() / 6 % 2 == 0;
        context.m_280168_().m_85837_(0.0, 0.0, 0.1);
        RenderSystem.enableColorLogicOp();
        RenderSystem.logicOp((GlStateManager.LogicOp)GlStateManager.LogicOp.OR_REVERSE);
        for (int i = firstSelectedLine; i <= lastSelectedLine; ++i) {
            int x1;
            if (i < this.scrolledLines || i >= this.scrolledLines + this.visibleLines) continue;
            int x2 = x1 = this.m_252754_() + 5;
            int y = this.m_252907_() + 10 * (i - this.scrolledLines) + 5;
            String visibleLine = this.lines.get(i).substring(Math.min(this.horizontalOffset, this.lines.get(i).length()));
            if (i == firstSelectedLine) {
                x1 += this.accessor.getTextRenderer().m_92895_(visibleLine.substring(0, Math.min(selectionStartOffset, visibleLine.length())));
                if (verticalCursorVisible && !selectingBackwards) {
                    if (renderVerticalCursor) {
                        Objects.requireNonNull(this.accessor.getTextRenderer());
                        context.m_280509_(x1, y - 1, x1 + 1, y + 1 + 9, -3092272);
                    } else {
                        RenderSystem.disableColorLogicOp();
                        context.m_280488_(this.accessor.getTextRenderer(), "_", x1, y, -3092272);
                    }
                }
            }
            if (i == lastSelectedLine) {
                x2 += this.accessor.getTextRenderer().m_92895_(visibleLine.substring(0, Math.min(selectionEndOffset, visibleLine.length())));
                if (verticalCursorVisible && renderVerticalCursor && selectingBackwards) {
                    Objects.requireNonNull(this.accessor.getTextRenderer());
                    context.m_280509_(x2, y - 1, x2 + 1, y + 1 + 9, -3092272);
                }
            } else {
                x2 += this.m_94210_();
            }
            this.accessor.invokeDrawSelectionHighlight(context, x1, y, x2, y + 10);
        }
        RenderSystem.disableColorLogicOp();
        this.renderSuggestor(context, mouseX, mouseY);
    }

    private void renderSuggestor(GuiGraphics context, int mouseX, int mouseY) {
        if (this.suggestor.getY() > this.m_252907_() + this.m_93694_() || this.suggestor.getY() < this.m_252907_()) {
            return;
        }
        if (this.suggestor.getX() > this.m_252754_() + this.m_5711_() || this.suggestor.getX() < this.m_252754_()) {
            return;
        }
        this.suggestor.m_280540_(context, mouseX, mouseY);
    }

    private void drawColoredLine(GuiGraphics context, String content, int x, int y, int lineIndex) {
        Font textRenderer = this.accessor.getTextRenderer();
        int renderOffset = 0;
        int startOffset = this.textOffsets.get(lineIndex);
        int currentOffset = 0;
        int numSpaces = this.lineOffsets.get(lineIndex);
        if (this.textColors.size() > 1) {
            for (int i = 0; i < this.textColors.size() && currentOffset < content.length(); ++i) {
                int nextColorStart = i + 1 < this.textColors.size() ? (Integer)this.textColors.get(i + 1).m_14419_() : startOffset + content.length();
                nextColorStart -= startOffset;
                if ((nextColorStart += numSpaces - this.horizontalOffset) > currentOffset) {
                    int color;
                    String substring = content.substring(currentOffset, this.clamp(nextColorStart, currentOffset, content.length()));
                    try {
                        color = ((Style)this.textColors.get(i).m_14418_()).m_131135_().m_131265_();
                    }
                    catch (IndexOutOfBoundsException e) {
                        color = TextColor.m_131270_((ChatFormatting)ChatFormatting.GRAY).m_131265_();
                    }
                    context.m_280488_(textRenderer, substring, x + renderOffset, y, color);
                    currentOffset += substring.length();
                    renderOffset += textRenderer.m_92895_(substring);
                }
                if (currentOffset <= content.length()) {
                    continue;
                }
                break;
            }
        } else {
            int color;
            try {
                color = ((Style)this.textColors.get(0).m_14418_()).m_131135_().m_131265_();
            }
            catch (IndexOutOfBoundsException e) {
                color = TextColor.m_131270_((ChatFormatting)ChatFormatting.GRAY).m_131265_();
            }
            context.m_280488_(textRenderer, content, x, y, color);
        }
    }

    private void drawRawText(GuiGraphics context, String content, int x, int y, int color) {
        Font textRenderer = this.accessor.getTextRenderer();
        String line = content.substring(Math.max(Math.min(this.horizontalOffset, content.length() - 1), 0));
        String trimmedLine = textRenderer.m_92834_(line, this.m_94210_());
        context.m_280488_(textRenderer, trimmedLine, x, y, color);
    }

    private int pointToIndex(double x, double y) {
        if (this.lines.size() > 0) {
            Font textRenderer = this.accessor.getTextRenderer();
            int lineIndex = (int)Math.floor((y - (double)(this.m_252907_() + 5)) / 10.0) + this.scrolledLines;
            lineIndex = Math.max(Math.min(lineIndex, this.lines.size() - 1), 0);
            String line = this.lines.get(lineIndex);
            int offset = 0;
            if (line.length() > 0) {
                String visibleLine = line.substring(Math.min(this.horizontalOffset, line.length()));
                String trimmedLine = textRenderer.m_92834_(visibleLine, (int)(x - (double)(this.m_252754_() + 5)));
                boolean characterClicked = trimmedLine.length() < visibleLine.length();
                boolean lineEndLeftOfWindow = this.horizontalOffset > line.length() - 1;
                int lineOffset = this.lineOffsets.get(lineIndex);
                boolean offsetClicked = trimmedLine.length() < lineOffset - this.horizontalOffset;
                offset = Math.min(this.horizontalOffset + trimmedLine.length() - lineOffset, line.length() - lineOffset);
                offset = Math.max(offset, 0);
                offset += offsetClicked ? 1 : 0;
            }
            return this.textOffsets.get(lineIndex) + Math.max(offset, 0);
        }
        return 0;
    }

    private Tuple<Integer, Integer> indexToLineAndOffset(int index) {
        Tuple output = new Tuple((Object)0, (Object)0);
        for (int i = 0; i < this.lines.size(); ++i) {
            if (this.textOffsets.get(i) + (this.lines.get(i).length() - this.lineOffsets.get(i)) + 1 <= index) continue;
            output.m_145023_((Object)i);
            output.m_145025_((Object)(index - this.textOffsets.get(i) + this.lineOffsets.get(i)));
            return output;
        }
        return output;
    }

    public Tuple<Integer, Integer> getCharacterPos(int index) {
        int x;
        Tuple<Integer, Integer> output = this.indexToLineAndOffset(index);
        try {
            x = this.m_252754_() + 5 + this.accessor.getTextRenderer().m_92895_(this.lines.get((Integer)output.m_14418_()).substring(this.horizontalOffset, (Integer)output.m_14419_()));
        }
        catch (Exception e) {
            x = 0;
        }
        int y = this.m_252907_() + 5 + 10 * ((Integer)output.m_14418_() - this.scrolledLines);
        return new Tuple((Object)x, (Object)y);
    }

    public void setCommandSuggestor(MultiLineCommandSuggestor newSuggestor) {
        this.suggestor = newSuggestor;
        this.hasCommandSuggestor = true;
    }

    public void m_94164_(String text) {
        String string;
        int l;
        int i = Math.min(this.accessor.getSelectionStart(), this.accessor.getSelectionEnd());
        int j = Math.max(this.accessor.getSelectionStart(), this.accessor.getSelectionEnd());
        int k = this.accessor.invokeGetMaxLength() - this.accessor.getText().length() - (i - j);
        if (k < (l = (string = SharedConstants.m_136190_((String)text)).length())) {
            string = string.substring(0, k);
            l = k;
        }
        String string2 = new StringBuilder(this.accessor.getText()).replace(i, j, string).toString();
        if (!this.accessor.getTextPredicate().test(string2)) {
            return;
        }
        this.accessor.setTextVariable(string2);
        this.m_94196_(i + l);
        this.m_94208_(this.accessor.getSelectionStart());
        this.onChanged(this.accessor.getText(), true);
        this.updateScrollPositions();
    }

    private void erase(int offset) {
        if (Screen.m_96637_()) {
            this.m_94176_(offset);
        } else {
            this.m_94180_(offset);
        }
        this.onChanged(this.accessor.getText(), true);
        this.updateScrollPositions();
        this.textModified = true;
    }

    private boolean isAlphanumeric(char a) {
        return Character.isLetter(a) || Character.isDigit(a) || a == '_';
    }

    private int getWordLength(int offsetDir) {
        char current;
        int startIndex = this.accessor.getSelectionStart() + (offsetDir < 0 ? -1 : 0);
        String text = this.m_94155_();
        if (text.isEmpty() || startIndex < 0 || startIndex >= text.length()) {
            return 0;
        }
        char startChar = current = text.charAt(startIndex);
        boolean erasingAlphanumeric = this.isAlphanumeric(startChar);
        int endIndex = startIndex;
        while ((endIndex += offsetDir) >= 0 && endIndex < text.length()) {
            current = text.charAt(endIndex);
            if (erasingAlphanumeric && this.isAlphanumeric(current) || !erasingAlphanumeric && current == startChar) continue;
        }
        int min = Math.min(startIndex, endIndex -= offsetDir);
        int max = Math.max(startIndex, endIndex);
        return (max - min + 1) * offsetDir;
    }

    private void selectWord() {
        int forward = this.getWordLength(1);
        int backward = this.getWordLength(-1);
        this.accessor.setSelectionStart(this.accessor.getSelectionStart() + forward);
        this.accessor.setSelectionEnd(this.accessor.getSelectionStart() - forward + backward);
    }

    public void m_94176_(int wordOffset) {
        if (this.accessor.getText().isEmpty()) {
            return;
        }
        if (this.accessor.getSelectionEnd() != this.accessor.getSelectionStart()) {
            this.m_94164_("");
            return;
        }
        this.m_94180_(this.getWordLength(wordOffset));
    }

    public void m_94180_(int characterOffset) {
        int k;
        if (this.accessor.getText().isEmpty()) {
            return;
        }
        if (this.accessor.getSelectionEnd() != this.accessor.getSelectionStart()) {
            this.m_94164_("");
            return;
        }
        int i = this.accessor.invokeGetCursorPosWithOffset(characterOffset);
        int j = Math.min(i, this.accessor.getSelectionStart());
        if (j == (k = Math.max(i, this.accessor.getSelectionStart()))) {
            return;
        }
        String string = new StringBuilder(this.accessor.getText()).delete(j, k).toString();
        if (!this.accessor.getTextPredicate().test(string)) {
            return;
        }
        this.accessor.setTextVariable(string);
        this.m_94192_(j);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 340) {
            this.LShiftPressed = true;
        }
        if (keyCode == 344) {
            this.RShiftPressed = true;
        }
        if (!this.m_94204_()) {
            return false;
        }
        if (Screen.m_96634_((int)keyCode)) {
            this.m_94201_();
            this.m_94208_(0);
            return true;
        }
        if (Screen.m_96632_((int)keyCode)) {
            Minecraft.m_91087_().f_91068_.m_90911_(this.m_94173_());
            return true;
        }
        if (Screen.m_96630_((int)keyCode)) {
            if (this.accessor.getEditable()) {
                this.m_94164_(Minecraft.m_91087_().f_91068_.m_90876_());
            }
            return true;
        }
        if (Screen.m_96628_((int)keyCode)) {
            Minecraft.m_91087_().f_91068_.m_90911_(this.m_94173_());
            if (this.accessor.getEditable()) {
                this.m_94164_("");
            }
            return true;
        }
        switch (keyCode) {
            case 263: {
                if (Screen.m_96637_()) {
                    this.m_94192_(this.m_94207_() + this.getWordLength(-1));
                    this.updateScrollPositions();
                } else {
                    this.m_94188_(-1);
                }
                return true;
            }
            case 264: {
                this.moveCursorVertical(1);
                return true;
            }
            case 265: {
                this.moveCursorVertical(-1);
                return true;
            }
            case 262: {
                if (Screen.m_96637_()) {
                    this.m_94192_(this.m_94207_() + this.getWordLength(1));
                    this.updateScrollPositions();
                } else {
                    this.m_94188_(1);
                }
                return true;
            }
            case 259: {
                if (this.accessor.getEditable()) {
                    this.erase(-1);
                }
                return true;
            }
            case 261: {
                if (this.accessor.getEditable()) {
                    this.erase(1);
                }
                return true;
            }
            case 268: {
                this.m_94198_();
                this.updateScrollPositions();
                return true;
            }
            case 269: {
                this.m_94201_();
                this.updateScrollPositions();
                return true;
            }
        }
        return false;
    }

    public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 340) {
            this.LShiftPressed = false;
        }
        if (keyCode == 344) {
            this.RShiftPressed = false;
        }
        return super.m_7920_(keyCode, scanCode, modifiers);
    }

    public boolean m_5534_(char chr, int modifiers) {
        if (!this.m_94204_()) {
            return false;
        }
        if (SharedConstants.m_136188_((char)chr)) {
            if (this.accessor.getEditable()) {
                this.m_94164_(Character.toString(chr));
                if (BetterCommandBlockUI.BRACKET_AUTOCOMPLETE) {
                    if (chr == '{') {
                        this.m_94164_(Character.toString('}'));
                    } else if (chr == '[') {
                        this.m_94164_(Character.toString(']'));
                    }
                }
            }
            this.textModified = true;
            return true;
        }
        return false;
    }

    public void m_94144_(String text) {
        if (!this.accessor.getTextPredicate().test(text)) {
            return;
        }
        this.accessor.setTextVariable(text.length() > this.accessor.invokeGetMaxLength() ? text.substring(0, this.accessor.invokeGetMaxLength()) : text);
        this.m_94201_();
        this.m_94208_(this.accessor.getSelectionStart());
        this.onChanged(text, true);
    }

    public void setRawText(String text) {
        this.m_94144_(text);
    }

    public void refreshFormatting() {
        this.setRawText(this.m_94155_());
    }

    private void onChanged(String newText, boolean formatText) {
        if (this.accessor.getChangedListener() != null) {
            this.accessor.getChangedListener().accept(newText);
        }
        if (this.hasCommandSuggestor) {
            if (formatText) {
                this.formatText(newText);
            }
        } else {
            this.setUnformattedText(newText);
        }
        this.scrollY.setScale((double)this.lines.size() / (double)this.visibleLines);
        this.scrollX.setScale((double)this.maxLineWidth / 20.0);
        this.refreshSuggestorPos();
    }

    private void setUnformattedText(String text) {
        this.textColors = new LinkedList<Tuple<Style, Integer>>();
        this.textColors.add((Tuple<Style, Integer>)new Tuple((Object)Style.f_131099_.m_131140_(ChatFormatting.GRAY), (Object)0));
        this.lines = new LinkedList<String>();
        this.lines.add(text);
        this.lineOffsets = new LinkedList<Integer>();
        this.lineOffsets.add(0);
        this.textOffsets = new LinkedList<Integer>();
        this.textOffsets.add(0);
        this.maxLineWidth = 0;
        for (String line : this.lines) {
            this.maxLineWidth = Math.max(line.length(), this.maxLineWidth);
        }
    }

    private void submitLine(String line, int indent) {
        this.submitLine(line, indent, false);
    }

    private void submitLine(String line, int indent, boolean lastLine) {
        String trimmedLine;
        if (BetterCommandBlockUI.AVOID_DOUBLE_NEWLINE && !lastLine && (trimmedLine = line.replace("" + BetterCommandBlockUI.INDENTATION_CHAR, "")).isEmpty()) {
            return;
        }
        String indentChar = "" + BetterCommandBlockUI.INDENTATION_CHAR;
        this.lines.add(indentChar.repeat(indent * BetterCommandBlockUI.INDENTATION_FACTOR) + line);
        this.lineOffsets.add(indent * BetterCommandBlockUI.INDENTATION_FACTOR);
        if (this.textOffsets.isEmpty()) {
            this.textOffsets.add(0);
        } else {
            int index = this.textOffsets.size() - 1;
            this.textOffsets.add(this.textOffsets.get(index) + (this.lines.get(index).length() - this.lineOffsets.get(index)));
        }
    }

    private void formatText(String text) {
        Font textRenderer = Minecraft.m_91087_().f_91062_;
        this.textColors = new LinkedList<Tuple<Style, Integer>>();
        List<Tuple<Integer, Integer>> colorIndices = this.suggestor.getColors(text, 0);
        Stack<Integer> colorStack = new Stack<Integer>();
        int currentColorListIndex = 0;
        int currentHighlightColor = 0;
        this.lines = new LinkedList<String>();
        this.lineOffsets = new LinkedList<Integer>();
        this.textOffsets = new LinkedList<Integer>();
        final char[] textArr = text.toCharArray();
        boolean linestart = false;
        int parenthesesDepth = 0;
        boolean singleQuoteString = false;
        boolean doubleQuoteString = false;
        boolean escapeChar = false;
        Object currentLine = "";
        boolean newLine = false;
        int lastWordStart = 0;
        SpacePeeker peeker = new SpacePeeker(){

            @Override
            public Tuple<Integer, String> run(int startIndex) {
                StringBuilder outputLine = new StringBuilder();
                int tempCurrentIndex = startIndex + 1;
                if (tempCurrentIndex < textArr.length) {
                    char tempCurrent = textArr[tempCurrentIndex];
                    while (tempCurrentIndex < textArr.length - 1 && tempCurrent == ' ') {
                        outputLine.append(tempCurrent);
                        tempCurrent = textArr[++tempCurrentIndex];
                    }
                    startIndex = tempCurrentIndex - 1;
                }
                return new Tuple((Object)startIndex, (Object)outputLine.toString());
            }
        };
        block9: for (int currentIndex = 0; currentIndex < textArr.length; ++currentIndex) {
            while (currentColorListIndex < colorIndices.size() && (Integer)colorIndices.get(currentColorListIndex).m_14419_() < currentIndex) {
                colorStack.push((Integer)colorIndices.get(currentColorListIndex).m_14418_());
                ++currentColorListIndex;
            }
            char current = textArr[currentIndex];
            if (textRenderer.m_92895_((String)currentLine) > BetterCommandBlockUI.WRAPAROUND_WIDTH) {
                if (lastWordStart == 0) {
                    lastWordStart = ((String)currentLine).length();
                }
                String truncatedLine = ((String)currentLine).substring(0, Math.min(lastWordStart, ((String)currentLine).length()));
                this.submitLine(truncatedLine, parenthesesDepth);
                currentLine = truncatedLine.length() < ((String)currentLine).length() ? ((String)currentLine).substring(lastWordStart) : "";
                lastWordStart = 0;
            }
            int colorStartIndex = currentIndex;
            switch (current) {
                case '[': 
                case '{': {
                    escapeChar = false;
                    if (singleQuoteString || doubleQuoteString) {
                        currentLine = (String)currentLine + current;
                        newLine = false;
                        continue block9;
                    }
                    if (BetterCommandBlockUI.NEWLINE_PRE_OPEN_BRACKET) {
                        this.submitLine((String)currentLine, parenthesesDepth);
                        lastWordStart = 0;
                        currentLine = "";
                        newLine = true;
                    }
                    currentLine = (String)currentLine + current;
                    if (BetterCommandBlockUI.NEWLINE_POST_OPEN_BRACKET) {
                        Tuple<Integer, String> peekResult = peeker.run(currentIndex);
                        currentIndex = (Integer)peekResult.m_14418_();
                        currentLine = (String)currentLine + (String)peekResult.m_14419_();
                        this.submitLine((String)currentLine, parenthesesDepth);
                        lastWordStart = 0;
                        currentLine = "";
                        newLine = true;
                    }
                    if (newLine) {
                        ++parenthesesDepth;
                    }
                    if (currentColorListIndex <= 0) continue block9;
                    currentHighlightColor = (Integer)colorIndices.get(currentColorListIndex - 1).m_14418_();
                    colorStack.push(currentHighlightColor);
                    if (currentHighlightColor == 0) continue block9;
                    colorIndices.add(currentColorListIndex, (Tuple<Integer, Integer>)new Tuple((Object)this.getHighlightColorIndex(currentHighlightColor + 1), (Object)colorStartIndex));
                    ++currentColorListIndex;
                    continue block9;
                }
                case ']': 
                case '}': {
                    Tuple<Integer, String> peekResult;
                    escapeChar = false;
                    if (singleQuoteString || doubleQuoteString) {
                        currentLine = (String)currentLine + current;
                        newLine = false;
                        continue block9;
                    }
                    boolean indentationChanged = false;
                    if (BetterCommandBlockUI.NEWLINE_PRE_CLOSE_BRACKET) {
                        this.submitLine((String)currentLine, parenthesesDepth);
                        lastWordStart = 0;
                        currentLine = "";
                        newLine = true;
                        parenthesesDepth = Math.max(0, parenthesesDepth - 1);
                        indentationChanged = true;
                    }
                    currentLine = (String)currentLine + current;
                    if (BetterCommandBlockUI.NEWLINE_POST_CLOSE_BRACKET) {
                        peekResult = peeker.run(currentIndex);
                        currentIndex = (Integer)peekResult.m_14418_();
                        currentLine = (String)currentLine + (String)peekResult.m_14419_();
                        this.submitLine((String)currentLine, parenthesesDepth);
                        lastWordStart = 0;
                        currentLine = "";
                        newLine = true;
                        if (!indentationChanged) {
                            parenthesesDepth = Math.max(0, parenthesesDepth - 1);
                        }
                    }
                    if (currentColorListIndex <= 0 || (Integer)colorIndices.get(currentColorListIndex - 1).m_14418_() == 0) continue block9;
                    colorIndices.add(currentColorListIndex, (Tuple<Integer, Integer>)new Tuple((Object)((Integer)colorStack.pop()), (Object)(colorStartIndex + 1)));
                    ++currentColorListIndex;
                    continue block9;
                }
                case ',': {
                    escapeChar = false;
                    currentLine = (String)currentLine + current;
                    lastWordStart = ((String)currentLine).length();
                    Tuple<Integer, String> peekResult = peeker.run(currentIndex);
                    currentIndex = (Integer)peekResult.m_14418_();
                    currentLine = (String)currentLine + (String)peekResult.m_14419_();
                    if (!BetterCommandBlockUI.NEWLINE_POST_COMMA) continue block9;
                    this.submitLine((String)currentLine, parenthesesDepth);
                    lastWordStart = 0;
                    currentLine = "";
                    continue block9;
                }
                case ' ': {
                    currentLine = (String)currentLine + current;
                    newLine = false;
                    escapeChar = false;
                    lastWordStart = ((String)currentLine).length();
                    continue block9;
                }
                case '\\': {
                    escapeChar = !escapeChar;
                    currentLine = (String)currentLine + current;
                    newLine = false;
                    continue block9;
                }
                case '\"': {
                    if (!(BetterCommandBlockUI.FORMAT_STRINGS || singleQuoteString || escapeChar)) {
                        doubleQuoteString = !doubleQuoteString;
                        escapeChar = false;
                    }
                    currentLine = (String)currentLine + current;
                    continue block9;
                }
                case '\'': {
                    if (!BetterCommandBlockUI.FORMAT_STRINGS && !escapeChar) {
                        singleQuoteString = !singleQuoteString;
                        escapeChar = false;
                    }
                    currentLine = (String)currentLine + current;
                    continue block9;
                }
                default: {
                    currentLine = (String)currentLine + current;
                    newLine = false;
                    escapeChar = false;
                }
            }
        }
        if (!((String)currentLine).isEmpty()) {
            this.submitLine((String)currentLine, parenthesesDepth, true);
        }
        for (Tuple<Integer, Integer> p : colorIndices) {
            this.textColors.add((Tuple<Style, Integer>)new Tuple((Object)this.suggestor.getColor((Integer)p.m_14418_()), (Object)((Integer)p.m_14419_())));
        }
        this.maxLineWidth = 0;
        for (String line : this.lines) {
            this.maxLineWidth = Math.max(line.length(), this.maxLineWidth);
        }
    }

    private int getHighlightColorIndex(int i) {
        int index = i - 2;
        int count = this.suggestor.getHighlighColorCount();
        if (index < 0) {
            index += count;
        }
        return index % count + 2;
    }

    private boolean getHovered(double mouseX, double mouseY) {
        return mouseX >= (double)this.m_252754_() && mouseX < (double)(this.m_252754_() + this.f_93618_) && mouseY >= (double)this.m_252907_() && mouseY < (double)(this.m_252907_() + this.f_93619_);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (!this.m_94213_()) {
            return false;
        }
        this.scrollX.m_6375_(mouseX, mouseY, button);
        this.scrollY.m_6375_(mouseX, mouseY, button);
        boolean hovered = this.getHovered(mouseX, mouseY);
        if (this.accessor.getFocusUnlocked()) {
            this.m_93692_(hovered);
        }
        if (this.m_93696_() && hovered && button == 0) {
            int previousIndex = this.accessor.getSelectionStart();
            this.m_94192_(this.pointToIndex(mouseX, mouseY));
            this.cursorPosPreference = new Tuple((Object)((int)mouseX), (Object)((int)mouseY));
            if (this.timeSinceClick < 0.5f && previousIndex == this.accessor.getSelectionStart()) {
                this.selectWord();
            }
            this.timeSinceClick = 0.0f;
            return true;
        }
        return false;
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        if (!this.m_94213_()) {
            return false;
        }
        if (this.screen != null && this.screen.scroll(amount)) {
            return true;
        }
        if (this.LShiftPressed || this.RShiftPressed) {
            this.horizontalOffset = this.clamp(this.horizontalOffset - (int)amount * BetterCommandBlockUI.SCROLL_STEP_X, 0, this.maxLineWidth - 20);
            this.scrollX.updatePos((double)this.horizontalOffset / (double)(this.maxLineWidth - 20));
        } else {
            this.scrolledLines = this.clamp(this.scrolledLines - (int)amount * BetterCommandBlockUI.SCROLL_STEP_Y, 0, this.lines.size() - this.visibleLines);
            this.scrollY.updatePos((double)this.scrolledLines / (double)(this.lines.size() - this.visibleLines));
        }
        this.refreshSuggestorPos();
        return true;
    }

    public boolean isHovered(double mouseX, double mouseY) {
        return mouseX >= (double)this.m_252754_() && mouseX <= (double)(this.m_252754_() + this.m_5711_()) && mouseY >= (double)this.m_252907_() && mouseY <= (double)(this.m_252907_() + this.m_93694_());
    }

    public void m_94757_(double mouseX, double mouseY) {
        if (!this.m_94213_()) {
            return;
        }
        this.scrollX.m_94757_(mouseX, mouseY);
        this.scrollY.m_94757_(mouseX, mouseY);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (!this.m_94213_()) {
            return false;
        }
        this.scrollX.m_7212_(mouseX, mouseY, deltaX, deltaY);
        this.scrollY.m_7212_(mouseX, mouseY, deltaX, deltaY);
        if (this.isHovered(mouseX, mouseY) && this.m_93696_()) {
            this.m_94196_(this.pointToIndex(mouseX, mouseY));
        }
        return true;
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (!this.m_94213_()) {
            return false;
        }
        this.scrollX.m_6348_(mouseX, mouseY, button);
        this.scrollY.m_6348_(mouseX, mouseY, button);
        return true;
    }

    private void moveCursorVertical(int delta) {
        Tuple<Integer, Integer> lineAndOffset = this.indexToLineAndOffset(this.accessor.invokeGetCursorPosWithOffset(0));
        int yPreference = this.m_252907_() + 5 + ((Integer)lineAndOffset.m_14418_() - this.scrolledLines) * 10;
        this.cursorPosPreference.m_145025_((Object)(yPreference + delta * 10));
        int index = this.pointToIndex(((Integer)this.cursorPosPreference.m_14418_()).intValue(), ((Integer)this.cursorPosPreference.m_14419_()).intValue());
        this.m_94192_(index);
        this.updateScrollPositions();
    }

    public void m_94188_(int offset) {
        Font textRenderer = this.accessor.getTextRenderer();
        this.m_94192_(this.accessor.invokeGetCursorPosWithOffset(offset));
        if (this.lines.isEmpty()) {
            return;
        }
        Tuple<Integer, Integer> lineAndOffset = this.indexToLineAndOffset(this.accessor.invokeGetCursorPosWithOffset(0));
        String line = this.lines.get((Integer)lineAndOffset.m_14418_());
        int xPreference = this.m_252754_() + textRenderer.m_92895_(line.substring(0, Math.min(line.length() - 1, (Integer)lineAndOffset.m_14419_())));
        this.cursorPosPreference = new Tuple((Object)xPreference, (Object)(this.m_252907_() + 10 * ((Integer)lineAndOffset.m_14418_() - this.scrolledLines)));
        this.updateScrollPositions();
    }

    private void updateScrollPositions() {
        int xPos;
        boolean lineEndLeftOfWindow;
        Font textRenderer = this.accessor.getTextRenderer();
        Tuple<Integer, Integer> lineAndOffset = this.indexToLineAndOffset(this.accessor.invokeGetCursorPosWithOffset(0));
        if (this.lines.size() < 1) {
            this.horizontalOffset = 0;
            this.scrollY.updatePos(0.0);
            this.scrolledLines = 0;
            this.scrollX.updatePos(0.0);
            return;
        }
        Object line = this.lines.get((Integer)lineAndOffset.m_14418_());
        int maxIndex = ((String)line).length() - 1;
        boolean bl = lineEndLeftOfWindow = this.horizontalOffset > (Integer)lineAndOffset.m_14419_();
        if (lineEndLeftOfWindow) {
            int extension = 1 + this.horizontalOffset - (Integer)lineAndOffset.m_14419_();
            line = (String)line + "_".repeat(extension);
            xPos = textRenderer.m_92895_(((String)line).substring(this.clamp((Integer)lineAndOffset.m_14419_(), 0, maxIndex += extension), this.clamp(this.horizontalOffset, 0, maxIndex))) * -1;
        } else {
            xPos = textRenderer.m_92895_(((String)line).substring(this.clamp(this.horizontalOffset, 0, maxIndex), this.clamp((Integer)lineAndOffset.m_14419_(), 0, maxIndex)));
        }
        int textWidth = this.m_5711_() - 8;
        if (xPos <= 5) {
            this.horizontalOffset = this.clamp(this.horizontalOffset + (xPos - 10) / 5, 0, this.maxLineWidth - 20);
            this.scrollX.updatePos((double)this.horizontalOffset / (double)(this.maxLineWidth - 20));
        } else if (xPos >= textWidth) {
            this.horizontalOffset = this.clamp(this.horizontalOffset + (xPos - textWidth) / 5, 0, this.maxLineWidth - 20);
            this.scrollX.updatePos((double)this.horizontalOffset / (double)(this.maxLineWidth - 20));
        }
        int lineIndex = (Integer)lineAndOffset.m_14418_();
        if (lineIndex < this.scrolledLines) {
            this.scrolledLines = this.clamp(this.scrolledLines - (this.scrolledLines - lineIndex), 0, this.lines.size() - this.visibleLines);
            this.scrollY.updatePos((double)this.scrolledLines / (double)(this.lines.size() - this.visibleLines));
        } else if (lineIndex >= this.scrolledLines + this.visibleLines) {
            this.scrolledLines = this.clamp(this.scrolledLines + 1 + (lineIndex - this.scrolledLines - this.visibleLines), 0, this.lines.size() - this.visibleLines);
            this.scrollY.updatePos((double)this.scrolledLines / (double)(this.lines.size() - this.visibleLines));
        }
    }

    public void m_94192_(int cursor) {
        this.m_94196_(cursor);
        if (!Screen.m_96638_()) {
            this.m_94208_(this.accessor.getSelectionStart());
        }
        this.onChanged(this.accessor.getText(), false);
    }

    public void setScroll(double value) {
        this.scrolledLines = (int)Math.max(Math.round((double)(this.lines.size() - this.visibleLines) * value), 0L);
        this.refreshSuggestorPos();
    }

    public void setHorizontalOffset(double value) {
        this.horizontalOffset = (int)Math.max(Math.floor((double)(this.maxLineWidth - 20) * value), 0.0);
        this.refreshSuggestorPos();
    }

    public void m_94186_(boolean value) {
        super.m_94186_(value);
        if (this.suggestor != null) {
            this.suggestor.m_93922_(value);
        }
    }

    public boolean wasModified() {
        return this.textModified;
    }

    public void resetModified() {
        this.textModified = false;
    }

    void refreshSuggestorPos() {
        int selectionEnd;
        if (!this.hasCommandSuggestor) {
            return;
        }
        int selectionStart = this.accessor.getSelectionStart();
        if (selectionStart > (selectionEnd = this.accessor.getSelectionEnd())) {
            selectionStart = selectionEnd;
        }
        Tuple<Integer, Integer> cursor = this.indexToLineAndOffset(selectionStart);
        int selectionStartOffset = Math.max((Integer)cursor.m_14419_() - this.horizontalOffset, 0);
        Objects.requireNonNull(this.accessor.getTextRenderer());
        int fontHeight = 9 + 1;
        if (this.lines.isEmpty()) {
            this.suggestor.setPos(this.m_252754_() + 5, this.m_252907_() + 5 + fontHeight);
            this.suggestor.refreshRenderPos();
            return;
        }
        String line = this.lines.get((Integer)cursor.m_14418_());
        line = line.substring(this.clamp(this.horizontalOffset, 0, line.length()));
        int x = this.m_252754_() + 5 + this.accessor.getTextRenderer().m_92895_(line.substring(0, Math.min(selectionStartOffset, line.length())));
        int y = this.m_252907_() + 5 + fontHeight + ((Integer)cursor.m_14418_() - this.scrolledLines) * fontHeight;
        this.suggestor.setPos(x, y);
        this.suggestor.refreshRenderPos();
    }

    private int clamp(int i, int min, int max) {
        return Math.max(Math.min(i, max), min);
    }

    private double clamp(double i, double min, double max) {
        return Math.max(Math.min(i, max), min);
    }

    private void printStackTrace() {
        try {
            int[] i = new int[]{};
            i[1] = 0;
        }
        catch (Exception e) {
            StackTraceElement[] stacktrace;
            System.out.println("=================");
            for (StackTraceElement element : stacktrace = e.getStackTrace()) {
                System.out.println(element);
            }
            System.out.println("=================");
        }
    }

    private static interface SpacePeeker {
        public Tuple<Integer, String> run(int var1);
    }
}

