/*
 * Decompiled with CFR 0.152.
 */
package bettercommandblockui.main.ui;

import bettercommandblockui.main.ui.MultiLineTextFieldWidget;
import bettercommandblockui.mixin.CommandSuggestorAccessor;
import bettercommandblockui.mixin.SuggestionWindowAccessor;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.context.CommandContextBuilder;
import com.mojang.brigadier.context.ParsedArgument;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.CommandSuggestions;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Tuple;

public class MultiLineCommandSuggestor
extends CommandSuggestions {
    private static final List<Style> HIGHLIGHT_STYLES = (List)Stream.of(ChatFormatting.RED, ChatFormatting.GRAY, ChatFormatting.AQUA, ChatFormatting.YELLOW, ChatFormatting.GREEN, ChatFormatting.LIGHT_PURPLE, ChatFormatting.GOLD).map(arg_0 -> ((Style)Style.f_131099_).m_131140_(arg_0)).collect(ImmutableList.toImmutableList());
    private CommandSuggestorAccessor accessor = (CommandSuggestorAccessor)((Object)this);
    private Tuple<Integer, Integer> startPos = ((MultiLineTextFieldWidget)this.accessor.getTextField()).getCharacterPos(0);
    private int x;
    private int y;

    public MultiLineCommandSuggestor(Minecraft client, Screen owner, EditBox textField, Font textRenderer, boolean slashOptional, boolean suggestingWhenEmpty, int inWindowIndexOffset, int maxSuggestionSize, boolean chatScreenSized, int color) {
        super(client, owner, textField, textRenderer, slashOptional, suggestingWhenEmpty, inWindowIndexOffset, maxSuggestionSize, chatScreenSized, color);
    }

    public void m_280540_(GuiGraphics context, int mouseX, int mouseY) {
        context.m_280509_(this.x - 1, this.y - 1, this.x + 1, this.y + 1, 0xFF8000);
        if (this.accessor.getWindow() != null) {
            this.accessor.getWindow().m_280328_(context, mouseX, mouseY);
        } else {
            int i = 0;
            for (FormattedCharSequence orderedText : this.accessor.getMessages()) {
                int j = i * 10;
                context.m_280509_(this.x - 1, j + this.y, this.x + this.accessor.getWidth() + 1, j + 12 + this.y, this.accessor.getColor());
                context.m_280648_(this.accessor.getTextRenderer(), orderedText, this.x, this.y + j + 2, -1);
                ++i;
            }
        }
    }

    public void m_93881_() {
        super.m_93881_();
        this.refreshRenderPos();
    }

    public void refreshRenderPos() {
        block3: {
            try {
                SuggestionWindowAccessor window = (SuggestionWindowAccessor)this.accessor.getWindow();
                if (window == null) break block3;
                Rect2i area = new Rect2i(this.x, this.y, window.getArea().m_110090_(), window.getArea().m_110091_());
                window.setArea(area);
            }
            catch (Exception e) {
                System.out.println("[MLCS::refreshRenderPos] Error:");
                for (StackTraceElement el : e.getStackTrace()) {
                    System.out.println(el);
                }
            }
        }
    }

    public Style getColor(int colorIndex) {
        return HIGHLIGHT_STYLES.get(colorIndex);
    }

    public List<Tuple<Integer, Integer>> getColors(String original, int firstCharacterIndex) {
        int m;
        if (this.accessor.getParse() == null) {
            return new ArrayList<Tuple<Integer, Integer>>();
        }
        ParseResults<SharedSuggestionProvider> parse = this.accessor.getParse();
        ArrayList list = Lists.newArrayList();
        list.add(new Tuple((Object)1, (Object)0));
        int colorIndex = -1;
        CommandContextBuilder commandContextBuilder = parse.getContext();
        block0: do {
            for (ParsedArgument parsedArgument : commandContextBuilder.getArguments().values()) {
                colorIndex = this.bumpColorIndex(colorIndex);
                int k = Math.max(parsedArgument.getRange().getStart() - firstCharacterIndex, 0);
                if (k >= original.length()) continue block0;
                int l = Math.min(parsedArgument.getRange().getEnd() - firstCharacterIndex, original.length());
                if (l <= 0) continue;
                list.add(new Tuple((Object)(colorIndex + 2), (Object)k));
                list.add(new Tuple((Object)1, (Object)l));
            }
        } while ((commandContextBuilder = commandContextBuilder.getChild()) != null);
        if (parse.getReader().canRead() && (m = Math.max(parse.getReader().getCursor() - firstCharacterIndex, 0)) < original.length()) {
            int n = Math.min(m + parse.getReader().getRemainingLength(), original.length());
            list.add(new Tuple((Object)0, (Object)m));
        }
        return list;
    }

    public int getY() {
        return this.y;
    }

    public int getX() {
        return this.x;
    }

    public void setPos(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public int getHighlighColorCount() {
        return HIGHLIGHT_STYLES.size() - 2;
    }

    private int bumpColorIndex(int colorIndex) {
        return (colorIndex + 1) % this.getHighlighColorCount();
    }
}

