/*
 * Decompiled with CFR 0.152.
 */
package bettercommandblockui.main.ui;

import bettercommandblockui.main.ui.CyclingTooltipSupplier;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class CyclingTexturedButtonWidget<T>
extends AbstractButton {
    ResourceLocation textures;
    T[] values;
    CyclingTooltipSupplier tooltipSupplier;
    PressAction action;

    public CyclingTexturedButtonWidget(int x, int y, int width, int height, Component message, PressAction onPress, Screen screen, ResourceLocation textures, int initialIndex, T[] values) {
        super(x, y, width, height, message);
        this.textures = textures;
        this.values = values;
        this.tooltipSupplier = new CyclingTooltipSupplier(screen, initialIndex, new Component[values.length]);
        this.action = onPress;
        this.m_257544_(this.tooltipSupplier.getTooltip());
    }

    public CyclingTexturedButtonWidget(int x, int y, int width, int height, Component message, PressAction onPress, Screen screen, ResourceLocation textures, int initialIndex, T[] values, Component[] tooltips) {
        super(x, y, width, height, message);
        this.textures = textures;
        this.values = values;
        this.tooltipSupplier = new CyclingTooltipSupplier(screen, initialIndex, tooltips);
        this.action = onPress;
        this.m_257544_(this.tooltipSupplier.getTooltip());
    }

    public void m_5691_() {
        if (!this.f_93623_) {
            return;
        }
        this.tooltipSupplier.incrementIndex();
        this.m_257544_(this.tooltipSupplier.getTooltip());
        this.action.onPress(this);
    }

    public void m_5716_(double mouseX, double mouseY) {
        if (!this.f_93623_) {
            return;
        }
        if (mouseX > (double)this.m_252754_() && mouseX <= (double)(this.m_252754_() + this.m_5711_()) && mouseY > (double)this.m_252907_() && mouseY <= (double)(this.m_252907_() + this.m_93694_())) {
            this.tooltipSupplier.incrementIndex();
            this.m_257544_(this.tooltipSupplier.getTooltip());
            this.action.onPress(this);
        }
    }

    public T getValue() {
        return this.values[this.tooltipSupplier.getCurrentIndex()];
    }

    public void setIndex(int index) {
        this.tooltipSupplier.setIndex(index);
        this.m_257544_(this.tooltipSupplier.getTooltip());
    }

    public void setActive(boolean value) {
        this.f_93623_ = value;
    }

    public void m_87963_(GuiGraphics context, int mouseX, int mouseY, float delta) {
        Minecraft minecraftClient = Minecraft.m_91087_();
        Font textRenderer = minecraftClient.f_91062_;
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.textures);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.f_93625_);
        int i = this.f_93623_ ? (this.m_274382_() ? 2 : 1) : 0;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        context.m_280398_(this.textures, this.m_252754_(), this.m_252907_(), 0, (float)(this.tooltipSupplier.getCurrentIndex() * 20), (float)(i * 20), 20, 20, 20 * this.values.length, 60);
        int j = this.f_93623_ ? 0xFFFFFF : 0xA0A0A0;
        context.m_280653_(textRenderer, this.m_6035_(), this.m_252754_() + this.f_93618_ / 2, this.m_252907_() + (this.f_93619_ - 8) / 2, j | Mth.m_14167_((float)(this.f_93625_ * 255.0f)) << 24);
    }

    protected void m_168797_(NarrationElementOutput builder) {
    }

    public void setTooltipVisible(boolean value) {
        this.m_257544_(value ? this.tooltipSupplier.getTooltip() : null);
    }

    public static interface PressAction {
        public void onPress(CyclingTexturedButtonWidget var1);
    }
}

