/*
 * Decompiled with CFR 0.152.
 */
package bettercommandblockui.main.ui;

import bettercommandblockui.main.ui.ColorPicker;
import bettercommandblockui.main.ui.ScrollbarWidget;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FastColor;
import org.joml.Matrix4f;

public class ColorScrollbarWidget
extends ScrollbarWidget {
    int color;

    public ColorScrollbarWidget(int x, int y, int width, int height, Component message, ColorPicker.COLOR color) {
        super(x, y, width, height, message, true);
        int colorInt = switch (color) {
            default -> throw new IncompatibleClassChangeError();
            case ColorPicker.COLOR.RED -> 0xFF0000;
            case ColorPicker.COLOR.GREEN -> 65280;
            case ColorPicker.COLOR.BLUE -> 255;
        };
        this.color = 0xFF000000 | colorInt;
        this.setScale(width * 2);
        this.barLength = 1;
    }

    @Override
    protected void renderFrame(GuiGraphics context) {
        this.fillHorizontalGradient(context, this.m_252754_(), this.m_252907_(), this.m_252754_() + this.m_5711_(), this.m_252907_() + this.m_93694_(), -16777216, this.color);
    }

    @Override
    protected void renderSlider(GuiGraphics context, int mouseX, int mouseY, float delta) {
        boolean highlighted = this.checkHovered(mouseX, mouseY) || this.dragging;
        int posX = this.m_252754_() + (int)(this.pos * (double)(this.length - this.barLength));
        int posY = this.m_252907_();
        context.m_280509_(posX, posY, posX + 1, posY + 9, highlighted ? -1 : -6250336);
        context.m_280509_(posX + 1, posY + 1, posX + 2, posY + 10, -16777216);
    }

    private void fillHorizontalGradient(GuiGraphics context, int startX, int startY, int endX, int endY, int colorStart, int colorEnd) {
        VertexConsumer vertexConsumer = context.m_280091_().m_6299_(RenderType.m_285907_());
        float startA = (float)FastColor.ARGB32.m_13655_((int)colorStart) / 255.0f;
        float startR = (float)FastColor.ARGB32.m_13665_((int)colorStart) / 255.0f;
        float startG = (float)FastColor.ARGB32.m_13667_((int)colorStart) / 255.0f;
        float startB = (float)FastColor.ARGB32.m_13669_((int)colorStart) / 255.0f;
        float endA = (float)FastColor.ARGB32.m_13655_((int)colorEnd) / 255.0f;
        float endR = (float)FastColor.ARGB32.m_13665_((int)colorEnd) / 255.0f;
        float endG = (float)FastColor.ARGB32.m_13667_((int)colorEnd) / 255.0f;
        float endB = (float)FastColor.ARGB32.m_13669_((int)colorEnd) / 255.0f;
        Matrix4f matrix4f = context.m_280168_().m_85850_().m_252922_();
        vertexConsumer.m_252986_(matrix4f, (float)startX, (float)startY, 0.0f).m_85950_(startR, startG, startB, startA).m_5752_();
        vertexConsumer.m_252986_(matrix4f, (float)startX, (float)endY, 0.0f).m_85950_(startR, startG, startB, startA).m_5752_();
        vertexConsumer.m_252986_(matrix4f, (float)endX, (float)endY, 0.0f).m_85950_(endR, endG, endB, endA).m_5752_();
        vertexConsumer.m_252986_(matrix4f, (float)endX, (float)startY, 0.0f).m_85950_(endR, endG, endB, endA).m_5752_();
    }

    @Override
    protected boolean checkHovered(double mouseX, double mouseY) {
        if (!this.f_93624_) {
            return false;
        }
        return mouseX >= (double)this.m_252754_() && mouseY >= (double)this.m_252907_() && mouseX < (double)(this.m_252754_() + this.f_93618_) && mouseY < (double)(this.m_252907_() + this.f_93619_);
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.m_7972_(button) && this.checkHovered(mouseX, mouseY)) {
            this.m_7435_(Minecraft.m_91087_().m_91106_());
            this.m_5716_(mouseX, mouseY);
            return true;
        }
        return false;
    }

    @Override
    public void m_5716_(double mouseX, double mouseY) {
        if (!this.f_93624_) {
            return;
        }
        this.pos = Math.min(Math.max((mouseX - (double)this.m_252754_()) / (double)this.f_93618_, 0.0), 1.0);
        if (this.changedListener != null) {
            this.changedListener.accept(this.pos);
        }
        this.dragging = true;
        this.prevMouseX = mouseX;
        this.prevMouseY = mouseY;
    }

    @Override
    public void m_7212_(double mouseX, double mouseY, double distX, double distY) {
        if (this.dragging) {
            double posBefore = this.pos;
            this.pos = Math.min(Math.max(this.pos + distX / (double)(this.length - this.barLength), 0.0), 1.0);
            if (this.changedListener != null && Math.abs(posBefore - this.pos) > 0.0) {
                this.changedListener.accept(this.pos);
            }
        }
    }
}

