/*
 * Decompiled with CFR 0.152.
 */
package bettercommandblockui.main;

import bettercommandblockui.main.ui.screen.BetterCommandBlockScreen;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.BaseCommandBlock;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.CommandBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.CommandBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class ChainHandler {
    private BetterCommandBlockScreen screen;
    private BlockState current;
    private BlockState next;
    private BlockPos currentPos;
    private List<Tuple<BlockState, Direction>> prior;
    private Level world;

    public ChainHandler(BetterCommandBlockScreen screen, BaseCommandBlock executor) {
        this.screen = screen;
        assert (Minecraft.m_91087_().f_91074_ != null);
        this.world = Minecraft.m_91087_().f_91074_.m_9236_();
        this.currentPos = BlockPos.m_274446_((Position)executor.m_6607_());
        this.current = this.world.m_8055_(this.currentPos);
        this.prior = new LinkedList<Tuple<BlockState, Direction>>();
        this.scanChain();
    }

    public void scanChain() {
        final Direction currentDir = (Direction)this.current.m_61143_((Property)CommandBlock.f_51793_);
        BlockState up = this.getCommandBlock(this.currentPos.m_121955_(new Vec3i(0, 1, 0)));
        BlockState down = this.getCommandBlock(this.currentPos.m_121955_(new Vec3i(0, -1, 0)));
        BlockState north = this.getCommandBlock(this.currentPos.m_121955_(new Vec3i(0, 0, -1)));
        BlockState south = this.getCommandBlock(this.currentPos.m_121955_(new Vec3i(0, 0, 1)));
        BlockState east = this.getCommandBlock(this.currentPos.m_121955_(new Vec3i(1, 0, 0)));
        BlockState west = this.getCommandBlock(this.currentPos.m_121955_(new Vec3i(-1, 0, 0)));
        switch (currentDir) {
            case UP: {
                if (up == null) break;
                this.next = up;
                break;
            }
            case DOWN: {
                if (down == null) break;
                this.next = down;
                break;
            }
            case NORTH: {
                if (north == null) break;
                this.next = north;
                break;
            }
            case SOUTH: {
                if (south == null) break;
                this.next = south;
                break;
            }
            case EAST: {
                if (east == null) break;
                this.next = east;
                break;
            }
            case WEST: {
                if (west == null) break;
                this.next = west;
            }
        }
        if (up != null && up.m_61143_((Property)CommandBlock.f_51793_) == Direction.DOWN) {
            this.prior.add((Tuple<BlockState, Direction>)new Tuple((Object)up, (Object)Direction.UP));
        }
        if (down != null && down.m_61143_((Property)CommandBlock.f_51793_) == Direction.UP) {
            this.prior.add((Tuple<BlockState, Direction>)new Tuple((Object)down, (Object)Direction.DOWN));
        }
        if (north != null && north.m_61143_((Property)CommandBlock.f_51793_) == Direction.SOUTH) {
            this.prior.add((Tuple<BlockState, Direction>)new Tuple((Object)north, (Object)Direction.NORTH));
        }
        if (south != null && south.m_61143_((Property)CommandBlock.f_51793_) == Direction.NORTH) {
            this.prior.add((Tuple<BlockState, Direction>)new Tuple((Object)south, (Object)Direction.SOUTH));
        }
        if (east != null && east.m_61143_((Property)CommandBlock.f_51793_) == Direction.WEST) {
            this.prior.add((Tuple<BlockState, Direction>)new Tuple((Object)east, (Object)Direction.EAST));
        }
        if (west != null && west.m_61143_((Property)CommandBlock.f_51793_) == Direction.EAST) {
            this.prior.add((Tuple<BlockState, Direction>)new Tuple((Object)west, (Object)Direction.WEST));
        }
        if (!this.prior.isEmpty()) {
            this.prior.sort(new Comparator<Tuple<BlockState, Direction>>(){

                @Override
                public int compare(Tuple<BlockState, Direction> o1, Tuple<BlockState, Direction> o2) {
                    if (((BlockState)o1.m_14418_()).m_61143_((Property)CommandBlock.f_51793_) == currentDir) {
                        return -1;
                    }
                    if (((BlockState)o2.m_14418_()).m_61143_((Property)CommandBlock.f_51793_) == currentDir) {
                        return 1;
                    }
                    return 0;
                }
            });
        }
    }

    public boolean isInChain() {
        return this.next != null && this.next.m_60734_().equals(BuiltInRegistries.f_256975_.m_7745_(ResourceLocation.m_214293_((String)"minecraft", (String)"chain_command_block"))) || !this.prior.isEmpty() && this.current.m_60734_().equals(BuiltInRegistries.f_256975_.m_7745_(ResourceLocation.m_214293_((String)"minecraft", (String)"chain_command_block")));
    }

    public BlockState getNext() {
        return this.next;
    }

    public List<Tuple<BlockState, Direction>> getPrior() {
        return this.prior;
    }

    private BlockState getCommandBlock(BlockPos pos) {
        BlockEntity blockEntity = this.world.m_7702_(pos);
        if (blockEntity instanceof CommandBlockEntity) {
            return this.world.m_8055_(pos);
        }
        return null;
    }
}

