/*
 * Decompiled with CFR 0.152.
 */
package net.gqstavo.armamentarium.network;

import java.util.function.Supplier;
import net.gqstavo.armamentarium.ArmamentariumMod;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ArmamentariumModVariables {
    public static final Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        ArmamentariumMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    public static class PlayerVariablesSyncMessage {
        private final PlayerVariables data;

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this.data = new PlayerVariables();
            this.data.readNBT((Tag)buffer.m_130260_());
        }

        public PlayerVariablesSyncMessage(PlayerVariables data) {
            this.data = data;
        }

        public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_((CompoundTag)message.data.writeNBT());
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.m_91087_().f_91074_.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.samuraicutscene = message.data.samuraicutscene;
                    variables.samuraiframe = message.data.samuraiframe;
                    variables.twinblade_damage = message.data.twinblade_damage;
                    variables.comboraisable = message.data.comboraisable;
                    variables.chargeraisable = message.data.chargeraisable;
                    variables.norsewinds = message.data.norsewinds;
                    variables.norsewindable = message.data.norsewindable;
                    variables.asgardable = message.data.asgardable;
                    variables.marianacharges = message.data.marianacharges;
                    variables.reapercopy = message.data.reapercopy;
                    variables.offhandcopy = message.data.offhandcopy;
                    variables.helmetcopy = message.data.helmetcopy;
                    variables.chestplatecopy = message.data.chestplatecopy;
                    variables.leggingscopy = message.data.leggingscopy;
                    variables.bootscopy = message.data.bootscopy;
                    variables.reapersouls = message.data.reapersouls;
                    variables.hammercharges = message.data.hammercharges;
                    variables.crashhammer = message.data.crashhammer;
                    variables.spear1cooldown = message.data.spear1cooldown;
                    variables.spear2cooldown = message.data.spear2cooldown;
                    variables.spear3cooldown = message.data.spear3cooldown;
                    variables.spearpropeller = message.data.spearpropeller;
                    variables.dragonslayercharges = message.data.dragonslayercharges;
                    variables.pts_minicd = message.data.pts_minicd;
                    variables.ddx = message.data.ddx;
                    variables.ddy = message.data.ddy;
                    variables.ddz = message.data.ddz;
                    variables.defydeath = message.data.defydeath;
                    variables.dddimension = message.data.dddimension;
                    variables.ddcooldown = message.data.ddcooldown;
                    variables.impervious_cd = message.data.impervious_cd;
                    variables.ultraseverance = message.data.ultraseverance;
                    variables.hanakibamurder = message.data.hanakibamurder;
                    variables.claymorecharges = message.data.claymorecharges;
                    variables.ndaggercharges = message.data.ndaggercharges;
                    variables.speara = message.data.speara;
                    variables.spearb = message.data.spearb;
                    variables.spearc = message.data.spearc;
                    variables.angela = message.data.angela;
                    variables.angelb = message.data.angelb;
                    variables.hammera = message.data.hammera;
                    variables.hammerb = message.data.hammerb;
                    variables.vilethorn_charges = message.data.vilethorn_charges;
                    variables.bottlecd = message.data.bottlecd;
                    variables.lazulicharges = message.data.lazulicharges;
                    variables.callpurgatorycd = message.data.callpurgatorycd;
                    variables.damnified = message.data.damnified;
                    variables.flambergecharge = message.data.flambergecharge;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public boolean samuraicutscene = false;
        public double samuraiframe = 0.0;
        public double twinblade_damage = 0.0;
        public boolean comboraisable = true;
        public boolean chargeraisable = true;
        public boolean norsewinds = false;
        public boolean norsewindable = true;
        public boolean asgardable = false;
        public double marianacharges = 5.0;
        public ItemStack reapercopy = ItemStack.f_41583_;
        public ItemStack offhandcopy = ItemStack.f_41583_;
        public ItemStack helmetcopy = ItemStack.f_41583_;
        public ItemStack chestplatecopy = ItemStack.f_41583_;
        public ItemStack leggingscopy = ItemStack.f_41583_;
        public ItemStack bootscopy = ItemStack.f_41583_;
        public double reapersouls = 0.0;
        public double hammercharges = 3.0;
        public boolean crashhammer = false;
        public boolean spear1cooldown = true;
        public boolean spear2cooldown = true;
        public boolean spear3cooldown = true;
        public boolean spearpropeller = false;
        public double dragonslayercharges = 0.0;
        public boolean pts_minicd = true;
        public double ddx = 0.0;
        public double ddy = 0.0;
        public double ddz = 0.0;
        public boolean defydeath = false;
        public double dddimension = 0.0;
        public boolean ddcooldown = true;
        public boolean impervious_cd = false;
        public boolean ultraseverance = false;
        public double hanakibamurder = 0.0;
        public double claymorecharges = 0.0;
        public double ndaggercharges = 0.0;
        public boolean speara = false;
        public boolean spearb = false;
        public boolean spearc = false;
        public boolean angela = false;
        public boolean angelb = false;
        public boolean hammera = false;
        public boolean hammerb = false;
        public double vilethorn_charges = 3.0;
        public double bottlecd = 0.0;
        public double lazulicharges = 4.0;
        public boolean callpurgatorycd = true;
        public double damnified = 0.0;
        public double flambergecharge = 2.0;

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                ArmamentariumMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new PlayerVariablesSyncMessage(this));
            }
        }

        public Tag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128379_("samuraicutscene", this.samuraicutscene);
            nbt.m_128347_("samuraiframe", this.samuraiframe);
            nbt.m_128347_("twinblade_damage", this.twinblade_damage);
            nbt.m_128379_("comboraisable", this.comboraisable);
            nbt.m_128379_("chargeraisable", this.chargeraisable);
            nbt.m_128379_("norsewinds", this.norsewinds);
            nbt.m_128379_("norsewindable", this.norsewindable);
            nbt.m_128379_("asgardable", this.asgardable);
            nbt.m_128347_("marianacharges", this.marianacharges);
            nbt.m_128365_("reapercopy", (Tag)this.reapercopy.m_41739_(new CompoundTag()));
            nbt.m_128365_("offhandcopy", (Tag)this.offhandcopy.m_41739_(new CompoundTag()));
            nbt.m_128365_("helmetcopy", (Tag)this.helmetcopy.m_41739_(new CompoundTag()));
            nbt.m_128365_("chestplatecopy", (Tag)this.chestplatecopy.m_41739_(new CompoundTag()));
            nbt.m_128365_("leggingscopy", (Tag)this.leggingscopy.m_41739_(new CompoundTag()));
            nbt.m_128365_("bootscopy", (Tag)this.bootscopy.m_41739_(new CompoundTag()));
            nbt.m_128347_("reapersouls", this.reapersouls);
            nbt.m_128347_("hammercharges", this.hammercharges);
            nbt.m_128379_("crashhammer", this.crashhammer);
            nbt.m_128379_("spear1cooldown", this.spear1cooldown);
            nbt.m_128379_("spear2cooldown", this.spear2cooldown);
            nbt.m_128379_("spear3cooldown", this.spear3cooldown);
            nbt.m_128379_("spearpropeller", this.spearpropeller);
            nbt.m_128347_("dragonslayercharges", this.dragonslayercharges);
            nbt.m_128379_("pts_minicd", this.pts_minicd);
            nbt.m_128347_("ddx", this.ddx);
            nbt.m_128347_("ddy", this.ddy);
            nbt.m_128347_("ddz", this.ddz);
            nbt.m_128379_("defydeath", this.defydeath);
            nbt.m_128347_("dddimension", this.dddimension);
            nbt.m_128379_("ddcooldown", this.ddcooldown);
            nbt.m_128379_("impervious_cd", this.impervious_cd);
            nbt.m_128379_("ultraseverance", this.ultraseverance);
            nbt.m_128347_("hanakibamurder", this.hanakibamurder);
            nbt.m_128347_("claymorecharges", this.claymorecharges);
            nbt.m_128347_("ndaggercharges", this.ndaggercharges);
            nbt.m_128379_("speara", this.speara);
            nbt.m_128379_("spearb", this.spearb);
            nbt.m_128379_("spearc", this.spearc);
            nbt.m_128379_("angela", this.angela);
            nbt.m_128379_("angelb", this.angelb);
            nbt.m_128379_("hammera", this.hammera);
            nbt.m_128379_("hammerb", this.hammerb);
            nbt.m_128347_("vilethorn_charges", this.vilethorn_charges);
            nbt.m_128347_("bottlecd", this.bottlecd);
            nbt.m_128347_("lazulicharges", this.lazulicharges);
            nbt.m_128379_("callpurgatorycd", this.callpurgatorycd);
            nbt.m_128347_("damnified", this.damnified);
            nbt.m_128347_("flambergecharge", this.flambergecharge);
            return nbt;
        }

        public void readNBT(Tag tag) {
            CompoundTag nbt = (CompoundTag)tag;
            this.samuraicutscene = nbt.m_128471_("samuraicutscene");
            this.samuraiframe = nbt.m_128459_("samuraiframe");
            this.twinblade_damage = nbt.m_128459_("twinblade_damage");
            this.comboraisable = nbt.m_128471_("comboraisable");
            this.chargeraisable = nbt.m_128471_("chargeraisable");
            this.norsewinds = nbt.m_128471_("norsewinds");
            this.norsewindable = nbt.m_128471_("norsewindable");
            this.asgardable = nbt.m_128471_("asgardable");
            this.marianacharges = nbt.m_128459_("marianacharges");
            this.reapercopy = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("reapercopy"));
            this.offhandcopy = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("offhandcopy"));
            this.helmetcopy = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("helmetcopy"));
            this.chestplatecopy = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("chestplatecopy"));
            this.leggingscopy = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("leggingscopy"));
            this.bootscopy = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("bootscopy"));
            this.reapersouls = nbt.m_128459_("reapersouls");
            this.hammercharges = nbt.m_128459_("hammercharges");
            this.crashhammer = nbt.m_128471_("crashhammer");
            this.spear1cooldown = nbt.m_128471_("spear1cooldown");
            this.spear2cooldown = nbt.m_128471_("spear2cooldown");
            this.spear3cooldown = nbt.m_128471_("spear3cooldown");
            this.spearpropeller = nbt.m_128471_("spearpropeller");
            this.dragonslayercharges = nbt.m_128459_("dragonslayercharges");
            this.pts_minicd = nbt.m_128471_("pts_minicd");
            this.ddx = nbt.m_128459_("ddx");
            this.ddy = nbt.m_128459_("ddy");
            this.ddz = nbt.m_128459_("ddz");
            this.defydeath = nbt.m_128471_("defydeath");
            this.dddimension = nbt.m_128459_("dddimension");
            this.ddcooldown = nbt.m_128471_("ddcooldown");
            this.impervious_cd = nbt.m_128471_("impervious_cd");
            this.ultraseverance = nbt.m_128471_("ultraseverance");
            this.hanakibamurder = nbt.m_128459_("hanakibamurder");
            this.claymorecharges = nbt.m_128459_("claymorecharges");
            this.ndaggercharges = nbt.m_128459_("ndaggercharges");
            this.speara = nbt.m_128471_("speara");
            this.spearb = nbt.m_128471_("spearb");
            this.spearc = nbt.m_128471_("spearc");
            this.angela = nbt.m_128471_("angela");
            this.angelb = nbt.m_128471_("angelb");
            this.hammera = nbt.m_128471_("hammera");
            this.hammerb = nbt.m_128471_("hammerb");
            this.vilethorn_charges = nbt.m_128459_("vilethorn_charges");
            this.bottlecd = nbt.m_128459_("bottlecd");
            this.lazulicharges = nbt.m_128459_("lazulicharges");
            this.callpurgatorycd = nbt.m_128471_("callpurgatorycd");
            this.damnified = nbt.m_128459_("damnified");
            this.flambergecharge = nbt.m_128459_("flambergecharge");
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<Tag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("armamentarium", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.playerVariables.writeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            this.playerVariables.readNBT(nbt);
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            clone.reapercopy = original.reapercopy;
            clone.offhandcopy = original.offhandcopy;
            clone.helmetcopy = original.helmetcopy;
            clone.chestplatecopy = original.chestplatecopy;
            clone.leggingscopy = original.leggingscopy;
            clone.bootscopy = original.bootscopy;
            clone.reapersouls = original.reapersouls;
            clone.ddx = original.ddx;
            clone.ddy = original.ddy;
            clone.ddz = original.ddz;
            clone.defydeath = original.defydeath;
            clone.dddimension = original.dddimension;
            clone.ddcooldown = original.ddcooldown;
            clone.ultraseverance = original.ultraseverance;
            clone.hanakibamurder = original.hanakibamurder;
            if (!event.isWasDeath()) {
                clone.samuraicutscene = original.samuraicutscene;
                clone.samuraiframe = original.samuraiframe;
                clone.twinblade_damage = original.twinblade_damage;
                clone.comboraisable = original.comboraisable;
                clone.chargeraisable = original.chargeraisable;
                clone.norsewinds = original.norsewinds;
                clone.norsewindable = original.norsewindable;
                clone.asgardable = original.asgardable;
                clone.marianacharges = original.marianacharges;
                clone.hammercharges = original.hammercharges;
                clone.crashhammer = original.crashhammer;
                clone.spear1cooldown = original.spear1cooldown;
                clone.spear2cooldown = original.spear2cooldown;
                clone.spear3cooldown = original.spear3cooldown;
                clone.spearpropeller = original.spearpropeller;
                clone.dragonslayercharges = original.dragonslayercharges;
                clone.pts_minicd = original.pts_minicd;
                clone.impervious_cd = original.impervious_cd;
                clone.claymorecharges = original.claymorecharges;
                clone.ndaggercharges = original.ndaggercharges;
                clone.speara = original.speara;
                clone.spearb = original.spearb;
                clone.spearc = original.spearc;
                clone.angela = original.angela;
                clone.angelb = original.angelb;
                clone.hammera = original.hammera;
                clone.hammerb = original.hammerb;
                clone.vilethorn_charges = original.vilethorn_charges;
                clone.bottlecd = original.bottlecd;
                clone.lazulicharges = original.lazulicharges;
                clone.callpurgatorycd = original.callpurgatorycd;
                clone.damnified = original.damnified;
                clone.flambergecharge = original.flambergecharge;
            }
        }
    }
}

