/*
 * Decompiled with CFR 0.152.
 */
package cofh.archersparadox.common.entity.projectile;

import cofh.archersparadox.init.registries.ModEntities;
import cofh.archersparadox.init.registries.ModItems;
import cofh.core.common.config.IBaseConfig;
import cofh.lib.common.item.ArrowItemCoFH;
import cofh.lib.util.Utils;
import java.util.function.Supplier;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.network.NetworkHooks;

public class SlimeArrow
extends AbstractArrow {
    private static final float MAX_VELOCITY = 3.0f;
    private static final float MIN_VELOCITY = 0.5f;
    public static float defaultDamage = 0.5f;
    public static int defaultBounces = 4;
    public static int defaultKnockback = 4;
    public static boolean knockbackBoost = true;
    private int curBounces = 0;
    private int maxBounces = defaultBounces;
    public static final ArrowItemCoFH.IArrowFactory<AbstractArrow> FACTORY = new ArrowItemCoFH.IArrowFactory<AbstractArrow>(){

        public AbstractArrow createArrow(Level world, LivingEntity living) {
            return new SlimeArrow(world, living);
        }

        public AbstractArrow createArrow(Level world, double posX, double posY, double posZ) {
            return new SlimeArrow(world, posX, posY, posZ);
        }
    };
    public static final IBaseConfig CONFIG = new IBaseConfig(){
        private Supplier<Double> cfgDamage;
        private Supplier<Integer> cfgKnockback;
        private Supplier<Integer> cfgBounces;
        private Supplier<Boolean> cfgKnockbackBoost;

        public void apply(ForgeConfigSpec.Builder builder) {
            String name = "Slime Arrow";
            builder.push(name);
            this.cfgDamage = builder.comment("Adjust this to set the damage for the " + name + ". Vanilla Arrow value is 2.0.").defineInRange("Damage", (double)defaultDamage, 0.0, 16.0);
            this.cfgKnockback = builder.comment("Adjust this to set the inherent knockback strength of the " + name + ". Vanilla Arrow value is 0.").defineInRange("Knockback", defaultKnockback, 0, 16);
            this.cfgBounces = builder.comment("Adjust this to set the number of bounces for the " + name + ".").defineInRange("Bounces", defaultBounces, 1, 16);
            this.cfgKnockbackBoost = builder.comment("If TRUE, bounces are modified by knockback bonuses, such as the Punch Enchantment.").define("Knockback Boost", knockbackBoost);
            builder.pop();
        }

        public void refresh() {
            defaultDamage = this.cfgDamage.get().floatValue();
            defaultKnockback = this.cfgKnockback.get();
            defaultBounces = this.cfgBounces.get();
            knockbackBoost = this.cfgKnockbackBoost.get();
        }
    };

    public SlimeArrow(EntityType<? extends SlimeArrow> entityIn, Level worldIn) {
        super(entityIn, worldIn);
        this.f_36698_ = defaultDamage;
        this.m_36735_(0);
    }

    public SlimeArrow(Level worldIn, LivingEntity shooter) {
        super((EntityType)ModEntities.SLIME_ARROW.get(), shooter, worldIn);
        this.f_36698_ = defaultDamage;
        this.m_36735_(0);
    }

    public SlimeArrow(Level worldIn, double x, double y, double z) {
        super((EntityType)ModEntities.SLIME_ARROW.get(), x, y, z, worldIn);
        this.f_36698_ = defaultDamage;
        this.m_36735_(0);
    }

    protected ItemStack m_7941_() {
        return new ItemStack((ItemLike)ModItems.SLIME_ARROW_ITEM.get());
    }

    protected void m_6532_(HitResult raytraceResultIn) {
        if (raytraceResultIn.m_6662_() != HitResult.Type.MISS) {
            this.m_36740_(SoundEvents.f_12391_);
            if (raytraceResultIn.m_6662_() == HitResult.Type.ENTITY) {
                this.m_5790_((EntityHitResult)raytraceResultIn);
            } else if (raytraceResultIn.m_6662_() == HitResult.Type.BLOCK) {
                Vec3 motion = this.m_20184_();
                if (motion.m_82556_() < 0.5 || this.m_20069_() || this.curBounces >= this.maxBounces) {
                    super.m_6532_(raytraceResultIn);
                    return;
                }
                BlockHitResult blockraytraceresult = (BlockHitResult)raytraceResultIn;
                switch (blockraytraceresult.m_82434_()) {
                    case DOWN: 
                    case UP: {
                        this.m_20334_(motion.f_82479_, motion.f_82480_ * -1.0, motion.f_82481_);
                        break;
                    }
                    case NORTH: 
                    case SOUTH: {
                        this.m_20334_(motion.f_82479_, motion.f_82480_, motion.f_82481_ * -1.0);
                        break;
                    }
                    case WEST: 
                    case EAST: {
                        this.m_20334_(motion.f_82479_ * -1.0, motion.f_82480_, motion.f_82481_);
                    }
                }
                double f = motion.m_165924_();
                this.f_19857_ = (float)(Mth.m_14136_((double)motion.f_82479_, (double)motion.f_82481_) * 57.2957763671875);
                this.f_19858_ = (float)(Mth.m_14136_((double)motion.f_82480_, (double)f) * 57.2957763671875);
                this.f_19859_ = this.f_19857_;
                this.f_19860_ = this.f_19858_;
                ++this.curBounces;
                --this.f_36699_;
            }
        }
    }

    public void m_20254_(int seconds) {
    }

    public void m_36762_(boolean critical) {
    }

    public void m_36735_(int knockbackStrengthIn) {
        super.m_36735_(defaultKnockback + knockbackStrengthIn);
        if (knockbackBoost) {
            this.maxBounces = defaultBounces + this.f_36699_;
        }
    }

    public void m_36767_(byte level) {
    }

    public void m_6686_(double x, double y, double z, float velocity, float inaccuracy) {
        super.m_6686_(x, y, z, Math.min(velocity, 3.0f), inaccuracy);
    }

    public void m_8119_() {
        super.m_8119_();
        if ((!this.f_36703_ || this.m_36797_()) && Utils.isClientWorld((Level)this.f_19853_)) {
            Vec3 vec3d = this.m_20184_();
            double d1 = vec3d.f_82479_;
            double d2 = vec3d.f_82480_;
            double d0 = vec3d.f_82481_;
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123753_, this.m_20185_() + d1 * 0.25, this.m_20186_() + d2 * 0.25, this.m_20189_() + d0 * 0.25, -d1, -d2 + 0.2, -d0);
        }
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("ArrowData", this.curBounces);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.curBounces = compound.m_128451_("ArrowData");
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

