/*
 * Decompiled with CFR 0.152.
 */
package cofh.archersparadox.common.entity.projectile;

import cofh.archersparadox.init.registries.ModEntities;
import cofh.archersparadox.init.registries.ModItems;
import cofh.core.common.config.IBaseConfig;
import cofh.lib.common.item.ArrowItemCoFH;
import java.util.function.Supplier;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.network.NetworkHooks;

public class QuartzArrow
extends AbstractArrow {
    public static float defaultDamage = 2.5f;
    public static int defaultKnockback = 1;
    public static byte defaultPierce = 0;
    public static final ArrowItemCoFH.IArrowFactory<AbstractArrow> FACTORY = new ArrowItemCoFH.IArrowFactory<AbstractArrow>(){

        public AbstractArrow createArrow(Level world, LivingEntity living) {
            return new QuartzArrow(world, living);
        }

        public AbstractArrow createArrow(Level world, double posX, double posY, double posZ) {
            return new QuartzArrow(world, posX, posY, posZ);
        }
    };
    public static final IBaseConfig CONFIG = new IBaseConfig(){
        private Supplier<Double> cfgDamage;
        private Supplier<Integer> cfgKnockback;
        private Supplier<Integer> cfgPierce;

        public void apply(ForgeConfigSpec.Builder builder) {
            String name = "Quartz Arrow";
            builder.push(name);
            this.cfgDamage = builder.comment("Adjust this to set the damage for the " + name + ". Vanilla Arrow value is 2.0.").defineInRange("Damage", (double)defaultDamage, 0.0, 16.0);
            this.cfgKnockback = builder.comment("Adjust this to set the inherent knockback strength of the " + name + ". Vanilla Arrow value is 0.").defineInRange("Knockback", defaultKnockback, 0, 16);
            this.cfgPierce = builder.comment("Adjust this to set the inherent pierce of the " + name + ". Vanilla Arrow value is 0.").defineInRange("Piercing", (int)defaultPierce, 0, 16);
            builder.pop();
        }

        public void refresh() {
            defaultDamage = this.cfgDamage.get().floatValue();
            defaultKnockback = this.cfgKnockback.get();
            defaultPierce = this.cfgPierce.get().byteValue();
        }
    };

    public QuartzArrow(EntityType<QuartzArrow> type, Level worldIn) {
        super(type, worldIn);
        this.f_36698_ = defaultDamage;
        this.m_36735_(0);
        this.m_36767_((byte)0);
    }

    public QuartzArrow(Level worldIn, LivingEntity shooter) {
        super((EntityType)ModEntities.QUARTZ_ARROW.get(), shooter, worldIn);
        this.f_36698_ = defaultDamage;
        this.m_36735_(0);
        this.m_36767_((byte)0);
    }

    public QuartzArrow(Level worldIn, double x, double y, double z) {
        super((EntityType)ModEntities.QUARTZ_ARROW.get(), x, y, z, worldIn);
        this.f_36698_ = defaultDamage;
        this.m_36735_(0);
        this.m_36767_((byte)0);
    }

    protected ItemStack m_7941_() {
        return new ItemStack((ItemLike)ModItems.QUARTZ_ARROW_ITEM.get());
    }

    public void m_36735_(int knockbackStrengthIn) {
        super.m_36735_(defaultKnockback + knockbackStrengthIn);
    }

    public void m_36767_(byte level) {
        super.m_36767_((byte)(defaultPierce + level));
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

