/*
 * Decompiled with CFR 0.152.
 */
package cofh.archersparadox.common.entity.projectile;

import cofh.archersparadox.init.registries.ModEntities;
import cofh.archersparadox.init.registries.ModItems;
import cofh.core.common.config.IBaseConfig;
import cofh.core.init.CoreMobEffects;
import cofh.core.init.CoreParticles;
import cofh.core.util.AreaUtils;
import cofh.lib.common.item.ArrowItemCoFH;
import cofh.lib.util.Utils;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.NetworkHooks;

public class FrostArrow
extends AbstractArrow {
    private static final int CLOUD_DURATION = 20;
    public static float defaultDamage = 1.5f;
    public static int effectAmplifier = 1;
    public static int effectDuration = 100;
    public static int effectRadius = 4;
    public static boolean permanentLava = true;
    public static boolean permanentWater = true;
    public boolean discharged;
    public static final ArrowItemCoFH.IArrowFactory<AbstractArrow> FACTORY = new ArrowItemCoFH.IArrowFactory<AbstractArrow>(){

        public AbstractArrow createArrow(Level world, LivingEntity living) {
            return new FrostArrow(world, living);
        }

        public AbstractArrow createArrow(Level world, double posX, double posY, double posZ) {
            return new FrostArrow(world, posX, posY, posZ);
        }
    };
    public static final IBaseConfig CONFIG = new IBaseConfig(){
        private Supplier<Double> cfgDamage;
        private Supplier<Integer> cfgDuration;
        private Supplier<Integer> cfgRadius;
        private Supplier<Boolean> cfgPermanentLava;
        private Supplier<Boolean> cfgPermanentWater;

        public void apply(ForgeConfigSpec.Builder builder) {
            String name = "Frost Arrow";
            builder.push(name);
            this.cfgDamage = builder.comment("Adjust this to set the damage for the " + name + ". Vanilla Arrow value is 2.0.").defineInRange("Damage", (double)defaultDamage, 0.0, 16.0);
            this.cfgDuration = builder.comment("Adjust this to set the chill duration for the " + name + ". (In ticks; there are 20 ticks per second).").defineInRange("Chill Duration", effectDuration, 20, 1200);
            this.cfgRadius = builder.comment("Adjust this to set the effect radius for the " + name + ". Set to 0 to disable, but that would be boring.").defineInRange("Radius", effectRadius, 0, 16);
            this.cfgPermanentLava = builder.comment("If TRUE, " + name + "s will convert Lava into Obsidian. If FALSE, Glossed Magma.").define("Permanent Lava Freeze", permanentLava);
            this.cfgPermanentWater = builder.comment("If TRUE, " + name + "s will convert Water into Ice. If FALSE, Frosted Ice.").define("Permanent Water Freeze", permanentWater);
            builder.pop();
        }

        public void refresh() {
            defaultDamage = this.cfgDamage.get().floatValue();
            effectDuration = this.cfgDuration.get();
            effectRadius = this.cfgRadius.get();
            permanentLava = this.cfgPermanentLava.get();
            permanentWater = this.cfgPermanentWater.get();
        }
    };

    public FrostArrow(EntityType<? extends FrostArrow> entityIn, Level worldIn) {
        super(entityIn, worldIn);
        this.f_36698_ = defaultDamage;
    }

    public FrostArrow(Level worldIn, LivingEntity shooter) {
        super((EntityType)ModEntities.FROST_ARROW.get(), shooter, worldIn);
        this.f_36698_ = defaultDamage;
    }

    public FrostArrow(Level worldIn, double x, double y, double z) {
        super((EntityType)ModEntities.FROST_ARROW.get(), x, y, z, worldIn);
        this.f_36698_ = defaultDamage;
    }

    protected ItemStack m_7941_() {
        return this.discharged ? new ItemStack((ItemLike)Items.f_42412_) : new ItemStack((ItemLike)ModItems.FROST_ARROW_ITEM.get());
    }

    protected void m_6532_(HitResult raytraceResultIn) {
        super.m_6532_(raytraceResultIn);
        if (!this.discharged && raytraceResultIn.m_6662_() != HitResult.Type.MISS) {
            if (effectRadius > 0) {
                if (Utils.isServerWorld((Level)this.f_19853_)) {
                    AreaUtils.freezeNearbyGround((Entity)this, (Level)this.f_19853_, (BlockPos)this.m_20183_(), (int)effectRadius);
                    AreaUtils.freezeSurfaceWater((Entity)this, (Level)this.f_19853_, (BlockPos)this.m_20183_(), (int)effectRadius, (boolean)permanentWater);
                    AreaUtils.freezeSurfaceLava((Entity)this, (Level)this.f_19853_, (BlockPos)this.m_20183_(), (int)effectRadius, (boolean)permanentLava);
                    this.makeAreaOfEffectCloud();
                }
                this.discharged = true;
            }
            if (this.f_36696_ != null && this.f_36696_.m_60819_() != Fluids.f_76191_.m_76145_()) {
                this.f_36703_ = false;
                this.m_20256_(this.m_20184_().m_82542_((double)(this.f_19796_.m_188501_() * 0.2f), (double)(this.f_19796_.m_188501_() * 0.2f), (double)(this.f_19796_.m_188501_() * 0.2f)));
                this.f_36697_ = 0;
            }
        }
    }

    protected void m_5790_(EntityHitResult raytraceResultIn) {
        super.m_5790_(raytraceResultIn);
        Entity entity = raytraceResultIn.m_82443_();
        if (entity.m_6060_()) {
            entity.m_20095_();
        }
        if (!entity.m_20147_() && entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            living.m_7292_(new MobEffectInstance((MobEffect)CoreMobEffects.CHILLED.get(), effectDuration, effectAmplifier, false, false));
        }
    }

    public void m_20254_(int seconds) {
    }

    public void m_36762_(boolean critical) {
    }

    public void m_36735_(int knockbackStrengthIn) {
    }

    public void m_36767_(byte level) {
    }

    public void m_8119_() {
        VoxelShape voxelshape;
        BlockPos blockpos;
        BlockState blockstate;
        if (!this.f_19853_.f_46443_) {
            this.m_20115_(6, this.m_142038_());
        }
        if (!this.f_150164_) {
            this.m_146852_(GameEvent.f_157778_, this.m_19749_());
            this.f_150164_ = true;
        }
        if (!this.f_37246_) {
            this.f_37246_ = this.m_37276_();
        }
        this.m_6075_();
        boolean flag = this.m_36797_();
        Vec3 vec3 = this.m_20184_();
        if (this.f_19860_ == 0.0f && this.f_19859_ == 0.0f) {
            double d0 = vec3.m_165924_();
            this.m_146922_((float)(Mth.m_14136_((double)vec3.f_82479_, (double)vec3.f_82481_) * 57.2957763671875));
            this.m_146926_((float)(Mth.m_14136_((double)vec3.f_82480_, (double)d0) * 57.2957763671875));
            this.f_19859_ = this.m_146908_();
            this.f_19860_ = this.m_146909_();
        }
        if (!((blockstate = this.f_19853_.m_8055_(blockpos = this.m_20183_())).m_60795_() || flag || (voxelshape = blockstate.m_60812_((BlockGetter)this.f_19853_, blockpos)).m_83281_())) {
            Vec3 vec31 = this.m_20182_();
            for (AABB aabb : voxelshape.m_83299_()) {
                if (!aabb.m_82338_(blockpos).m_82390_(vec31)) continue;
                this.f_36703_ = true;
                break;
            }
        }
        if (this.f_36706_ > 0) {
            --this.f_36706_;
        }
        if (this.m_20070_() || blockstate.m_60713_(Blocks.f_152499_)) {
            this.m_20095_();
        }
        if (this.f_36703_ && !flag) {
            if (this.f_36696_ != blockstate && this.m_36798_()) {
                this.m_36799_();
            } else if (!this.f_19853_.f_46443_) {
                this.m_6901_();
            }
            ++this.f_36704_;
        } else {
            Vec3 vec33;
            this.f_36704_ = 0;
            Vec3 vec32 = this.m_20182_();
            BlockHitResult hitresult = this.f_19853_.m_45547_(new ClipContext(vec32, vec33 = vec32.m_82549_(vec3), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
            if (hitresult.m_6662_() != HitResult.Type.MISS) {
                vec33 = hitresult.m_82450_();
            }
            while (!this.m_213877_()) {
                EntityHitResult entityhitresult = this.m_6351_(vec32, vec33);
                if (entityhitresult != null) {
                    hitresult = entityhitresult;
                }
                if (hitresult != null && hitresult.m_6662_() == HitResult.Type.ENTITY) {
                    Player owner;
                    Entity entity = ((EntityHitResult)hitresult).m_82443_();
                    Entity entity1 = this.m_19749_();
                    if (entity instanceof Player && entity1 instanceof Player && !(owner = (Player)entity1).m_7099_((Player)entity)) {
                        hitresult = null;
                        entityhitresult = null;
                    }
                }
                if (hitresult != null && hitresult.m_6662_() != HitResult.Type.MISS && !flag && !ForgeEventFactory.onProjectileImpact((Projectile)this, (HitResult)hitresult)) {
                    this.m_6532_((HitResult)hitresult);
                    this.f_19812_ = true;
                }
                if (entityhitresult == null || this.m_36796_() <= 0) break;
                hitresult = null;
            }
            vec3 = this.m_20184_();
            double d5 = vec3.f_82479_;
            double d6 = vec3.f_82480_;
            double d1 = vec3.f_82481_;
            this.f_19853_.m_7106_((ParticleOptions)((SimpleParticleType)CoreParticles.FROST.get()), this.m_20185_() + d5 * 0.25, this.m_20186_() + d6 * 0.25, this.m_20189_() + d1 * 0.25, -d5, -d6 + 0.2, -d1);
            double d7 = this.m_20185_() + d5;
            double d2 = this.m_20186_() + d6;
            double d3 = this.m_20189_() + d1;
            double d4 = vec3.m_165924_();
            if (flag) {
                this.m_146922_((float)(Mth.m_14136_((double)(-d5), (double)(-d1)) * 57.2957763671875));
            } else {
                this.m_146922_((float)(Mth.m_14136_((double)d5, (double)d1) * 57.2957763671875));
            }
            this.m_146926_((float)(Mth.m_14136_((double)d6, (double)d4) * 57.2957763671875));
            this.m_146926_(FrostArrow.m_37273_((float)this.f_19860_, (float)this.m_146909_()));
            this.m_146922_(FrostArrow.m_37273_((float)this.f_19859_, (float)this.m_146908_()));
            float f = 0.99f;
            if (this.m_20069_()) {
                for (int j = 0; j < 4; ++j) {
                    this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123795_, d7 - d5 * 0.25, d2 - d6 * 0.25, d3 - d1 * 0.25, d5, d6, d1);
                }
                f = this.m_6882_();
            }
            this.m_20256_(vec3.m_82490_((double)f));
            if (!this.m_20068_() && !flag) {
                Vec3 vec34 = this.m_20184_();
                this.m_20334_(vec34.f_82479_, vec34.f_82480_ - (double)0.05f, vec34.f_82481_);
            }
            this.m_6034_(d7, d2, d3);
            this.m_20101_();
        }
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("ArrowData", this.discharged);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.discharged = compound.m_128471_("ArrowData");
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    private void makeAreaOfEffectCloud() {
        AreaEffectCloud cloud = new AreaEffectCloud(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_());
        cloud.m_19712_(1.0f);
        cloud.m_19724_((ParticleOptions)((SimpleParticleType)CoreParticles.FROST.get()));
        cloud.m_19734_(20);
        cloud.m_19740_(0);
        cloud.m_19738_(((float)effectRadius - cloud.m_19743_()) / (float)cloud.m_19748_());
        this.f_19853_.m_7967_((Entity)cloud);
    }
}

