/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.another_furniture.block;

import com.starfish_studios.another_furniture.block.properties.ModBlockStateProperties;
import com.starfish_studios.another_furniture.block.properties.VerticalConnectionType;
import com.starfish_studios.another_furniture.util.block.BlockPart;
import com.starfish_studios.another_furniture.util.block.HammerableBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class ShutterBlock
extends Block
implements SimpleWaterloggedBlock,
HammerableBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final EnumProperty<VerticalConnectionType> VERTICAL = ModBlockStateProperties.VERTICAL_CONNECTION_TYPE;
    public static final BooleanProperty OPEN = BlockStateProperties.f_61446_;
    public static final EnumProperty<DoorHingeSide> HINGE = BlockStateProperties.f_61394_;
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final IntegerProperty VARIANT = ModBlockStateProperties.VARIANT;
    protected static final VoxelShape EAST = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0);
    protected static final VoxelShape WEST = Block.m_49796_((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SOUTH = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0);
    protected static final VoxelShape NORTH = Block.m_49796_((double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape[] SHAPES = new VoxelShape[]{SOUTH, WEST, NORTH, EAST};

    public ShutterBlock(int defaultVariant, BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(VERTICAL, (Comparable)((Object)VerticalConnectionType.SINGLE))).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)VARIANT, (Comparable)Integer.valueOf(defaultVariant))).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        int shape = ((Direction)state.m_61143_((Property)FACING)).m_122416_() + (((Boolean)state.m_61143_((Property)OPEN)).booleanValue() ? (state.m_61143_(HINGE) == DoorHingeSide.LEFT ? 3 : 1) : 0);
        return SHAPES[shape % 4];
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Vec3 clickLocation;
        Direction facing = context.m_8125_().m_122424_();
        BlockState state = (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)facing);
        Level level = context.m_43725_();
        BlockPos clickedPos = context.m_8083_();
        state = (BlockState)state.m_61124_(HINGE, (Comparable)(BlockPart.get1D(clickedPos, clickLocation = context.m_43720_(), facing.m_122427_(), 2) == 0 ? DoorHingeSide.LEFT : DoorHingeSide.RIGHT));
        boolean powered = level.m_276867_(clickedPos);
        return (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(powered))).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(powered))).m_61124_(VERTICAL, (Comparable)((Object)this.getType(state, level.m_8055_(clickedPos.m_7494_()), level.m_8055_(clickedPos.m_7495_()))))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(level.m_6425_(context.m_8083_()).m_76152_() == Fluids.f_76193_));
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (level.f_46443_) {
            return;
        }
        boolean powered = level.m_276867_(pos);
        if (powered != (Boolean)state.m_61143_((Property)POWERED)) {
            if ((Boolean)state.m_61143_((Property)OPEN) != powered) {
                state = (BlockState)state.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(powered));
                this.toggleShutters((BlockState)state.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(!powered)), level, pos, null);
            }
            if (((Boolean)(state = (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(powered))).m_61143_((Property)WATERLOGGED)).booleanValue()) {
                level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
            }
        }
        VerticalConnectionType type = this.getType(state, level.m_8055_(pos.m_7494_()), level.m_8055_(pos.m_7495_()));
        state = (BlockState)state.m_61124_(VERTICAL, (Comparable)((Object)type));
        level.m_7731_(pos, state, 3);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (this.tryHammerBlock((Property)VARIANT, state, (LevelAccessor)level, pos, player, hand)) {
            return InteractionResult.SUCCESS;
        }
        return this.toggleShutters(state, level, pos, player);
    }

    public InteractionResult toggleShutters(BlockState state, Level level, BlockPos pos, Player player) {
        state = (BlockState)state.m_61122_((Property)OPEN);
        level.m_7731_(pos, state, 3);
        if (player == null || !player.m_6047_()) {
            this.toggleShutters(state, level, pos, (Boolean)state.m_61143_((Property)OPEN));
        }
        level.m_5594_(null, pos, ShutterBlock.shutterSound((Boolean)state.m_61143_((Property)OPEN)), SoundSource.BLOCKS, 1.0f, 1.0f);
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    public void toggleShutters(BlockState state, Level level, BlockPos pos, boolean open) {
        int i;
        BlockState updateState = state;
        BlockPos updatePos = pos;
        if (state.m_61143_(VERTICAL) == VerticalConnectionType.MIDDLE || state.m_61143_(VERTICAL) == VerticalConnectionType.BOTTOM) {
            BlockState above;
            int heightUp = level.m_6042_().f_156648_() - updatePos.m_123342_();
            for (i = 0; i < heightUp && (above = level.m_8055_(updatePos.m_7494_())).m_60713_(state.m_60734_()) && above.m_61143_((Property)FACING) == updateState.m_61143_((Property)FACING) && above.m_61143_(HINGE) == updateState.m_61143_(HINGE) && (Boolean)above.m_61143_((Property)OPEN) != open; ++i) {
                updateState = above;
                updatePos = updatePos.m_7494_();
                level.m_7731_(updatePos, (BlockState)updateState.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(open)), 3);
            }
        }
        if (state.m_61143_(VERTICAL) == VerticalConnectionType.MIDDLE || state.m_61143_(VERTICAL) == VerticalConnectionType.TOP) {
            BlockState below;
            updateState = state;
            updatePos = pos;
            int heightDown = level.m_6042_().f_156647_() - updatePos.m_123342_();
            heightDown = heightDown < 0 ? -heightDown : heightDown;
            for (i = 0; i < heightDown && (below = level.m_8055_(updatePos.m_7495_())).m_60713_(state.m_60734_()) && below.m_61143_((Property)FACING) == updateState.m_61143_((Property)FACING) && below.m_61143_(HINGE) == updateState.m_61143_(HINGE) && (Boolean)below.m_61143_((Property)OPEN) != open; ++i) {
                updateState = below;
                updatePos = updatePos.m_7495_();
                level.m_7731_(updatePos, (BlockState)updateState.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(open)), 3);
            }
        }
    }

    public static SoundEvent shutterSound(boolean open) {
        return open ? SoundEvents.f_12629_ : SoundEvents.f_12628_;
    }

    public VerticalConnectionType getType(BlockState state, BlockState above, BlockState below) {
        boolean up = this.isConnected(state, above);
        boolean down = this.isConnected(state, below);
        if (up && down) {
            return VerticalConnectionType.MIDDLE;
        }
        if (up) {
            return VerticalConnectionType.BOTTOM;
        }
        if (down) {
            return VerticalConnectionType.TOP;
        }
        return VerticalConnectionType.SINGLE;
    }

    public boolean isConnected(BlockState state, BlockState other) {
        return other.m_60713_(state.m_60734_()) && other.m_61143_((Property)FACING) == state.m_61143_((Property)FACING) && other.m_61143_((Property)OPEN) == state.m_61143_((Property)OPEN) && other.m_61143_(HINGE) == state.m_61143_(HINGE) && ((Integer)other.m_61143_((Property)VARIANT)).equals(state.m_61143_((Property)VARIANT));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, VERTICAL, OPEN, HINGE, VARIANT, POWERED, WATERLOGGED});
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return super.m_7417_(state, direction, neighborState, level, currentPos, neighborPos);
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }
}

