/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.mixin;

import io.wispforest.accessories.api.events.extra.ExtraEventHandler;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.PowderSnowBlock;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PowderSnowBlock.class})
public abstract class PowderSnowBlockMixin {
    @Inject(method={"canEntityWalkOnPowderSnow"}, at={@At(value="HEAD")}, cancellable=true)
    private static void adjustSnowWalkingAbility(Entity entity, CallbackInfoReturnable<Boolean> cir) {
        LivingEntity livingEntity;
        TriState state;
        if (entity instanceof LivingEntity && (state = ExtraEventHandler.allowWalkingOnSnow(livingEntity = (LivingEntity)entity)) != TriState.DEFAULT) {
            cir.setReturnValue((Object)state.orElse(false));
        }
    }
}

