/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import io.wispforest.accessories.AccessoriesInternals;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.slot.SlotEntryReference;
import io.wispforest.accessories.impl.AccessoriesTags;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EnchantmentHelper.class})
public abstract class EnchantmentHelperMixin {
    @WrapOperation(method={"getEnchantmentLevel(Lnet/minecraft/world/item/enchantment/Enchantment;Lnet/minecraft/world/entity/LivingEntity;)I"}, at={@At(value="INVOKE", target="Ljava/util/Map;values()Ljava/util/Collection;")})
    private static Collection<ItemStack> addAccessoriesStacks(Map instance, Operation<Collection<ItemStack>> original, @Local(argsOnly=true) Enchantment enchantment, @Local(argsOnly=true) LivingEntity entity) {
        ArrayList<ItemStack> returnValue = new ArrayList<ItemStack>((Collection)original.call(new Object[]{instance}));
        AccessoriesCapability capability = entity.accessoriesCapability();
        if (capability != null) {
            returnValue.addAll(capability.getAllEquipped().stream().map(SlotEntryReference::stack).toList());
        }
        return returnValue;
    }

    @WrapOperation(method={"getRandomItemWith(Lnet/minecraft/world/item/enchantment/Enchantment;Lnet/minecraft/world/entity/LivingEntity;Ljava/util/function/Predicate;)Ljava/util/Map$Entry;"}, at={@At(value="INVOKE", target="Ljava/util/Map;isEmpty()Z")})
    private static boolean wrapMapCheck(Map instance, Operation<Boolean> original, Enchantment enchantment, LivingEntity livingEntity, Predicate<ItemStack> stackCondition, @Share(value="slotEntries") LocalRef<List<SlotEntryReference>> slotEntries) {
        Boolean bl = (Boolean)original.call(new Object[]{instance});
        if (EnchantmentHelperMixin.enchantmentValidForRedirect(enchantment) && livingEntity.accessoriesCapability() != null) {
            List<SlotEntryReference> allEquippedAccessories = livingEntity.accessoriesCapability().getAllEquipped().stream().filter(entryReference -> {
                ItemStack stack = entryReference.stack();
                int level = EnchantmentHelper.m_44843_((Enchantment)enchantment, (ItemStack)stack);
                return level > 0 && stackCondition.test(stack);
            }).toList();
            slotEntries.set(allEquippedAccessories);
            bl = bl != false && allEquippedAccessories.isEmpty();
        } else {
            slotEntries.set(List.of());
        }
        return bl;
    }

    @Inject(method={"getRandomItemWith(Lnet/minecraft/world/item/enchantment/Enchantment;Lnet/minecraft/world/entity/LivingEntity;Ljava/util/function/Predicate;)Ljava/util/Map$Entry;"}, at={@At(value="INVOKE", target="Ljava/util/List;isEmpty()Z", shift=At.Shift.BEFORE)}, cancellable=true)
    private static void attemptRedirectToAccessories(Enchantment enchantment, LivingEntity livingEntity, Predicate<ItemStack> stackCondition, CallbackInfoReturnable<@Nullable Map.Entry<EquipmentSlot, ItemStack>> cir, @Local(ordinal=0) List<Map.Entry<EquipmentSlot, ItemStack>> list, @Share(value="slotEntries") LocalRef<List<SlotEntryReference>> slotEntries) {
        if (!EnchantmentHelperMixin.enchantmentValidForRedirect(enchantment)) {
            return;
        }
        List allEquippedAccessories = (List)slotEntries.get();
        if (allEquippedAccessories.isEmpty()) {
            return;
        }
        SlotEntryReference selectedRef = (SlotEntryReference)allEquippedAccessories.get(livingEntity.m_217043_().m_188503_(allEquippedAccessories.size()));
        list.add(Map.entry(AccessoriesInternals.INTERNAL_SLOT, selectedRef.stack()));
    }

    @Unique
    private static boolean enchantmentValidForRedirect(Enchantment enchantment) {
        return ((Holder.Reference)BuiltInRegistries.f_256876_.m_203636_((ResourceKey)BuiltInRegistries.f_256876_.m_7854_((Object)enchantment).orElseThrow()).orElseThrow()).m_203656_(AccessoriesTags.VALID_FOR_REDIRECTION);
    }
}

