/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.endec.format.nbt;

import io.wispforest.endec.Deserializer;
import io.wispforest.endec.Endec;
import io.wispforest.endec.SelfDescribedDeserializer;
import io.wispforest.endec.SerializationContext;
import io.wispforest.endec.Serializer;
import io.wispforest.endec.util.RecursiveDeserializer;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CollectionTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import org.jetbrains.annotations.Nullable;

public class NbtDeserializer
extends RecursiveDeserializer<Tag>
implements SelfDescribedDeserializer<Tag> {
    protected NbtDeserializer(Tag element) {
        super((Object)element);
    }

    public static NbtDeserializer of(Tag element) {
        return new NbtDeserializer(element);
    }

    private <N extends Tag> N getAs(Tag element, Class<N> clazz) {
        if (clazz.isInstance(element)) {
            return (N)((Tag)clazz.cast(element));
        }
        throw new IllegalStateException("Expected a " + clazz.getSimpleName() + ", found a " + element.getClass().getSimpleName());
    }

    public byte readByte(SerializationContext ctx) {
        return this.getAs((Tag)this.getValue(), ByteTag.class).m_7063_();
    }

    public short readShort(SerializationContext ctx) {
        return this.getAs((Tag)this.getValue(), ShortTag.class).m_7053_();
    }

    public int readInt(SerializationContext ctx) {
        return this.getAs((Tag)this.getValue(), IntTag.class).m_7047_();
    }

    public long readLong(SerializationContext ctx) {
        return this.getAs((Tag)this.getValue(), LongTag.class).m_7046_();
    }

    public float readFloat(SerializationContext ctx) {
        return this.getAs((Tag)this.getValue(), FloatTag.class).m_7057_();
    }

    public double readDouble(SerializationContext ctx) {
        return this.getAs((Tag)this.getValue(), DoubleTag.class).m_7061_();
    }

    public int readVarInt(SerializationContext ctx) {
        return this.getAs((Tag)this.getValue(), NumericTag.class).m_7047_();
    }

    public long readVarLong(SerializationContext ctx) {
        return this.getAs((Tag)this.getValue(), NumericTag.class).m_7046_();
    }

    public boolean readBoolean(SerializationContext ctx) {
        return this.getAs((Tag)this.getValue(), ByteTag.class).m_7063_() != 0;
    }

    public String readString(SerializationContext ctx) {
        return this.getAs((Tag)this.getValue(), StringTag.class).m_7916_();
    }

    public byte[] readBytes(SerializationContext ctx) {
        return this.getAs((Tag)this.getValue(), ByteArrayTag.class).m_128227_();
    }

    public <V> Optional<V> readOptional(SerializationContext ctx, Endec<V> endec) {
        if (this.isReadingStructField()) {
            return Optional.of(endec.decode(ctx, (Deserializer)this));
        }
        Deserializer.Struct struct = this.struct();
        return (Boolean)struct.field("present", ctx, Endec.BOOLEAN) != false ? Optional.of(struct.field("value", ctx, endec)) : Optional.empty();
    }

    public <E> Deserializer.Sequence<E> sequence(SerializationContext ctx, Endec<E> elementEndec) {
        return new Sequence<E>(ctx, elementEndec, (List)this.getAs((Tag)this.getValue(), CollectionTag.class));
    }

    public <V> Deserializer.Map<V> map(SerializationContext ctx, Endec<V> valueEndec) {
        return new Map<V>(ctx, valueEndec, this.getAs((Tag)this.getValue(), CompoundTag.class));
    }

    public Deserializer.Struct struct() {
        return new Struct(this.getAs((Tag)this.getValue(), CompoundTag.class));
    }

    public <S> void readAny(SerializationContext ctx, Serializer<S> visitor) {
        this.decodeValue(ctx, visitor, (Tag)this.getValue());
    }

    private <S> void decodeValue(SerializationContext ctx, Serializer<S> visitor, Tag value) {
        switch (value.m_7060_()) {
            case 1: {
                visitor.writeByte(ctx, ((ByteTag)value).m_7063_());
                break;
            }
            case 2: {
                visitor.writeShort(ctx, ((ShortTag)value).m_7053_());
                break;
            }
            case 3: {
                visitor.writeInt(ctx, ((IntTag)value).m_7047_());
                break;
            }
            case 4: {
                visitor.writeLong(ctx, ((LongTag)value).m_7046_());
                break;
            }
            case 5: {
                visitor.writeFloat(ctx, ((FloatTag)value).m_7057_());
                break;
            }
            case 6: {
                visitor.writeDouble(ctx, ((DoubleTag)value).m_7061_());
                break;
            }
            case 8: {
                visitor.writeString(ctx, value.m_7916_());
                break;
            }
            case 7: {
                visitor.writeBytes(ctx, ((ByteArrayTag)value).m_128227_());
                break;
            }
            case 9: 
            case 11: 
            case 12: {
                CollectionTag list = (CollectionTag)value;
                try (Serializer.Sequence sequence = visitor.sequence(ctx, Endec.of(this::decodeValue, (ctx1, deserializer) -> null), list.size());){
                    list.forEach(arg_0 -> ((Serializer.Sequence)sequence).element(arg_0));
                    break;
                }
            }
            case 10: {
                CompoundTag compound = (CompoundTag)value;
                try (Serializer.Map map = visitor.map(ctx, Endec.of(this::decodeValue, (ctx1, deserializer) -> null), compound.m_128440_());){
                    for (String key : compound.m_128431_()) {
                        map.entry(key, (Object)compound.m_128423_(key));
                    }
                    break;
                }
            }
            default: {
                throw new IllegalArgumentException("Non-standard, unrecognized Tag implementation cannot be decoded");
            }
        }
    }

    private class Sequence<V>
    implements Deserializer.Sequence<V> {
        private final SerializationContext ctx;
        private final Endec<V> valueEndec;
        private final Iterator<Tag> elements;
        private final int size;

        private Sequence(SerializationContext ctx, Endec<V> valueEndec, List<Tag> elements) {
            this.ctx = ctx;
            this.valueEndec = valueEndec;
            this.elements = elements.iterator();
            this.size = elements.size();
        }

        public int estimatedSize() {
            return this.size;
        }

        public boolean hasNext() {
            return this.elements.hasNext();
        }

        public V next() {
            return (V)NbtDeserializer.this.frame(this.elements::next, () -> this.valueEndec.decode(this.ctx, (Deserializer)NbtDeserializer.this), false);
        }
    }

    private class Map<V>
    implements Deserializer.Map<V> {
        private final SerializationContext ctx;
        private final Endec<V> valueEndec;
        private final CompoundTag compound;
        private final Iterator<String> keys;
        private final int size;

        private Map(SerializationContext ctx, Endec<V> valueEndec, CompoundTag compound) {
            this.ctx = ctx;
            this.valueEndec = valueEndec;
            this.compound = compound;
            this.keys = compound.m_128431_().iterator();
            this.size = compound.m_128440_();
        }

        public int estimatedSize() {
            return this.size;
        }

        public boolean hasNext() {
            return this.keys.hasNext();
        }

        public Map.Entry<String, V> next() {
            String key = this.keys.next();
            return (Map.Entry)NbtDeserializer.this.frame(() -> this.compound.m_128423_(key), () -> java.util.Map.entry(key, this.valueEndec.decode(this.ctx, (Deserializer)NbtDeserializer.this)), false);
        }
    }

    public class Struct
    implements Deserializer.Struct {
        private final CompoundTag compound;

        public Struct(CompoundTag compound) {
            this.compound = compound;
        }

        @Nullable
        public <F> F field(String name, SerializationContext ctx, Endec<F> endec) {
            if (!this.compound.m_128441_(name)) {
                throw new IllegalStateException("Field '" + name + "' was missing from serialized data, but no default value was provided");
            }
            return (F)NbtDeserializer.this.frame(() -> this.compound.m_128423_(name), () -> endec.decode(ctx, (Deserializer)NbtDeserializer.this), true);
        }

        @Nullable
        public <F> F field(String name, SerializationContext ctx, Endec<F> endec, @Nullable F defaultValue) {
            if (!this.compound.m_128441_(name)) {
                return defaultValue;
            }
            return (F)NbtDeserializer.this.frame(() -> this.compound.m_128423_(name), () -> endec.decode(ctx, (Deserializer)NbtDeserializer.this), true);
        }
    }
}

