/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.criteria;

import com.google.gson.JsonObject;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.data.SlotGroupLoader;
import io.wispforest.endec.Deserializer;
import io.wispforest.endec.Endec;
import io.wispforest.endec.SerializationAttribute;
import io.wispforest.endec.SerializationContext;
import io.wispforest.endec.Serializer;
import io.wispforest.endec.StructEndec;
import io.wispforest.endec.format.gson.GsonDeserializer;
import io.wispforest.endec.format.gson.GsonEndec;
import io.wispforest.endec.impl.StructEndecBuilder;
import io.wispforest.endec.impl.StructField;
import java.util.List;
import java.util.Optional;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;

public class AccessoryChangedCriterion
extends SimpleCriterionTrigger<Conditions> {
    private final ResourceLocation location;
    private static final Endec<ItemPredicate> ITEM_PREDICATE_ENDEC = GsonEndec.INSTANCE.xmap(ItemPredicate::m_45051_, ItemPredicate::m_45048_);
    private static final StructEndec<ContextAwarePredicate> CONTEXT_AWARE_PREDICATE_ENDEC = new StructEndec<ContextAwarePredicate>(){

        public void encodeStruct(SerializationContext ctx, Serializer<?> serializer, Serializer.Struct struct, ContextAwarePredicate value) {
        }

        public ContextAwarePredicate decodeStruct(SerializationContext ctx, Deserializer<?> deserializer, Deserializer.Struct struct) {
            return ((ContextAwarePredicateAttribute)ctx.requireAttributeValue(ContextAwarePredicateAttribute.INSTANCE)).predicate();
        }
    };
    private static final StructEndec<ResourceLocation> CRITERION_ID = new StructEndec<ResourceLocation>(){

        public void encodeStruct(SerializationContext ctx, Serializer<?> serializer, Serializer.Struct struct, ResourceLocation value) {
        }

        public ResourceLocation decodeStruct(SerializationContext ctx, Deserializer<?> deserializer, Deserializer.Struct struct) {
            return ((CriterionIdAttribute)ctx.requireAttributeValue(CriterionIdAttribute.INSTANCE)).id();
        }
    };

    public AccessoryChangedCriterion(ResourceLocation location) {
        this.location = location;
    }

    public void trigger(ServerPlayer player, ItemStack accessory, SlotReference reference, Boolean cosmetic) {
        this.m_66234_(player, conditions -> conditions.itemPredicates().map(predicates -> predicates.stream().allMatch(predicate -> predicate.m_45049_(accessory))).orElse(true) != false && conditions.groups().flatMap(groups -> SlotGroupLoader.INSTANCE.findGroup(false, reference.slotName()).map(group -> groups.stream().noneMatch(s -> s.equals(group.name())))).orElse(true) != false && conditions.slots().map(slots -> slots.stream().noneMatch(reference.slotName()::equals)).orElse(true) != false && conditions.indices().map(indices -> indices.stream().noneMatch(index -> index.intValue() == reference.slot())).orElse(true) != false && conditions.cosmetic().map(isCosmetic -> isCosmetic != false && cosmetic != false).orElse(true) != false);
    }

    protected Conditions createInstance(JsonObject jsonObject, ContextAwarePredicate contextAwarePredicate, DeserializationContext deserializationContext) {
        SerializationContext ctx = SerializationContext.attributes((SerializationAttribute.Instance[])new SerializationAttribute.Instance[]{new ContextAwarePredicateAttribute(contextAwarePredicate), new CriterionIdAttribute(this.m_7295_())});
        return (Conditions)((Object)Conditions.ENDEC.decodeFully(ctx, GsonDeserializer::of, (Object)jsonObject));
    }

    public ResourceLocation m_7295_() {
        return this.location;
    }

    public record ContextAwarePredicateAttribute(ContextAwarePredicate predicate) implements SerializationAttribute.Instance
    {
        public static final SerializationAttribute.WithValue<ContextAwarePredicateAttribute> INSTANCE = SerializationAttribute.withValue((String)"accessories:context_aware_predicate");

        public SerializationAttribute attribute() {
            return INSTANCE;
        }

        public Object value() {
            return this;
        }
    }

    public record CriterionIdAttribute(ResourceLocation id) implements SerializationAttribute.Instance
    {
        public static final SerializationAttribute.WithValue<CriterionIdAttribute> INSTANCE = SerializationAttribute.withValue((String)"accessories:criterion_id");

        public SerializationAttribute attribute() {
            return INSTANCE;
        }

        public Object value() {
            return this;
        }
    }

    public static class Conditions
    extends AbstractCriterionTriggerInstance {
        private static final Endec<Conditions> ENDEC = StructEndecBuilder.of((StructField)CRITERION_ID.flatFieldOf(conditions -> conditions.m_7294_()), (StructField)CONTEXT_AWARE_PREDICATE_ENDEC.flatFieldOf(conditions -> conditions.m_285924_()), (StructField)ITEM_PREDICATE_ENDEC.listOf().optionalOf().optionalFieldOf("items", Conditions::itemPredicates, () -> Optional.empty()), (StructField)Endec.STRING.listOf().optionalOf().optionalFieldOf("groups", Conditions::groups, () -> Optional.empty()), (StructField)Endec.STRING.listOf().optionalOf().optionalFieldOf("slots", Conditions::slots, () -> Optional.empty()), (StructField)Endec.INT.listOf().optionalOf().optionalFieldOf("indices", Conditions::indices, () -> Optional.empty()), (StructField)Endec.BOOLEAN.optionalOf().optionalFieldOf("cosmetic", Conditions::cosmetic, () -> Optional.empty()), Conditions::new);
        private final Optional<List<ItemPredicate>> itemPredicates;
        private final Optional<List<String>> groups;
        private final Optional<List<String>> slots;
        private final Optional<List<Integer>> indices;
        private final Optional<Boolean> cosmetic;

        public Conditions(ResourceLocation id, ContextAwarePredicate player, Optional<List<ItemPredicate>> itemPredicates, Optional<List<String>> groups, Optional<List<String>> slots, Optional<List<Integer>> indices, Optional<Boolean> cosmetic) {
            super(id, player);
            this.itemPredicates = itemPredicates;
            this.groups = groups;
            this.slots = slots;
            this.indices = indices;
            this.cosmetic = cosmetic;
        }

        public Optional<ContextAwarePredicate> player() {
            return Optional.of(this.m_285924_());
        }

        public Optional<List<ItemPredicate>> itemPredicates() {
            return this.itemPredicates;
        }

        public Optional<List<String>> groups() {
            return this.groups;
        }

        public Optional<List<String>> slots() {
            return this.slots;
        }

        public Optional<List<Integer>> indices() {
            return this.indices;
        }

        public Optional<Boolean> cosmetic() {
            return this.cosmetic;
        }
    }
}

