/*
 * Decompiled with CFR 0.152.
 */
package mod.chloeprime.aaaparticles.client.installer;

import com.google.common.base.Suppliers;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.io.File;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;
import mod.chloeprime.aaaparticles.client.installer.forge.NativePlatformImpl;
import net.minecraft.Util;

public enum NativePlatform {
    WINDOWS(".dll"),
    WINDOWS_ON_ARM(".dll", "", true),
    LINUX_X64(".so", "lib"),
    LINUX_NOT_X64(".so", "lib", true),
    MACOS_X64(".dylib", "lib"),
    MACOS_ARM(".dylib", "lib"),
    UNKNOWN(".so", "lib", true);

    private static final Supplier<NativePlatform> CURRENT;
    private static final Supplier<File> INSTALL_FOLDER;
    private final String prefix;
    private final String libFormat;
    private final boolean unsupported;

    public static boolean isRunningOnUnsupportedPlatform() {
        return NativePlatform.current().unsupported || NativePlatform.isDataGen();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean isDataGen() {
        return NativePlatformImpl.isDataGen();
    }

    public static NativePlatform current() {
        return CURRENT.get();
    }

    public boolean isUnsupported() {
        return this.unsupported;
    }

    public File getNativeInstallPath(String dllName) {
        return new File(INSTALL_FOLDER.get(), this.formatFileName(dllName));
    }

    public String formatFileName(String dllName) {
        return this.prefix + dllName + this.libFormat;
    }

    public String getLibraryFormat() {
        return this.libFormat;
    }

    private NativePlatform(String libFormat) {
        this(libFormat, "");
    }

    private NativePlatform(String libFormat, String prefix) {
        this(libFormat, prefix, false);
    }

    private NativePlatform(String libFormat, String prefix, boolean unsupported) {
        this.libFormat = libFormat;
        this.prefix = prefix;
        this.unsupported = unsupported;
    }

    public static NativePlatform findCurrent() {
        return switch (Util.m_137581_()) {
            case Util.OS.WINDOWS -> {
                switch (System.getProperty("os.arch")) {
                    case "aarch64": {
                        yield WINDOWS_ON_ARM;
                    }
                }
                yield WINDOWS;
            }
            case Util.OS.LINUX -> {
                switch (System.getProperty("os.arch")) {
                    case "x86": 
                    case "amd64": {
                        yield LINUX_X64;
                    }
                }
                yield LINUX_NOT_X64;
            }
            case Util.OS.OSX -> {
                switch (System.getProperty("os.arch")) {
                    case "aarch64": 
                    case "unknown": {
                        yield MACOS_ARM;
                    }
                }
                yield MACOS_X64;
            }
            default -> UNKNOWN;
        };
    }

    private static File findNativeFolder() {
        File root = new File("./");
        return Optional.ofNullable(root.listFiles((dir, name) -> {
            if (!dir.isDirectory()) {
                return false;
            }
            return "native".equals(name) || "natives".equals(name) || name.startsWith("native-") || name.startsWith("natives-");
        })).map(Arrays::stream).flatMap(Stream::findAny).orElse(root);
    }

    static {
        CURRENT = Suppliers.memoize(NativePlatform::findCurrent);
        INSTALL_FOLDER = Suppliers.memoize(NativePlatform::findNativeFolder);
    }
}

