/*
 * Decompiled with CFR 0.152.
 */
package nl.enjarai.a_good_place.particles;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import nl.enjarai.a_good_place.AGoodPlace;
import nl.enjarai.a_good_place.particles.BlocksParticlesManager;

public abstract class PlacingBlockParticle
extends Particle {
    protected final BlockPos pos;
    protected final BlockState blockState;
    private final BakedModel model;
    private final long seed;
    private final BlockRenderDispatcher renderer;
    protected int extraLifeTicks = 0;
    public boolean canRender;

    public PlacingBlockParticle(ClientLevel world, BlockPos blockPos, Direction face) {
        super(world, (double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_());
        Minecraft client = Minecraft.m_91087_();
        this.pos = BlockPos.m_274561_((double)this.f_107212_, (double)this.f_107213_, (double)this.f_107214_);
        this.blockState = world.m_8055_(this.pos);
        this.model = client.m_91289_().m_110910_(this.blockState);
        this.seed = this.blockState.m_60726_(this.pos);
        this.renderer = client.m_91289_();
        this.f_107219_ = false;
        this.f_107225_ = 7;
        this.m_107250_(1.0f, 1.0f);
    }

    public void m_5989_() {
        if (this.f_107220_) {
            return;
        }
        ++this.f_107224_;
        if (this.f_107224_ >= this.f_107225_ + this.extraLifeTicks) {
            this.m_107274_();
        }
        if (this.finishedAnimation()) {
            BlocksParticlesManager.unHideBlock(this.pos);
        }
        if (this.f_107208_.m_8055_(this.pos) != this.blockState) {
            this.m_107274_();
            BlocksParticlesManager.unHideBlock(this.pos);
        }
    }

    public void m_5744_(VertexConsumer buffer, Camera camera, float partialTicks) {
        if (!this.canRender) {
            return;
        }
        PoseStack poseStack = new PoseStack();
        Vec3 cameraPos = camera.m_90583_();
        float px = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107209_, (double)this.f_107212_) - cameraPos.m_7096_());
        float py = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107210_, (double)this.f_107213_) - cameraPos.m_7098_());
        float pz = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107211_, (double)this.f_107214_) - cameraPos.m_7094_());
        poseStack.m_252880_(px, py, pz);
        this.applyAnimation(poseStack, partialTicks);
        MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
        AGoodPlace.renderBlock(this.model, this.seed, poseStack, (MultiBufferSource)bufferSource, this.blockState, (Level)this.f_107208_, this.pos, this.renderer);
        if (AGoodPlace.RENDER_AS_VANILLA_PARTICLES) {
            Minecraft.m_91087_().m_91269_().m_110104_().m_109911_();
        }
    }

    public final void applyAnimation(PoseStack poseStack, float partialTicks) {
        float t = Math.min(1.0f, ((float)this.f_107224_ + partialTicks) / (float)(this.f_107225_ + 1));
        this.applyAnimation(poseStack, t, partialTicks);
    }

    protected abstract void applyAnimation(PoseStack var1, float var2, float var3);

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107433_;
    }

    public boolean finishedAnimation() {
        return this.f_107224_ >= this.f_107225_;
    }
}

