/*
 * Decompiled with CFR 0.152.
 */
package nl.enjarai.a_good_place.particles;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import nl.enjarai.a_good_place.pack.AnimationParameters;
import nl.enjarai.a_good_place.particles.PlacingBlockParticle;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class ConfiguredPlacingParticle
extends PlacingBlockParticle {
    private final AnimationParameters params;
    private final float yAngle;
    private final Vec2 slideStart;
    private final Vec3 rotStart;

    public ConfiguredPlacingParticle(ClientLevel level, BlockPos blockPos, Direction face, Player placer, InteractionHand hand, AnimationParameters settings) {
        super(level, blockPos, face);
        int rightHandMul;
        settings.sound().ifPresent(sound -> level.m_245747_(blockPos, (SoundEvent)sound.m_203334_(), SoundSource.PLAYERS, 1.0f, 1.0f, false));
        this.params = settings;
        this.f_107225_ = this.params.duration();
        this.extraLifeTicks = 2;
        Vector3f playerHorizLook = placer.m_20154_().m_252839_().mul(-1.0f, 0.0f, -1.0f).normalize();
        int n = rightHandMul = placer.m_5737_() == HumanoidArm.RIGHT ? 1 : -1;
        if (hand != InteractionHand.MAIN_HAND) {
            rightHandMul *= -1;
        }
        Vector3f xVec = new Vector3f(playerHorizLook.z, 0.0f, -playerHorizLook.x).mul((float)rightHandMul);
        Matrix3f changeOfBasis = new Matrix3f((Vector3fc)xVec, (Vector3fc)new Vector3f(0.0f, 1.0f, 0.0f), (Vector3fc)playerHorizLook);
        Vector3f tr = this.params.translation().m_252839_();
        float slidePow = tr.length();
        if (placer.m_146909_() > 0.0f) {
            tr.mul(1.0f, 1.0f, 1.0f);
        } else {
            tr.mul(1.0f, -1.0f, 1.0f);
        }
        Vector3f slideDir = tr.mul((Matrix3fc)changeOfBasis);
        if (this.params.restrictDirection()) {
            slideDir = this.adjustDirectionBasedOnNeighbors(level, placer, slideDir);
        }
        Vec3 animationDirection = new Vec3(slideDir.normalize());
        this.yAngle = (float)Math.atan2(slideDir.x(), slideDir.z());
        Vec3 temp = animationDirection.m_82524_(-this.yAngle);
        this.slideStart = new Vec2((float)temp.f_82481_, (float)temp.f_82480_).m_165903_(slidePow);
        this.rotStart = this.params.rotation();
    }

    @Override
    public void applyAnimation(PoseStack poseStack, float time, float partialTicks) {
        poseStack.m_85837_(0.5, 0.5, 0.5);
        Vec3 offset = this.blockState.m_60824_((BlockGetter)this.f_107208_, this.pos);
        poseStack.m_85837_(offset.f_82479_, offset.f_82480_, offset.f_82481_);
        poseStack.m_252781_(Axis.f_252436_.m_252961_(this.yAngle));
        float progress = this.fancyExponent(time, this.params.translationCurve());
        Vec2 translate = this.slideStart.m_165903_(1.0f - progress);
        poseStack.m_252880_(0.0f, translate.f_82471_, translate.f_82470_);
        progress = this.fancyExponent(time, this.params.rotationCurve());
        Vec3 rotation = this.rotStart.m_82490_((double)(1.0f - progress));
        Vec3 rotationPivot = this.params.pivot();
        if (this.slideStart.f_82471_ < 0.0f) {
            rotationPivot = rotationPivot.m_82542_(1.0, -1.0, 1.0);
            rotation = rotation.m_82542_(-1.0, 1.0, -1.0);
        }
        poseStack.m_85837_(rotationPivot.f_82479_, rotationPivot.f_82480_, rotationPivot.f_82481_);
        poseStack.m_252781_(Axis.f_252436_.m_252961_((float)rotation.f_82480_));
        poseStack.m_252781_(Axis.f_252403_.m_252961_((float)rotation.f_82481_));
        poseStack.m_252781_(Axis.f_252529_.m_252961_((float)rotation.f_82479_));
        poseStack.m_85837_(-rotationPivot.f_82479_, -rotationPivot.f_82480_, -rotationPivot.f_82481_);
        progress = this.fancyExponent(time, this.params.scaleCurve());
        float scaleStart = this.params.scaleStart();
        float scale = scaleStart + (0.999f - scaleStart) * progress;
        poseStack.m_85841_(scale, scale, scale);
        progress = this.fancyExponent(time, this.params.heightCurve());
        float heightStart = this.params.heightStart();
        float height = heightStart + (1.0f - heightStart) * progress;
        poseStack.m_85837_(0.0, -0.5, 0.0);
        poseStack.m_85841_(1.0f, height, 1.0f);
        poseStack.m_252880_(0.0f, 0.5f, 0.0f);
        poseStack.m_252781_(Axis.f_252436_.m_252961_(-this.yAngle));
        poseStack.m_85837_(-offset.f_82479_, -offset.f_82480_, -offset.f_82481_);
        poseStack.m_85837_(-0.5, -0.5, -0.5);
    }

    private float parabula(float t, float exp, float startSlope) {
        float a = 1.0f - startSlope;
        return a * (float)Math.pow(t, exp) + (1.0f - a) * t;
    }

    private float exponent(float t, float base) {
        return (float)((double)base * Math.pow(1.0f / base + 1.0f, t) - (double)base);
    }

    private float fancyExponent(float t, float curve) {
        if (curve == 0.0f) {
            return t;
        }
        float base = curve > 0.0f ? (float)(-Math.log(curve)) : (float)(Math.log(-curve) - 1.0);
        return this.exponent(t, base);
    }

    private float addSomeRandom(float t) {
        return t;
    }

    public static List<Direction> getAffectedDirections(float x, float y, float z) {
        ArrayList<Direction> list = new ArrayList<Direction>();
        if (z > 0.0f) {
            list.add(Direction.SOUTH);
        }
        if (z < 0.0f) {
            list.add(Direction.NORTH);
        }
        if (x > 0.0f) {
            list.add(Direction.EAST);
        }
        if (x < 0.0f) {
            list.add(Direction.WEST);
        }
        if (y > 0.0f) {
            list.add(Direction.UP);
        }
        if (y < 0.0f) {
            list.add(Direction.DOWN);
        }
        return list;
    }

    @NotNull
    private Vector3f adjustDirectionBasedOnNeighbors(ClientLevel world, Player placer, Vector3f slideDir) {
        List<Direction> affectedDir = ConfiguredPlacingParticle.getAffectedDirections(slideDir.x(), slideDir.y(), slideDir.z());
        ArrayList<Direction> emptyDirections = new ArrayList<Direction>();
        for (Direction d : Direction.values()) {
            BlockPos neighbor = this.pos.m_121945_(d);
            BlockState state = world.m_8055_(neighbor);
            VoxelShape collision = state.m_60812_((BlockGetter)world, neighbor);
            if (collision.m_83281_()) {
                emptyDirections.add(d);
                continue;
            }
            if (d.m_122421_() == Direction.AxisDirection.POSITIVE) {
                if (!(collision.m_83288_(d.m_122434_()) > 0.25)) continue;
                emptyDirections.add(d);
                continue;
            }
            if (!(collision.m_83297_(d.m_122434_()) < 0.75)) continue;
            emptyDirections.add(d);
        }
        for (Direction d : affectedDir) {
            if (emptyDirections.contains(d)) continue;
            slideDir.sub((Vector3fc)d.m_253071_().mul((Vector3fc)d.m_253071_()).mul((Vector3fc)slideDir));
        }
        if (slideDir.length() == 0.0f && !emptyDirections.isEmpty()) {
            List<Direction> nearest = List.of(Direction.m_122382_((Entity)placer));
            emptyDirections.sort(Comparator.comparingInt(nearest::indexOf));
            slideDir = ((Direction)emptyDirections.get(0)).m_253071_();
        }
        return slideDir;
    }
}

