/*
 * Decompiled with CFR 0.152.
 */
package waves;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import waves.config.Config;
import waves.util.WaveDataManager;
import waves.util.WaveHelpers;

public class EventHandler {
    public static void init() {
        IEventBus bus = MinecraftForge.EVENT_BUS;
        bus.addListener(EventHandler::updateCaches);
        bus.addListener(EventHandler::resetWaveData);
        bus.addListener(EventHandler::loadWaveData);
        bus.addListener(EventHandler::handleWavesServer);
    }

    public static void resetWaveData(LevelEvent.Unload event) {
        WaveDataManager.WAVE_DATA.clearData();
        WaveHelpers.wipeCaches();
    }

    public static void loadWaveData(LevelEvent.Load event) {
        WaveDataManager.WAVE_DATA.initConfigs();
        WaveHelpers.wipeCaches();
    }

    public static void handleWavesServer(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        Level level = player.m_9236_();
        if (level.m_46467_() % 20L == 0L && !level.m_5776_() && (Integer)Config.COMMON.waveSpawnFrequency.get() > 0 && (Double)Config.COMMON.waveSpawnAmount.get() > 0.0 && !WaveDataManager.WAVE_DATA.get().isEmpty() && player != null && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (level != null && level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                WaveHelpers.spawnWaves(serverLevel, (Player)serverPlayer, (Boolean)Config.COMMON.toggleWaveEntities.get());
            }
        }
    }

    public static void updateCaches(TickEvent.ServerTickEvent event) {
        ServerLevel level;
        if (((Boolean)Config.COMMON.useCaches.get()).booleanValue() && (level = event.getServer().m_129880_(Level.f_46428_)) != null && level.m_46467_() % (long)((Integer)Config.COMMON.cacheUpdateFrequency.get()).intValue() == 0L) {
            WaveHelpers.wipeCaches();
        }
    }
}

