/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.platform;

import einstein.subtle_effects.SubtleEffects;
import einstein.subtle_effects.networking.Packet;
import einstein.subtle_effects.platform.services.NetworkHelper;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.core.BlockPos;
import net.minecraft.network.Connection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import org.jetbrains.annotations.Nullable;

public class ForgeNetworkHelper
implements NetworkHelper {
    private static final String PROTOCOL_VERSION = "1";
    public static final Predicate<String> VERSION_MATCHER = NetworkRegistry.acceptMissingOr((String)"1");
    public static final SimpleChannel CHANNEL = NetworkRegistry.ChannelBuilder.named((ResourceLocation)SubtleEffects.loc("main")).networkProtocolVersion(() -> "1").clientAcceptedVersions(VERSION_MATCHER).serverAcceptedVersions(VERSION_MATCHER).simpleChannel();

    @Override
    public <T extends Packet> boolean sendToServer(T t) {
        ClientPacketListener listener = Minecraft.m_91087_().m_91403_();
        if (listener != null) {
            return ForgeNetworkHelper.send(t, listener.m_104910_(), () -> ((PacketDistributor)PacketDistributor.SERVER).noArg());
        }
        return false;
    }

    @Override
    public <T extends Packet> boolean sendToClient(T t, ServerPlayer player) {
        return ForgeNetworkHelper.send(t, player.f_8906_.f_9742_, () -> PacketDistributor.PLAYER.with(() -> player));
    }

    @Override
    public <T extends Packet> void sendToClientsTracking(ServerLevel level, BlockPos pos, T t) {
        this.sendToClientsTracking(null, level, pos, t);
    }

    @Override
    public <T extends Packet> void sendToClientsTracking(@Nullable ServerPlayer exceptPlayer, ServerLevel level, BlockPos pos, T t) {
        this.sendToClientsTracking(exceptPlayer, level, pos, t, null);
    }

    @Override
    public <T extends Packet> void sendToClientsTracking(@Nullable ServerPlayer exceptPlayer, ServerLevel level, BlockPos pos, T t, @Nullable Consumer<ServerPlayer> skippedPlayersConsumer) {
        level.m_7726_().f_8325_.m_183262_(new ChunkPos(pos), false).forEach(player -> {
            if (!player.equals((Object)exceptPlayer) && !this.sendToClient(t, (ServerPlayer)player) && skippedPlayersConsumer != null) {
                skippedPlayersConsumer.accept((ServerPlayer)player);
            }
        });
    }

    private static <T extends Packet> boolean send(T t, Connection connection, Supplier<PacketDistributor.PacketTarget> target) {
        if (CHANNEL.isRemotePresent(connection)) {
            if (PACKETS.containsKey(t.getClass())) {
                CHANNEL.send(target.get(), t);
                return true;
            }
            SubtleEffects.LOGGER.warn("Failed to find packet named: {}", (Object)t.id());
        }
        return false;
    }

    public static void init() {
        PACKETS.forEach(ForgeNetworkHelper::registerPacket);
    }

    private static <T extends Packet> void registerPacket(Class<?> clazz, NetworkHelper.PacketData<? extends Packet> packetData) {
        NetworkHelper.PacketData<? extends Packet> data = packetData;
        CHANNEL.messageBuilder(clazz, data.rawId(), ForgeNetworkHelper.getDirectionToNetworkDirection(data)).encoder(Packet::encode).decoder(buf -> (Packet)data.decoder().apply((FriendlyByteBuf)buf)).consumerMainThread((packet, context) -> packet.handle(((NetworkEvent.Context)context.get()).getSender())).add();
    }

    private static NetworkDirection getDirectionToNetworkDirection(NetworkHelper.PacketData<?> data) {
        return data.direction() == NetworkHelper.Direction.TO_CLIENT ? NetworkDirection.PLAY_TO_CLIENT : NetworkDirection.PLAY_TO_SERVER;
    }
}

