/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.particle;

import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.particle.option.ColorParticleOptions;
import einstein.subtle_effects.util.SparkType;
import einstein.subtle_effects.util.Util;
import java.util.List;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class SparkParticle
extends TextureSheetParticle {
    public static final List<Integer> DEFAULT_COLORS = List.of(Integer.valueOf(16766976), Integer.valueOf(16738816));
    public static final List<Integer> SOUL_COLORS = List.of(Integer.valueOf(6354426), Integer.valueOf(108460));

    protected SparkParticle(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, float lifeTimeModifier, SpriteSet sprites) {
        super(level, x, y, z, xSpeed, ySpeed, zSpeed);
        this.f_172258_ = 0.96f;
        this.f_107226_ = -0.1f;
        this.f_107215_ = this.f_107215_ * 0.1 + xSpeed;
        this.f_107216_ = this.f_107216_ * 0.1 + ySpeed;
        this.f_107217_ = this.f_107217_ * 0.1 + zSpeed;
        int i = this.f_107223_.m_188503_(11);
        this.f_107663_ *= 0.75f * (float)i / 10.0f * ((Float)ModConfigs.GENERAL.sparksScale.get()).floatValue();
        this.f_107225_ = (int)(20.0 / ((double)this.f_107223_.m_188501_() * 0.8 + 0.2) * (double)i / (double)lifeTimeModifier);
        this.f_107225_ = Math.max(this.f_107225_, 1);
        this.f_107219_ = true;
        this.f_172259_ = true;
        this.m_108335_(sprites);
    }

    public static ColorParticleOptions create(SparkType sparkType, RandomSource random) {
        return SparkParticle.create(sparkType, random, DEFAULT_COLORS);
    }

    public static ColorParticleOptions create(SparkType sparkType, RandomSource random, List<Integer> colors) {
        return new ColorParticleOptions(sparkType.getType().get(), Vec3.m_82501_((int)colors.get(random.m_188503_(colors.size()))).m_252839_());
    }

    public static ColorParticleOptions createSoul(SparkType sparkType, RandomSource random) {
        return SparkParticle.create(sparkType, random, SOUL_COLORS);
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107430_;
    }

    public float m_5902_(float scaleFactor) {
        return this.f_107663_ * Mth.m_14036_((float)(((float)this.f_107224_ + scaleFactor) / (float)this.f_107225_ * 32.0f), (float)0.0f, (float)1.0f);
    }

    public int m_6355_(float partialTick) {
        return Util.getLightColor(super.m_6355_(partialTick));
    }

    public record MetalProvider(SpriteSet sprites) implements ParticleProvider<ColorParticleOptions>
    {
        public Particle createParticle(ColorParticleOptions options, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            SparkParticle particle = new SparkParticle(level, x, y, z, xSpeed, ySpeed, zSpeed, 20.0f, this.sprites);
            Vector3f color = options.m_252837_();
            particle.f_107226_ = 1.0f;
            particle.m_107253_(color.x(), color.y(), color.z());
            return particle;
        }
    }

    public record FloatingProvider(SpriteSet sprites) implements ParticleProvider<ColorParticleOptions>
    {
        public Particle createParticle(ColorParticleOptions options, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            SparkParticle particle = new SparkParticle(level, x, y, z, xSpeed, ySpeed, zSpeed, 20.0f, this.sprites);
            Vector3f color = options.m_252837_();
            particle.f_107226_ = 0.0f;
            particle.m_107253_(color.x(), color.y(), color.z());
            return particle;
        }
    }

    public record ShortLifeProvider(SpriteSet sprites) implements ParticleProvider<ColorParticleOptions>
    {
        public Particle createParticle(ColorParticleOptions options, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            SparkParticle particle = new SparkParticle(level, x, y, z, xSpeed, ySpeed, zSpeed, 20.0f, this.sprites);
            Vector3f color = options.m_252837_();
            particle.m_107253_(color.x(), color.y(), color.z());
            return particle;
        }
    }

    public record LongLifeProvider(SpriteSet sprites) implements ParticleProvider<ColorParticleOptions>
    {
        public Particle createParticle(ColorParticleOptions options, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            SparkParticle particle = new SparkParticle(level, x, y, z, xSpeed, ySpeed, zSpeed, 10.0f, this.sprites);
            Vector3f color = options.m_252837_();
            particle.m_107253_(color.x(), color.y(), color.z());
            return particle;
        }
    }
}

