/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.init;

import einstein.subtle_effects.configs.CommandBlockSpawnType;
import einstein.subtle_effects.configs.ModEntityConfigs;
import einstein.subtle_effects.configs.entities.ItemRarityConfigs;
import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.init.ModParticles;
import einstein.subtle_effects.particle.SparkParticle;
import einstein.subtle_effects.particle.option.BooleanParticleOptions;
import einstein.subtle_effects.tickers.DrowningTicker;
import einstein.subtle_effects.tickers.EntityFireTicker;
import einstein.subtle_effects.tickers.EntityWaterCauldronTicker;
import einstein.subtle_effects.tickers.FrostyBreathTicker;
import einstein.subtle_effects.tickers.HeartbeatTicker;
import einstein.subtle_effects.tickers.HumanoidPotionRingTicker;
import einstein.subtle_effects.tickers.IronGolemTicker;
import einstein.subtle_effects.tickers.ItemRarityTicker;
import einstein.subtle_effects.tickers.MinecartSparksTicker;
import einstein.subtle_effects.tickers.MobSkullShaderTicker;
import einstein.subtle_effects.tickers.SlimeTrailTicker;
import einstein.subtle_effects.tickers.StomachGrowlingTicker;
import einstein.subtle_effects.tickers.TickerManager;
import einstein.subtle_effects.tickers.WitchPotionRingTicker;
import einstein.subtle_effects.tickers.sleeping.BatSleepingTicker;
import einstein.subtle_effects.tickers.sleeping.CatSleepingTicker;
import einstein.subtle_effects.tickers.sleeping.FoxSleepingTicker;
import einstein.subtle_effects.tickers.sleeping.PlayerSleepingTicker;
import einstein.subtle_effects.tickers.sleeping.SleepingTicker;
import einstein.subtle_effects.tickers.sleeping.VillagerSleepingTicker;
import einstein.subtle_effects.util.MathUtil;
import einstein.subtle_effects.util.ParticleSpawnUtil;
import einstein.subtle_effects.util.SparkType;
import einstein.subtle_effects.util.Util;
import java.util.List;
import java.util.function.Predicate;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedDouble;
import net.minecraft.client.Minecraft;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ambient.Bat;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.MagmaCube;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class ModTickers {
    private static final Predicate<Entity> LOCAL_PLAYER = entity -> entity.equals((Object)Minecraft.m_91087_().f_91074_);

    public static void init() {
        TickerManager.registerTicker(entity -> true, EntityWaterCauldronTicker::new);
        TickerManager.registerTicker(entity -> !(entity instanceof LightningBolt), EntityFireTicker::new);
        TickerManager.registerTicker(entity -> entity instanceof LivingEntity, ModTickers::getSleepingTicker);
        TickerManager.registerTicker(entity -> entity instanceof AbstractMinecart && ModConfigs.ENTITIES.minecartSparksDisplayType != ModEntityConfigs.MinecartSparksDisplayType.OFF, MinecartSparksTicker::new);
        TickerManager.registerTicker(LOCAL_PLAYER.and(entity -> (Integer)ModConfigs.ENTITIES.humanoids.player.stomachGrowlingThreshold.get() > 0), StomachGrowlingTicker::new);
        TickerManager.registerTicker(LOCAL_PLAYER.and(entity -> ModConfigs.GENERAL.mobSkullShaders), MobSkullShaderTicker::new);
        TickerManager.registerTicker(LOCAL_PLAYER.and(entity -> (Integer)ModConfigs.ENTITIES.humanoids.player.heartBeatingThreshold.get() > 0), HeartbeatTicker::new);
        TickerManager.registerTicker(entity -> ModTickers.isHumanoid(entity, !entity.m_9236_().m_46472_().equals((Object)Level.f_46429_)) && ModConfigs.ENTITIES.humanoids.drowningBubblesDisplayType.isEnabled(), DrowningTicker::new);
        TickerManager.registerTicker(entity -> ModTickers.isHumanoid(entity, !entity.m_9236_().m_46472_().equals((Object)Level.f_46429_)) && ModConfigs.ENTITIES.humanoids.frostyBreath.displayType.isEnabled(), FrostyBreathTicker::new);
        TickerManager.registerTicker(entity -> entity.m_6095_().equals(EntityType.f_20526_) && ModConfigs.ENTITIES.slimeTrails, entity -> new SlimeTrailTicker<Slime>((Slime)entity, ModParticles.SLIME_TRAIL));
        TickerManager.registerTicker(entity -> entity.m_6095_().equals(EntityType.f_20468_) && ModConfigs.ENTITIES.magmaCubeTrails, entity -> new SlimeTrailTicker<MagmaCube>((MagmaCube)entity, ModParticles.MAGMA_CUBE_TRAIL));
        TickerManager.registerTicker(entity -> entity.m_6095_().equals(EntityType.f_20460_) && ModConfigs.ENTITIES.ironGolemCrackParticles, IronGolemTicker::new);
        TickerManager.registerTicker(entity -> entity instanceof ItemEntity && ModConfigs.ENTITIES.itemRarity.particlesDisplayType != ItemRarityConfigs.DisplayType.OFF, ItemRarityTicker::new);
        TickerManager.registerTicker(entity -> entity instanceof Witch && ModConfigs.ENTITIES.humanoids.NPCsHavePotionRings && ModConfigs.ENTITIES.humanoids.potionRingsDisplayType.isEnabled(), WitchPotionRingTicker::new);
        TickerManager.registerTicker(entity -> ModTickers.isNPC(entity, true) && ModConfigs.ENTITIES.humanoids.NPCsHavePotionRings && ModConfigs.ENTITIES.humanoids.potionRingsDisplayType.isEnabled(), entity -> new HumanoidPotionRingTicker<LivingEntity>((LivingEntity)entity));
        TickerManager.registerSimpleTicker(entity -> entity instanceof Player && ModConfigs.ENTITIES.dustClouds.playerRunning, (entity, level, random) -> {
            if (entity.m_20145_()) {
                return;
            }
            if (ModConfigs.ENTITIES.dustClouds.preventWhenRaining && level.m_46758_(entity.m_20183_())) {
                return;
            }
            Player player = (Player)entity;
            if (ModConfigs.ENTITIES.dustClouds.playerRunningRequiresSpeed && !player.m_21023_(MobEffects.f_19596_)) {
                return;
            }
            if (player.m_5843_() && player.m_20096_() && !player.m_6117_() && random.m_188499_()) {
                level.m_7106_((ParticleOptions)ModParticles.SMALL_DUST_CLOUD.get(), entity.m_20208_(1.0), entity.m_20186_() + Math.max(Math.min((double)random.m_188501_(), 0.3), 0.2), entity.m_20262_(1.0), 0.0, random.m_188500_(), 0.0);
            }
        });
        TickerManager.registerSimpleTicker(entity -> entity instanceof FallingBlockEntity && ModConfigs.BLOCKS.fallingBlockDust, (entity, level, random) -> {
            FallingBlockEntity fallingBlock = (FallingBlockEntity)entity;
            if (fallingBlock.f_19789_ <= (float)((Integer)ModConfigs.BLOCKS.fallingBlockDustDistance.get()).intValue()) {
                return;
            }
            if (!fallingBlock.m_20096_() && !fallingBlock.m_20068_()) {
                BlockState state = fallingBlock.m_31980_();
                if (((List)ModConfigs.BLOCKS.fallingBlockDustBlocks.get()).contains(state.m_60734_())) {
                    level.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123814_, state), entity.m_20208_(1.0), entity.m_20186_() + 0.05, entity.m_20262_(1.0), 0.0, 0.0, 0.0);
                }
            }
        });
        TickerManager.registerSimpleTicker(EntityType.f_20477_, () -> (Double)ModConfigs.ENTITIES.snowballTrailDensity.get() > 0.0, (entity, level, random) -> {
            if (ModTickers.shouldSpawn(random, ModConfigs.ENTITIES.snowballTrailDensity)) {
                Vec3 deltaMovement = entity.m_20184_();
                level.m_7106_((ParticleOptions)ModParticles.SNOWBALL_TRAIL.get(), entity.m_20208_(1.0), entity.m_20187_(), entity.m_20262_(1.0), deltaMovement.f_82479_ * 0.5, deltaMovement.f_82480_, deltaMovement.f_82481_ * 0.5);
            }
        });
        TickerManager.registerSimpleTicker(EntityType.f_20484_, () -> ModConfigs.ENTITIES.enderPearlTrail, (entity, level, random) -> {
            for (int i = 0; i < 10; ++i) {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123760_, entity.m_20208_(2.0), entity.m_20187_(), entity.m_20262_(2.0), 0.0, 0.0, 0.0);
            }
        });
        TickerManager.registerSimpleTicker(EntityType.f_217014_, () -> (Double)ModConfigs.ENTITIES.allayMagicDensity.get() > 0.0, (entity, level, random) -> {
            if (ModTickers.shouldSpawn(random, ModConfigs.ENTITIES.allayMagicDensity)) {
                level.m_7106_((ParticleOptions)ModParticles.ALLAY_MAGIC.get(), entity.m_20208_(1.0), entity.m_20187_(), entity.m_20262_(1.0), MathUtil.nextNonAbsDouble(random, 0.04), 0.0, MathUtil.nextNonAbsDouble(random, 0.04));
            }
        });
        TickerManager.registerSimpleTicker(EntityType.f_20491_, () -> (Double)ModConfigs.ENTITIES.vexMagicDensity.get() > 0.0, (entity, level, random) -> {
            if (ModTickers.shouldSpawn(random, ModConfigs.ENTITIES.vexMagicDensity)) {
                level.m_7106_((ParticleOptions)new BooleanParticleOptions(ModParticles.VEX_MAGIC.get(), entity.m_34028_()), entity.m_20208_(1.0), entity.m_20187_(), entity.m_20262_(1.0), MathUtil.nextNonAbsDouble(random, 0.04), 0.0, MathUtil.nextNonAbsDouble(random, 0.04));
            }
        });
        TickerManager.registerSimpleTicker(EntityType.f_243976_, () -> ModConfigs.ENTITIES.dustClouds.mobRunning, (entity, level, random) -> {
            if (entity.m_245293_() && entity.m_20096_()) {
                for (int i = 0; i < 10; ++i) {
                    ParticleSpawnUtil.spawnCreatureMovementDustCloudsNoConfig((LivingEntity)entity, level, random, 5);
                }
            }
        });
        TickerManager.registerSimpleTicker(EntityType.f_20561_, () -> ModConfigs.ENTITIES.improvedDragonFireballTrail, (entity, level, random) -> {
            for (int i = 0; i < 10; ++i) {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123799_, entity.m_20208_(2.0), entity.m_20187_(), entity.m_20262_(2.0), 0.0, 0.0, 0.0);
            }
        });
        TickerManager.registerSimpleTicker(EntityType.f_20471_, () -> ModConfigs.ENTITIES.commandBlockMinecartParticles != CommandBlockSpawnType.OFF, (entity, level, random) -> {
            if (ModConfigs.ENTITIES.commandBlockMinecartParticles.canTick() && random.m_188503_(10) == 0) {
                ParticleSpawnUtil.spawnCmdBlockParticles(level, entity.m_20182_().m_82520_(0.0, (double)(-(entity.m_38183_() - 8)) / 16.0 + 0.4266666666666667, 0.0), random, (direction, relativePos) -> true);
            }
        });
        TickerManager.registerSimpleTicker(EntityType.f_20515_, () -> ModConfigs.ENTITIES.explosives.tntSparks, (entity, level, random) -> level.m_7106_((ParticleOptions)SparkParticle.create(SparkType.SHORT_LIFE, random), entity.m_20208_(0.5), entity.m_20227_(1.0), entity.m_20262_(0.5), MathUtil.nextNonAbsDouble(random, 0.01), MathUtil.nextNonAbsDouble(random, 0.01), MathUtil.nextNonAbsDouble(random, 0.01)));
        TickerManager.registerSimpleTicker(EntityType.f_20515_, () -> (Integer)ModConfigs.ENTITIES.explosives.tntFlamesDensity.get() > 0, (entity, level, random) -> {
            if (random.m_188503_(10) == 0) {
                int density = (Integer)ModConfigs.ENTITIES.explosives.tntFlamesDensity.get();
                if (density == 1) {
                    level.m_7106_((ParticleOptions)ParticleTypes.f_123744_, entity.m_20185_(), entity.m_20227_(1.1), entity.m_20189_(), 0.0, 0.0, 0.0);
                    return;
                }
                for (int i = 0; i < density; ++i) {
                    level.m_7106_((ParticleOptions)ParticleTypes.f_123744_, entity.m_20208_(0.7), entity.m_20187_(), entity.m_20262_(0.7), 0.0, 0.0, 0.0);
                }
            }
        });
        TickerManager.registerSimpleTicker(EntityType.f_20564_, () -> ModConfigs.ENTITIES.endCrystalParticles, (entity, level, random) -> {
            if (level.m_8055_(entity.m_20183_()).m_60734_() instanceof BaseFireBlock || random.m_188503_(3) == 0) {
                level.m_7106_((ParticleOptions)ModParticles.END_CRYSTAL.get(), entity.m_20208_(1.0), entity.m_20187_() + MathUtil.nextNonAbsDouble(random), entity.m_20262_(1.0), 0.0, 0.0, 0.0);
            }
        });
        TickerManager.registerSimpleTicker(EntityType.f_20478_, () -> ModConfigs.ENTITIES.spectralArrowParticles, (entity, level, random) -> {
            if (random.m_188503_(3) == 0) {
                level.m_7106_((ParticleOptions)Util.GLOWSTONE_DUST_PARTICLES, entity.m_20208_(1.0), entity.m_20187_(), entity.m_20262_(1.0), 0.0, 0.0, 0.0);
            }
        });
        TickerManager.registerSimpleTicker(EntityType.f_20558_, () -> ModConfigs.ENTITIES.explosives.creeperSparks, (entity, level, random) -> {
            if (entity.m_32311_()) {
                for (int i = 0; i < 3; ++i) {
                    level.m_7106_((ParticleOptions)SparkParticle.create(SparkType.SHORT_LIFE, random), entity.m_20208_(1.0), entity.m_20187_(), entity.m_20262_(1.0), MathUtil.nextNonAbsDouble(random, 0.01), MathUtil.nextNonAbsDouble(random, 0.01), MathUtil.nextNonAbsDouble(random, 0.01));
                }
            }
        });
        TickerManager.registerSimpleTicker(EntityType.f_20558_, () -> ModConfigs.ENTITIES.explosives.creeperSmoke.isEnabled(), (entity, level, random) -> {
            if (entity.m_32311_()) {
                level.m_7106_(ModConfigs.ENTITIES.explosives.creeperSmoke.getParticle().get(), entity.m_20208_(1.0), entity.m_20187_(), entity.m_20262_(1.0), MathUtil.nextNonAbsDouble(random, 0.01), MathUtil.nextNonAbsDouble(random, 0.01), MathUtil.nextNonAbsDouble(random, 0.01));
            }
        });
        TickerManager.registerSimpleTicker(entity -> entity instanceof LivingEntity && entity.m_142079_() && ModConfigs.ENTITIES.freezingSnowFlakes, (entity, level, random) -> {
            if (entity.m_203117_() || entity.m_146888_() > 0) {
                level.m_7106_((ParticleOptions)ModParticles.FREEZING.get(), entity.m_20208_(1.0), entity.m_20187_(), entity.m_20262_(1.0), 0.0, 0.0, 0.0);
            }
        });
    }

    public static boolean shouldSpawn(RandomSource random, ValidatedDouble chanceConfig) {
        return (double)Math.min(random.m_188501_(), 1.0f) < (Double)chanceConfig.get();
    }

    private static SleepingTicker<?> getSleepingTicker(LivingEntity entity) {
        if (entity instanceof AbstractVillager) {
            AbstractVillager villager = (AbstractVillager)entity;
            return new VillagerSleepingTicker(villager);
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return new PlayerSleepingTicker(player);
        }
        if (entity instanceof Bat) {
            Bat bat = (Bat)entity;
            return new BatSleepingTicker(bat);
        }
        if (entity instanceof Cat) {
            Cat cat = (Cat)entity;
            return new CatSleepingTicker(cat);
        }
        if (entity instanceof Fox) {
            Fox fox = (Fox)entity;
            return new FoxSleepingTicker(fox);
        }
        return new SleepingTicker<LivingEntity>(entity);
    }

    private static boolean isHumanoid(Entity entity, boolean includePiglins) {
        return entity instanceof Player || ModTickers.isNPC(entity, includePiglins) || entity instanceof Witch;
    }

    private static boolean isNPC(Entity entity, boolean includePiglins) {
        return entity instanceof AbstractVillager || entity instanceof AbstractIllager || includePiglins && entity instanceof AbstractPiglin;
    }
}

