/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.configs;

import einstein.subtle_effects.SubtleEffects;
import einstein.subtle_effects.configs.CommandBlockSpawnType;
import einstein.subtle_effects.configs.SmokeType;
import einstein.subtle_effects.configs.blocks.SparksConfigs;
import einstein.subtle_effects.configs.blocks.SteamConfigs;
import einstein.subtle_effects.configs.blocks.UpdatedSmokeConfigs;
import einstein.subtle_effects.init.ModBlockTickers;
import einstein.subtle_effects.tickers.TickerManager;
import java.util.ArrayList;
import java.util.List;
import me.fzzyhmstrs.fzzy_config.annotations.Translation;
import me.fzzyhmstrs.fzzy_config.config.Config;
import me.fzzyhmstrs.fzzy_config.config.ConfigGroup;
import me.fzzyhmstrs.fzzy_config.entry.Entry;
import me.fzzyhmstrs.fzzy_config.util.EnumTranslatable;
import me.fzzyhmstrs.fzzy_config.validation.collection.ValidatedList;
import me.fzzyhmstrs.fzzy_config.validation.minecraft.ValidatedRegistryType;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedFloat;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedInt;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedNumber;
import net.minecraft.Util;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.NotNull;

@Translation(prefix="config.subtle_effects.blocks")
public class ModBlockConfigs
extends Config {
    private static final List<Block> DEFAULT_FALLING_BLOCK_DUST_BLOCKS = (List)Util.m_137469_(new ArrayList(), blocks -> {
        blocks.add(Blocks.f_49992_);
        blocks.add(Blocks.f_49993_);
        blocks.add(Blocks.f_49994_);
        for (DyeColor color : DyeColor.values()) {
            blocks.add((Block)BuiltInRegistries.f_256975_.m_7745_(new ResourceLocation(color.m_41065_() + "_concrete_powder")));
        }
    });
    public SparksConfigs sparks = new SparksConfigs();
    public UpdatedSmokeConfigs updatedSmoke = new UpdatedSmokeConfigs();
    public SteamConfigs steam = new SteamConfigs();
    public boolean redstoneBlockDust = true;
    public BlockDustDensity redstoneBlockDustDensity = BlockDustDensity.DEFAULT;
    public GlowstoneDustDisplayType glowstoneBlockDustDisplayType = GlowstoneDustDisplayType.ON;
    public BlockDustDensity glowstoneBlockDustDensity = BlockDustDensity.DEFAULT;
    public boolean beehivesHaveSleepingZs = true;
    public ConfigGroup fallingBlockDustGroup = new ConfigGroup("falling_block_dust");
    public boolean fallingBlockDust = true;
    public ValidatedList<Block> fallingBlockDustBlocks = new ValidatedList(DEFAULT_FALLING_BLOCK_DUST_BLOCKS, (Entry)ValidatedRegistryType.of((DefaultedRegistry)BuiltInRegistries.f_256975_));
    @ConfigGroup.Pop
    public ValidatedInt fallingBlockDustDistance = new ValidatedInt(0, 20, 0);
    public SmokeType torchflowerSmoke = SmokeType.DEFAULT;
    public boolean torchflowerFlames = true;
    public boolean dragonEggParticles = true;
    public boolean replaceEndPortalSmoke = true;
    public boolean pumpkinCarvedParticles = true;
    public boolean anvilBreakParticles = true;
    public boolean anvilUseParticles = true;
    public boolean grindstoneUseParticles = true;
    public CommandBlockSpawnType commandBlockParticles = CommandBlockSpawnType.ON;
    public boolean slimeBlockBounceSounds = true;
    public ConfigGroup beaconParticlesGroup = new ConfigGroup("beacon_particles");
    public BeaconParticlesDisplayType beaconParticlesDisplayType = BeaconParticlesDisplayType.ON;
    public ValidatedInt beaconParticlesDensity = new ValidatedInt(10, 20, 1);
    @ConfigGroup.Pop
    public ValidatedFloat beaconParticlesSpeed = new ValidatedFloat(1.0f, 2.0f, 0.5f);
    public boolean compostingParticles = true;
    public boolean respawnAnchorParticles = true;
    public boolean beehiveShearParticles = true;
    public boolean endPortalParticles = true;
    public boolean leavesDecayEffects = true;
    public boolean farmlandDestroyEffects = true;
    public AmethystSparkleDisplayType amethystSparkleDisplayType = AmethystSparkleDisplayType.ON;
    public boolean amethystSparkleSounds = true;
    public boolean floweringAzaleaPetals = true;
    public boolean sculkBlockSculkDust = true;
    public boolean sculkVeinSculkDust = true;
    public boolean sculkShriekerDestroySouls = true;
    public boolean sculkCatalystDestroySouls = true;
    public boolean calibratedSculkSensorAmethystSparkle = true;
    public ValidatedFloat campfireSizzlingSoundVolume = new ValidatedFloat(0.5f, 1.0f, 0.0f);
    public ValidatedInt vegetationFirefliesDensity = new ValidatedInt(30, 100, 0, ValidatedNumber.WidgetType.SLIDER);
    public VegetationFirefliesSpawnType vegetationFirefliesSpawnType = VegetationFirefliesSpawnType.FLOWERS_ONLY;
    public boolean replacePowderSnowFlakes = true;
    public boolean lavaCauldronEffects = true;

    public ModBlockConfigs() {
        super(SubtleEffects.loc("blocks"));
    }

    public void onUpdateClient() {
        TickerManager.clear();
        ModBlockTickers.init();
    }

    public static enum BlockDustDensity implements EnumTranslatable
    {
        DEFAULT(0),
        MINIMAL(2);

        private final int perSideChance;

        private BlockDustDensity(int perSideChance) {
            this.perSideChance = perSideChance;
        }

        @NotNull
        public String prefix() {
            return "config.subtle_effects.blocks.blockDustDensity";
        }

        public int getPerSideChance() {
            return this.perSideChance;
        }
    }

    public static enum GlowstoneDustDisplayType implements EnumTranslatable
    {
        OFF,
        ON,
        NETHER_ONLY;


        @NotNull
        public String prefix() {
            return "config.subtle_effects.blocks.glowstoneBlockDustDisplayType";
        }
    }

    public static enum BeaconParticlesDisplayType implements EnumTranslatable
    {
        OFF,
        ON,
        NOT_COLORED;


        @NotNull
        public String prefix() {
            return "config.subtle_effects.blocks.beaconParticlesDisplayType";
        }
    }

    public static enum AmethystSparkleDisplayType implements EnumTranslatable
    {
        OFF,
        ON,
        CRYSTALS_ONLY;


        @NotNull
        public String prefix() {
            return "config.subtle_effects.blocks.amethystSparkleDisplayType";
        }
    }

    public static enum VegetationFirefliesSpawnType implements EnumTranslatable
    {
        GRASS_AND_FLOWERS,
        FLOWERS_ONLY;


        @NotNull
        public String prefix() {
            return "config.subtle_effects.blocks.vegetationFirefliesSpawnType";
        }
    }
}

