/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.configs;

import einstein.subtle_effects.SubtleEffects;
import einstein.subtle_effects.biome_particles.BiomeParticleManager;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import me.fzzyhmstrs.fzzy_config.annotations.Translation;
import me.fzzyhmstrs.fzzy_config.config.Config;
import me.fzzyhmstrs.fzzy_config.entry.Entry;
import me.fzzyhmstrs.fzzy_config.util.AllowableIdentifiers;
import me.fzzyhmstrs.fzzy_config.validation.collection.ValidatedList;
import me.fzzyhmstrs.fzzy_config.validation.minecraft.ValidatedIdentifier;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedInt;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;

@Translation(prefix="config.subtle_effects.biomes")
public class ModBiomeConfigs
extends Config {
    public boolean biomeColorRain = true;
    @ValidatedInt.Restrict(min=0, max=32)
    public int biomeParticlesRadius = 32;
    public ValidatedList<ResourceLocation> mushroomSporeBiomes = ModBiomeConfigs.biomeList("mushroom_fields");
    public ValidatedInt mushroomSporeDensity = new ValidatedInt(10, 100, 0);
    public ValidatedList<ResourceLocation> fireflyBiomes = ModBiomeConfigs.biomeList("swamp", "mangrove_swamp");
    public ValidatedInt fireflyDensity = new ValidatedInt(6, 100, 0);
    public ValidatedList<ResourceLocation> pollenBiomes = ModBiomeConfigs.biomeList("flower_forest", "sunflower_plains");
    public ValidatedInt pollenDensity = new ValidatedInt(50, 100, 0);
    public ValidatedList<ResourceLocation> sculkDustBiomes = ModBiomeConfigs.biomeList("deep_dark");
    public ValidatedInt sculkDustDensity = new ValidatedInt(5, 100, 0);

    public ModBiomeConfigs() {
        super(SubtleEffects.loc("biomes"));
    }

    public void onUpdateClient() {
        BiomeParticleManager.clear();
    }

    public static ValidatedList<ResourceLocation> biomeList(String ... biomeIds) {
        return new ValidatedList(Arrays.stream(biomeIds).map(ResourceLocation::new).toList(), (Entry)new ValidatedIdentifier(new ResourceLocation("air"), new AllowableIdentifiers(location -> ModBiomeConfigs.getBiomeRegistry().map(biomes -> biomes.m_7804_(location)).orElse(true), () -> ModBiomeConfigs.getBiomeRegistry().map(biomes -> biomes.m_6566_().stream().toList()).orElseGet(List::of))));
    }

    private static Optional<Registry<Biome>> getBiomeRegistry() {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level != null) {
            return level.m_9598_().m_6632_(Registries.f_256952_);
        }
        return Optional.empty();
    }
}

