/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.biome_particles;

import einstein.subtle_effects.biome_particles.BiomeParticleSettings;
import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.init.ModParticles;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import me.fzzyhmstrs.fzzy_config.validation.collection.ValidatedList;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedInt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;

public class BiomeParticleManager {
    private static final List<BiomeParticleSettings> REGISTERED = new ArrayList<BiomeParticleSettings>();
    private static final BlockPos.MutableBlockPos BIOME_POS = new BlockPos.MutableBlockPos();
    private static final BiPredicate<Level, BlockPos> NOT_RAINING = (level, pos) -> !level.m_46471_();
    public static final BiPredicate<Level, BlockPos> FIREFLY_CONDITIONS = NOT_RAINING.and((level, pos) -> {
        float time = (float)level.m_46468_() % 24000.0f;
        return time > 13000.0f && time < 23000.0f && level.m_45517_(LightLayer.BLOCK, pos) <= 5 && ((Biome)level.m_204166_(pos).m_203334_()).m_198906_(pos);
    });
    private static boolean HAS_CLEARED;

    public static void init() {
        BiomeParticleManager.register(ModConfigs.BIOMES.mushroomSporeBiomes, ModConfigs.BIOMES.mushroomSporeDensity, 40, ModParticles.MUSHROOM_SPORE, NOT_RAINING);
        BiomeParticleManager.register(ModConfigs.BIOMES.fireflyBiomes, ModConfigs.BIOMES.fireflyDensity, 10, ModParticles.FIREFLY, FIREFLY_CONDITIONS);
        BiomeParticleManager.register(ModConfigs.BIOMES.pollenBiomes, ModConfigs.BIOMES.pollenDensity, 10, ModParticles.POLLEN, NOT_RAINING);
        BiomeParticleManager.register(ModConfigs.BIOMES.sculkDustBiomes, ModConfigs.BIOMES.sculkDustDensity, ModParticles.SCULK_DUST, (level, pos) -> true);
    }

    private static void register(ValidatedList<ResourceLocation> biomesConfig, ValidatedInt density, int maxSpawnHeight, Supplier<? extends ParticleOptions> particle, BiPredicate<Level, BlockPos> spawnConditions) {
        REGISTERED.add(new BiomeParticleSettings(biomesConfig, density, maxSpawnHeight, particle, spawnConditions, false));
    }

    private static void register(ValidatedList<ResourceLocation> biomesConfig, ValidatedInt density, Supplier<? extends ParticleOptions> particle, BiPredicate<Level, BlockPos> spawnConditions) {
        REGISTERED.add(new BiomeParticleSettings(biomesConfig, density, 0, particle, spawnConditions, true));
    }

    public static void tickBiomeParticles(Level level, Player player) {
        int radius;
        if (HAS_CLEARED) {
            HAS_CLEARED = false;
            REGISTERED.forEach(settings -> settings.update(level));
        }
        if ((radius = ModConfigs.BIOMES.biomeParticlesRadius) <= 0) {
            return;
        }
        for (int i = 0; i < 100; ++i) {
            RandomSource random = level.m_213780_();
            int x = player.m_146903_() + random.m_188503_(radius) - random.m_188503_(radius);
            int y = player.m_146904_() + random.m_188503_(radius) - random.m_188503_(radius);
            int z = player.m_146907_() + random.m_188503_(radius) - random.m_188503_(radius);
            BIOME_POS.m_122178_(x, y, z);
            if (level.m_151562_(y)) continue;
            Holder biome = level.m_204166_((BlockPos)BIOME_POS);
            for (BiomeParticleSettings settings2 : REGISTERED) {
                BlockState state;
                int surfaceLevel;
                List<Biome> biomes;
                if (settings2.getDensity() <= i || !settings2.checkSpawnConditions(level, (BlockPos)BIOME_POS) || (biomes = settings2.getBiomes()).isEmpty() || !settings2.ignoreHeight() && ((surfaceLevel = level.m_6924_(Heightmap.Types.MOTION_BLOCKING, x, z)) > y || surfaceLevel + settings2.getMaxSpawnHeight() < y) || !biomes.contains(biome.m_203334_()) || (state = level.m_8055_((BlockPos)BIOME_POS)).m_60838_((BlockGetter)level, (BlockPos)BIOME_POS)) continue;
                level.m_7106_(settings2.getParticle().get(), (double)x + random.m_188500_(), (double)y + random.m_188500_(), (double)z + random.m_188500_(), 0.0, 0.0, 0.0);
            }
        }
    }

    public static void clear() {
        REGISTERED.forEach(BiomeParticleSettings::clear);
        HAS_CLEARED = true;
    }
}

