/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import einstein.subtle_effects.biome_particles.BiomeParticleManager;
import einstein.subtle_effects.init.ModBlockTickers;
import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.init.ModDamageListeners;
import einstein.subtle_effects.init.ModParticleProviders;
import einstein.subtle_effects.init.ModTickers;
import einstein.subtle_effects.tickers.TickerManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class SubtleEffectsClient {
    private static boolean HAS_CLEARED = false;
    private static Level LEVEL;

    public static void clientSetup() {
        ModConfigs.init();
        ModTickers.init();
        ModBlockTickers.init();
        BiomeParticleManager.init();
        ModDamageListeners.init();
        ModParticleProviders.init();
    }

    public static void clientTick(Minecraft minecraft, Level level) {
        LocalPlayer player = minecraft.f_91074_;
        if (level == null || player == null || LEVEL != level) {
            LEVEL = level;
            if (!HAS_CLEARED) {
                TickerManager.clear();
                BiomeParticleManager.clear();
                HAS_CLEARED = true;
            }
            return;
        }
        if (minecraft.m_91104_()) {
            return;
        }
        BiomeParticleManager.tickBiomeParticles(level, (Player)player);
        TickerManager.tickTickers(level);
        HAS_CLEARED = false;
    }

    public static <T extends SharedSuggestionProvider> void registerClientCommands(CommandDispatcher<T> dispatcher, CommandBuildContext buildContext) {
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        LiteralArgumentBuilder particlesClear = (LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"clear").executes(arg_0 -> SubtleEffectsClient.lambda$registerClientCommands$0(minecraft, (Player)player, arg_0));
        LiteralArgumentBuilder particles = (LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"particles").then((ArgumentBuilder)particlesClear);
        LiteralArgumentBuilder tickersClear = (LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"clear").executes(arg_0 -> SubtleEffectsClient.lambda$registerClientCommands$1((Player)player, arg_0));
        LiteralArgumentBuilder tickers = (LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"tickers").then((ArgumentBuilder)tickersClear);
        LiteralArgumentBuilder subtleEffects = (LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"subtle_effects").then((ArgumentBuilder)particles)).then((ArgumentBuilder)tickers);
        LiteralCommandNode subtleEffectsNode = dispatcher.register(subtleEffects);
        dispatcher.register((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"se").redirect((CommandNode)subtleEffectsNode));
    }

    private static MutableComponent getMsgTranslation(String string) {
        return Component.m_237115_((String)("commands.subtle_effects." + string));
    }

    private static void sendSystemMsg(Player player, Component component) {
        if (player != null) {
            player.m_213846_(component);
        }
    }

    private static /* synthetic */ int lambda$registerClientCommands$1(Player player, CommandContext context) throws CommandSyntaxException {
        TickerManager.clear();
        SubtleEffectsClient.sendSystemMsg(player, (Component)SubtleEffectsClient.getMsgTranslation("subtle_effects.tickers.clear.success"));
        return 1;
    }

    private static /* synthetic */ int lambda$registerClientCommands$0(Minecraft minecraft, Player player, CommandContext context) throws CommandSyntaxException {
        minecraft.f_91061_.m_263560_();
        SubtleEffectsClient.sendSystemMsg(player, (Component)SubtleEffectsClient.getMsgTranslation("subtle_effects.particles.clear.success"));
        return 1;
    }
}

