/*
 * Decompiled with CFR 0.152.
 */
package dev.imb11.sounds.dynamic;

import com.mojang.serialization.Codec;
import dev.imb11.sounds.api.SoundDefinition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.function.Function;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.level.block.SoundType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicSoundHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(DynamicSoundHelper.class);
    protected static HashMap<String, Codec<?>> loadDirectories = new HashMap();
    protected static HashMap<String, ArrayList<?>> loadedDefinitions = new HashMap();

    protected static void declareDefinitionsToLoad(String directory, Codec<?> codec) {
        loadDirectories.put(directory, codec);
        loadedDefinitions.put(directory, new ArrayList());
    }

    protected static void clearDefinitions() {
        loadedDefinitions.values().forEach(ArrayList::clear);
    }

    public static void initialize() {
        DynamicSoundHelper.declareDefinitionsToLoad("items", SoundDefinition.getCodec(BuiltInRegistries.f_257033_.m_123023_()));
        DynamicSoundHelper.declareDefinitionsToLoad("screens", SoundDefinition.getCodec(BuiltInRegistries.f_256818_.m_123023_()));
    }

    public static <T> ArrayList<SoundDefinition<T>> getDefinitions(String directory) {
        return loadedDefinitions.get(directory);
    }

    public static enum BlockSoundType {
        PLACE(SoundType::m_56777_),
        HIT(SoundType::m_56778_),
        BREAK(SoundType::m_56775_),
        FALL(SoundType::m_56779_),
        STEP(SoundType::m_56776_);

        private final Function<SoundType, SoundEvent> transformer;

        private BlockSoundType(Function<SoundType, SoundEvent> transformer) {
            this.transformer = transformer;
        }

        public Function<SoundType, SoundEvent> getTransformer() {
            return this.transformer;
        }
    }
}

