/*
 * Decompiled with CFR 0.152.
 */
package io.github.lieonlion.quad.util;

import io.github.lieonlion.quad.enchantment.QuadEnchantmentHelper;
import io.github.lieonlion.quad.tags.QuadEnchantmentTags;
import io.github.lieonlion.quad.tags.QuadItemTags;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.CandleCakeBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class QuadUtil {
    public static void usedFireLighter(Level level, BlockState state, BlockPos pos, Player player, InteractionHand hand, ItemStack stack) {
        if (CampfireBlock.m_51321_((BlockState)state) || CandleBlock.m_152845_((BlockState)state) || CandleCakeBlock.m_152910_((BlockState)state)) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(true)), 11);
        }
        QuadUtil.usedFireLighter(level, pos, player, hand, stack);
    }

    public static void usedFireLighter(Level level, BlockPos pos, Player player, InteractionHand hand, ItemStack stack) {
        level.m_5594_(player, pos, SoundEvents.f_11942_, SoundSource.BLOCKS, 1.0f, level.m_213780_().m_188501_() * 0.4f + 0.8f);
        player.m_36246_(Stats.f_12982_.m_12902_((Object)stack.m_41720_()));
        if (!stack.m_150930_(Items.f_42690_) && !player.m_7500_()) {
            if (stack.m_41763_()) {
                stack.m_41622_(1, (LivingEntity)player, playerX -> playerX.m_21190_(hand));
            } else if (!QuadEnchantmentHelper.hasFireLighter(stack)) {
                stack.m_41774_(1);
            }
        }
    }

    public static boolean hasEquipmentFromTag(TagKey<Item> itemTagKey, LivingEntity living) {
        for (ItemStack stack : living.m_6168_()) {
            if (!stack.m_204117_(itemTagKey)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasItemOrEnchantmentEquipmentFromTag(TagKey<Item> itemTagKey, TagKey<Enchantment> enchantmentTagKey, LivingEntity living) {
        return QuadEnchantmentHelper.hasEnchantmentEquipmentFromTag(enchantmentTagKey, living) || QuadUtil.hasEquipmentFromTag(itemTagKey, living);
    }

    public static boolean isFireLighter(ItemStack stack) {
        return stack.m_204117_(QuadItemTags.FIRE_LIGHTER) || QuadEnchantmentHelper.hasFireLighter(stack);
    }

    public static boolean isSnowActsSolid(ItemStack stack) {
        return stack.m_204117_(QuadItemTags.SNOW_ACTS_SOLID) || QuadEnchantmentHelper.hasSnowBoots(stack);
    }

    public static boolean hasBurnsProtector(LivingEntity living) {
        return QuadUtil.hasItemOrEnchantmentEquipmentFromTag(QuadItemTags.PROTECTS_FROM_BURNS, QuadEnchantmentTags.PROTECTS_FROM_BURNS, living);
    }

    public static boolean hasPiglinPacifier(LivingEntity living) {
        return QuadUtil.hasItemOrEnchantmentEquipmentFromTag(QuadItemTags.PACIFIER_PIGLIN, QuadEnchantmentTags.PACIFIER_PIGLIN, living);
    }

    public static boolean hasEndermanPacifier(LivingEntity living) {
        return QuadUtil.hasItemOrEnchantmentEquipmentFromTag(QuadItemTags.PACIFIER_ENDERMAN, QuadEnchantmentTags.PACIFIER_ENDERMAN, living);
    }

    public static boolean hasSnowBoots(LivingEntity living) {
        return QuadUtil.hasItemOrEnchantmentEquipmentFromTag(QuadItemTags.SNOW_BOOTS, QuadEnchantmentTags.SNOW_BOOTS, living);
    }
}

