/*
 * Decompiled with CFR 0.152.
 */
package io.github.lieonlion.quad.registry;

import io.github.lieonlion.quad.Quad;
import io.github.lieonlion.quad.tags.QuadItemTags;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.furnace.FurnaceFuelBurnTimeEvent;

public class QuadFuelRegistry {
    public static Map<Item, Integer> default_map = new HashMap<Item, Integer>();

    public static void makeMap() {
        if (!default_map.isEmpty()) {
            return;
        }
        BuiltInRegistries.f_257033_.forEach(item -> {
            int burnTime = ForgeHooks.getBurnTime((ItemStack)item.m_7968_(), null);
            if (burnTime > 0) {
                default_map.put((Item)item, burnTime);
            }
        });
        Quad.LOGGER.info("[Quad] cached original fuel map with count of: {}", (Object)default_map.size());
    }

    public static void onFurnaceFuelBurnTime(FurnaceFuelBurnTimeEvent event) {
        ItemStack stack = event.getItemStack();
        if (default_map.containsKey(stack.m_41720_())) {
            event.setBurnTime(default_map.getOrDefault(stack.m_41720_(), 0).intValue());
        }
        if (stack.m_204117_(QuadItemTags.FUEL_BAMBOO)) {
            event.setBurnTime(50);
        }
        if (stack.m_204117_(QuadItemTags.FUEL_CARPET)) {
            event.setBurnTime(67);
        }
        if (stack.m_204117_(QuadItemTags.FUEL_WOOL)) {
            event.setBurnTime(100);
        }
        if (stack.m_204117_(QuadItemTags.FUEL_WOOD_SLAB)) {
            event.setBurnTime(150);
        }
        if (stack.m_204117_(QuadItemTags.FUEL_WOOD_TOOL)) {
            event.setBurnTime(200);
        }
        if (stack.m_204117_(QuadItemTags.FUEL_WOOD)) {
            event.setBurnTime(300);
        }
        if (stack.m_204117_(QuadItemTags.FUEL_HANGING_SIGN)) {
            event.setBurnTime(800);
        }
        if (stack.m_204117_(QuadItemTags.FUEL_BOAT)) {
            event.setBurnTime(1200);
        }
        if (stack.m_204117_(QuadItemTags.FUEL_COAL)) {
            event.setBurnTime(1600);
        }
        if (stack.m_204117_(QuadItemTags.FUEL_BLAZE_ROD)) {
            event.setBurnTime(2400);
        }
        if (stack.m_204117_(QuadItemTags.FUEL_DRIED_KELP_BLOCK)) {
            event.setBurnTime(4001);
        }
        if (stack.m_204117_(QuadItemTags.FUEL_COAL_BLOCK)) {
            event.setBurnTime(16000);
        }
        if (stack.m_204117_(QuadItemTags.FUEL_LAVA)) {
            event.setBurnTime(20000);
        }
    }
}

