/*
 * Decompiled with CFR 0.152.
 */
package io.github.lieonlion.quad.enchantment;

import io.github.lieonlion.quad.tags.QuadEnchantmentTags;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;

public class QuadEnchantmentHelper {
    public static int getLevelFromTag(TagKey<Enchantment> enchantmentTagKey, ItemStack stack) {
        Enchantment enchantment = QuadEnchantmentHelper.getEnchantmentFromTag(enchantmentTagKey, stack);
        return QuadEnchantmentHelper.getLevel(enchantment, stack);
    }

    public static int getEquipmentLevelFromTag(TagKey<Enchantment> enchantmentTagKey, LivingEntity living) {
        ItemStack stack = QuadEnchantmentHelper.getEquipmentFromTag(enchantmentTagKey, living);
        Enchantment enchantment = QuadEnchantmentHelper.getEnchantmentFromTag(enchantmentTagKey, stack);
        return enchantment != null || stack != null ? QuadEnchantmentHelper.getLevel(enchantment, stack) : 0;
    }

    public static Enchantment getEnchantmentFromTag(TagKey<Enchantment> enchantmentTagKey, ItemStack stack) {
        if (stack == null) {
            return null;
        }
        for (Map.Entry entry : EnchantmentHelper.m_44831_((ItemStack)stack).entrySet()) {
            Enchantment enchantment = (Enchantment)entry.getKey();
            if (enchantment == null || !QuadEnchantmentHelper.getRegistryHolder(enchantment).m_203656_(enchantmentTagKey)) continue;
            return enchantment;
        }
        return null;
    }

    public static ItemStack getEquipmentFromTag(TagKey<Enchantment> enchantmentTagKey, LivingEntity living) {
        for (ItemStack stack : living.m_6168_()) {
            if (!QuadEnchantmentHelper.hasEnchantmentFromTag(enchantmentTagKey, stack)) continue;
            return stack;
        }
        return null;
    }

    public static int getLevel(Enchantment enchantment, ItemStack stack) {
        for (Map.Entry entry : EnchantmentHelper.m_44831_((ItemStack)stack).entrySet()) {
            if (enchantment != entry.getKey()) continue;
            return (Integer)entry.getValue();
        }
        return 0;
    }

    public static boolean hasEnchantmentFromTag(TagKey<Enchantment> enchantmentTagKey, ItemStack stack) {
        return QuadEnchantmentHelper.getLevelFromTag(enchantmentTagKey, stack) > 0;
    }

    public static boolean hasEnchantmentEquipmentFromTag(TagKey<Enchantment> enchantmentTagKey, LivingEntity living) {
        return QuadEnchantmentHelper.getEquipmentLevelFromTag(enchantmentTagKey, living) > 0;
    }

    public static boolean hasFireLighter(ItemStack stack) {
        return QuadEnchantmentHelper.getLevelFromTag(QuadEnchantmentTags.FIRE_LIGHTER, stack) > 0;
    }

    public static boolean hasSnowBoots(ItemStack stack) {
        return QuadEnchantmentHelper.getLevelFromTag(QuadEnchantmentTags.SNOW_BOOTS, stack) > 0;
    }

    public static Holder<Enchantment> getRegistryHolder(Enchantment enchantment) {
        return BuiltInRegistries.f_256876_.m_263177_((Object)enchantment);
    }
}

