/*
 * Decompiled with CFR 0.152.
 */
package fuzs.pickupnotifier.client.handler;

import fuzs.pickupnotifier.PickUpNotifier;
import fuzs.pickupnotifier.client.gui.entry.DisplayEntry;
import fuzs.pickupnotifier.client.gui.entry.ExperienceDisplayEntry;
import fuzs.pickupnotifier.client.gui.entry.ItemDisplayEntry;
import fuzs.pickupnotifier.client.handler.DrawEntriesHandler;
import fuzs.pickupnotifier.client.handler.ItemBlacklistManager;
import fuzs.pickupnotifier.config.ClientConfig;
import fuzs.pickupnotifier.mixin.client.accessor.AbstractArrowAccessor;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class AddEntriesHandler {
    public static void onEntityPickup(Minecraft minecraft, int entityId, int playerId, int amount) {
        if (Minecraft.m_91087_().f_91073_.m_6815_(playerId) instanceof LocalPlayer && !DrawEntriesHandler.INSTANCE.isItemEntityHandled(entityId)) {
            AddEntriesHandler.onEntityPickup(minecraft, entityId, amount);
        }
    }

    public static void addPickUpEntry(Minecraft minecraft, int entityId, int amount) {
        if (!((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).general.forceClient) {
            DrawEntriesHandler.INSTANCE.addHandledEntity(entityId);
            AddEntriesHandler.onEntityPickup(minecraft, entityId, amount);
        }
    }

    public static void addItemEntry(Minecraft minecraft, ItemStack stack) {
        if (!((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).general.forceClient && ((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).general.includeItems) {
            AddEntriesHandler.addItemEntry(minecraft, stack, stack.m_41613_());
        }
    }

    private static void onEntityPickup(Minecraft minecraft, int itemId, int amount) {
        Entity entity = minecraft.f_91073_.m_6815_(itemId);
        if (entity instanceof ItemEntity) {
            ItemEntity item = (ItemEntity)entity;
            if (((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).general.includeItems) {
                AddEntriesHandler.addItemEntry(minecraft, item.m_32055_(), amount);
            }
        } else if (entity instanceof AbstractArrow) {
            if (((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).general.includeArrows) {
                AddEntriesHandler.addItemEntry(minecraft, ((AbstractArrowAccessor)entity).pickupnotifier$callGetPickupItem(), amount);
            }
        } else if (entity instanceof ExperienceOrb) {
            ExperienceOrb experience = (ExperienceOrb)entity;
            if (((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).general.includeExperience) {
                AddEntriesHandler.addExperienceEntry(minecraft, experience, amount);
            }
        }
    }

    private static void addItemEntry(Minecraft minecraft, ItemStack stack, int amount) {
        if (!stack.m_41619_() && ItemBlacklistManager.INSTANCE.isItemAllowed((ResourceKey<Level>)minecraft.f_91073_.m_46472_(), stack.m_41720_())) {
            stack = stack.m_41777_();
            if (((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).behavior.combineEntries == ClientConfig.CombineEntries.ALWAYS) {
                stack.m_41749_("Enchantments");
            }
            AddEntriesHandler.addEntry(minecraft, new ItemDisplayEntry(stack, amount));
        }
    }

    private static void addExperienceEntry(Minecraft minecraft, ExperienceOrb orb, int amount) {
        if (orb.m_20801_() > 0) {
            if (((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).general.experienceValue) {
                amount = orb.m_20801_();
            }
            AddEntriesHandler.addEntry(minecraft, new ExperienceDisplayEntry(orb.m_7755_(), amount));
        }
    }

    private static void addEntry(Minecraft minecraft, DisplayEntry newEntry) {
        if (minecraft.f_91074_ != null && minecraft.f_91074_.m_150110_().f_35937_ && ((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).general.disableInCreative) {
            return;
        }
        int scaledHeight = (int)((float)minecraft.m_91268_().m_85446_() / ((float)((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).display.scale / 6.0f));
        int maxSize = (int)((double)scaledHeight * ((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).display.maxHeight / 18.0) - 1;
        ClientConfig.CombineEntries combineEntries = ((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).behavior.combineEntries;
        Optional<Object> possibleDuplicate = combineEntries == ClientConfig.CombineEntries.NEVER ? Optional.empty() : DrawEntriesHandler.INSTANCE.getCollector().findDuplicate(newEntry, combineEntries == ClientConfig.CombineEntries.EXCLUDE_NAMED);
        if (possibleDuplicate.isPresent()) {
            DisplayEntry duplicate = (DisplayEntry)possibleDuplicate.get();
            duplicate.mergeWith(newEntry);
            DrawEntriesHandler.INSTANCE.getCollector().refresh(duplicate);
        } else {
            DrawEntriesHandler.INSTANCE.getCollector().add(newEntry, maxSize);
        }
    }
}

