/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.perception.common.modules.trail.config.data;

import it.hurts.octostudios.octolib.modules.config.annotations.Prop;
import org.joml.Vector3f;

public class TrailConfigData {
    @Prop(comment="Trail thickness")
    private float size = 0.1f;
    @Prop(comment="Maximum trail length, measured in points that are placed every N ticks, where N is the value of updateFrequency")
    private int maxPoints = 5;
    @Prop(comment="Minimum object movement speed to place trail points")
    private float minSpeed = 0.001f;
    @Prop(comment="Frequency of trail point placement")
    private int updateFrequency = 1;
    @Prop(comment="Starting color of the trail in ARGB format")
    private String fadeInColor = "FFFFFFFF";
    @Prop(comment="Ending color of the trail in ARGB format")
    private String fadeOutColor = "FFFFFFFF";
    @Prop(comment="Position offset of the trail relative to the object in XYZ")
    private Vector3f positionOffset = new Vector3f(0.0f, 0.0f, 0.0f);
    @Prop(comment="Position offset of the trail in the opposite direction from the player's standing point")
    private float backwardShift = 0.0f;
    @Prop(comment="Position offset of the trail in the opposite direction from the object's movement")
    private float motionShift = 0.25f;

    public float getSize() {
        return this.size;
    }

    public int getMaxPoints() {
        return this.maxPoints;
    }

    public float getMinSpeed() {
        return this.minSpeed;
    }

    public int getUpdateFrequency() {
        return this.updateFrequency;
    }

    public String getFadeInColor() {
        return this.fadeInColor;
    }

    public String getFadeOutColor() {
        return this.fadeOutColor;
    }

    public Vector3f getPositionOffset() {
        return this.positionOffset;
    }

    public float getBackwardShift() {
        return this.backwardShift;
    }

    public float getMotionShift() {
        return this.motionShift;
    }

    public void setSize(float size) {
        this.size = size;
    }

    public void setMaxPoints(int maxPoints) {
        this.maxPoints = maxPoints;
    }

    public void setMinSpeed(float minSpeed) {
        this.minSpeed = minSpeed;
    }

    public void setUpdateFrequency(int updateFrequency) {
        this.updateFrequency = updateFrequency;
    }

    public void setFadeInColor(String fadeInColor) {
        this.fadeInColor = fadeInColor;
    }

    public void setFadeOutColor(String fadeOutColor) {
        this.fadeOutColor = fadeOutColor;
    }

    public void setPositionOffset(Vector3f positionOffset) {
        this.positionOffset = positionOffset;
    }

    public void setBackwardShift(float backwardShift) {
        this.backwardShift = backwardShift;
    }

    public void setMotionShift(float motionShift) {
        this.motionShift = motionShift;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TrailConfigData)) {
            return false;
        }
        TrailConfigData other = (TrailConfigData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Float.compare(this.getSize(), other.getSize()) != 0) {
            return false;
        }
        if (this.getMaxPoints() != other.getMaxPoints()) {
            return false;
        }
        if (Float.compare(this.getMinSpeed(), other.getMinSpeed()) != 0) {
            return false;
        }
        if (this.getUpdateFrequency() != other.getUpdateFrequency()) {
            return false;
        }
        if (Float.compare(this.getBackwardShift(), other.getBackwardShift()) != 0) {
            return false;
        }
        if (Float.compare(this.getMotionShift(), other.getMotionShift()) != 0) {
            return false;
        }
        String this$fadeInColor = this.getFadeInColor();
        String other$fadeInColor = other.getFadeInColor();
        if (this$fadeInColor == null ? other$fadeInColor != null : !this$fadeInColor.equals(other$fadeInColor)) {
            return false;
        }
        String this$fadeOutColor = this.getFadeOutColor();
        String other$fadeOutColor = other.getFadeOutColor();
        if (this$fadeOutColor == null ? other$fadeOutColor != null : !this$fadeOutColor.equals(other$fadeOutColor)) {
            return false;
        }
        Vector3f this$positionOffset = this.getPositionOffset();
        Vector3f other$positionOffset = other.getPositionOffset();
        return !(this$positionOffset == null ? other$positionOffset != null : !this$positionOffset.equals(other$positionOffset));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TrailConfigData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getSize());
        result = result * 59 + this.getMaxPoints();
        result = result * 59 + Float.floatToIntBits(this.getMinSpeed());
        result = result * 59 + this.getUpdateFrequency();
        result = result * 59 + Float.floatToIntBits(this.getBackwardShift());
        result = result * 59 + Float.floatToIntBits(this.getMotionShift());
        String $fadeInColor = this.getFadeInColor();
        result = result * 59 + ($fadeInColor == null ? 43 : $fadeInColor.hashCode());
        String $fadeOutColor = this.getFadeOutColor();
        result = result * 59 + ($fadeOutColor == null ? 43 : $fadeOutColor.hashCode());
        Vector3f $positionOffset = this.getPositionOffset();
        result = result * 59 + ($positionOffset == null ? 43 : $positionOffset.hashCode());
        return result;
    }

    public String toString() {
        return "TrailConfigData(size=" + this.getSize() + ", maxPoints=" + this.getMaxPoints() + ", minSpeed=" + this.getMinSpeed() + ", updateFrequency=" + this.getUpdateFrequency() + ", fadeInColor=" + this.getFadeInColor() + ", fadeOutColor=" + this.getFadeOutColor() + ", positionOffset=" + String.valueOf(this.getPositionOffset()) + ", backwardShift=" + this.getBackwardShift() + ", motionShift=" + this.getMotionShift() + ")";
    }

    public TrailConfigData() {
    }

    public TrailConfigData(float size, int maxPoints, float minSpeed, int updateFrequency, String fadeInColor, String fadeOutColor, Vector3f positionOffset, float backwardShift, float motionShift) {
        this.size = size;
        this.maxPoints = maxPoints;
        this.minSpeed = minSpeed;
        this.updateFrequency = updateFrequency;
        this.fadeInColor = fadeInColor;
        this.fadeOutColor = fadeOutColor;
        this.positionOffset = positionOffset;
        this.backwardShift = backwardShift;
        this.motionShift = motionShift;
    }
}

