/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.perception.common.modules.shake.config.data;

import it.hurts.octostudios.octolib.modules.config.annotations.Prop;

public class FallShakeConfigData {
    @Prop(comment="Generic intensity of the screen shake during a fall. If the value is 0 or below, the effect is disabled.")
    private float intensity = 0.0f;
    @Prop(comment="Min player's vertical speed required to trigger the screen shake effect.")
    private float minSpeed = 0.5f;

    public float getIntensity() {
        return this.intensity;
    }

    public float getMinSpeed() {
        return this.minSpeed;
    }

    public void setIntensity(float intensity) {
        this.intensity = intensity;
    }

    public void setMinSpeed(float minSpeed) {
        this.minSpeed = minSpeed;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FallShakeConfigData)) {
            return false;
        }
        FallShakeConfigData other = (FallShakeConfigData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Float.compare(this.getIntensity(), other.getIntensity()) != 0) {
            return false;
        }
        return Float.compare(this.getMinSpeed(), other.getMinSpeed()) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof FallShakeConfigData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getIntensity());
        result = result * 59 + Float.floatToIntBits(this.getMinSpeed());
        return result;
    }

    public String toString() {
        return "FallShakeConfigData(intensity=" + this.getIntensity() + ", minSpeed=" + this.getMinSpeed() + ")";
    }

    public FallShakeConfigData() {
    }

    public FallShakeConfigData(float intensity, float minSpeed) {
        this.intensity = intensity;
        this.minSpeed = minSpeed;
    }
}

