/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.perception.common.modules.shake.config;

import it.hurts.octostudios.octolib.modules.config.annotations.Prop;
import it.hurts.octostudios.perception.common.modules.base.config.ModuleConfig;
import it.hurts.octostudios.perception.common.modules.shake.config.data.FallShakeConfigData;
import it.hurts.octostudios.perception.common.modules.shake.config.data.ShakeConfigData;
import java.util.HashMap;
import java.util.Map;

public class ShakeConfig
extends ModuleConfig {
    @Prop(comment="Options for configuring the screen shake effect during player falls.")
    private FallShakeConfigData fallShakes = new FallShakeConfigData();
    @Prop(comment="List of sound effects that trigger the screen shaking effect.\n\n[rangeMultiplier] - Multiplier of the standard sound playback range, which will be used as the radius for the screen shake effect;\n[rotationAmplitude|offsetAmplitude|fovAmplitude] - The intensity of the screen shaking;\n[rotationSpeed|offsetSpeed|fovSpeed] - The speed of the screen shaking;\n[duration] - The duration of the screen shaking;\n[fadeInTime] - The time in ticks for interpolating the screen shaking from the minimum to the maximum value. Applied at the start of the shaking effect;\n[fadeOutTime] - The time in ticks for interpolating the screen shaking from the maximum to the minimum value. Applied at the end of the shaking effect. A value of -1 sets the interpolation duration equal to the effect's total duration.\n\n* Rotation - Tilt of the screen away from the source of the shake;\n* Offset - Offset of the position away from the source of the shake;\n* FOV (Field of View) - Screen zoom-out.\n")
    private Map<String, ShakeConfigData> soundShakes = new HashMap<String, ShakeConfigData>(){
        {
            this.put("minecraft:entity.ender_dragon.ambient", ShakeConfigData.builder().amplitude(0.05f).speed(10.0f).duration(60).build());
            this.put("minecraft:entity.ender_dragon.growl", ShakeConfigData.builder().amplitude(0.05f).speed(10.0f).duration(60).build());
            this.put("minecraft:block.sculk_shrieker.shriek", ShakeConfigData.builder().amplitude(0.025f).speed(10.0f).duration(80).build());
            this.put("minecraft:entity.warden.dig", ShakeConfigData.builder().amplitude(0.1f).speed(15.0f).duration(80).fadeInTime(50).fadeOutTime(20).build());
            this.put("minecraft:entity.warden.emerge", ShakeConfigData.builder().amplitude(0.15f).speed(10.0f).duration(120).build());
            this.put("minecraft:entity.warden.sonic_boom", ShakeConfigData.builder().amplitude(0.25f).speed(7.0f).duration(50).build());
            this.put("minecraft:entity.warden.roar", ShakeConfigData.builder().amplitude(0.15f).speed(15.0f).duration(60).fadeInTime(10).build());
            this.put("minecraft:entity.warden.heartbeat", ShakeConfigData.builder().amplitude(0.05f, 0.075f, 0.0f).speed(10.0f).duration(5).build());
            this.put("minecraft:block.anvil.place", ShakeConfigData.builder().amplitude(0.1f).speed(7.5f).duration(5).build());
            this.put("minecraft:block.anvil.land", ShakeConfigData.builder().amplitude(0.075f).speed(7.5f).duration(5).build());
            this.put("minecraft:block.end_portal.spawn", ShakeConfigData.builder().amplitude(0.0f, 0.1f, 0.25f).speed(10.0f).duration(80).build());
            this.put("minecraft:entity.wither.spawn", ShakeConfigData.builder().amplitude(0.05f, 0.05f, 0.1f).speed(10.0f).duration(60).build());
            this.put("minecraft:entity.ender_dragon.death", ShakeConfigData.builder().amplitude(0.05f, 0.05f, 0.15f).speed(10.0f).duration(260).build());
            this.put("minecraft:entity.elder_guardian.curse", ShakeConfigData.builder().amplitude(0.15f, 0.05f, 0.2f).speed(2.0f, 2.0f, 10.0f).duration(30).build());
            this.put("minecraft:entity.generic.explode", ShakeConfigData.builder().amplitude(0.1f, 0.5f, 0.15f).speed(5.0f, 3.5f, 10.0f).rangeMultiplier(0.1f).duration(5).build());
            this.put("minecraft:entity.dragon_fireball.explode", ShakeConfigData.builder().amplitude(0.1f, 0.5f, 0.15f).speed(5.0f, 3.5f, 10.0f).rangeMultiplier(0.1f).duration(5).build());
        }
    };

    public FallShakeConfigData getFallShakes() {
        return this.fallShakes;
    }

    public Map<String, ShakeConfigData> getSoundShakes() {
        return this.soundShakes;
    }

    public void setFallShakes(FallShakeConfigData fallShakes) {
        this.fallShakes = fallShakes;
    }

    public void setSoundShakes(Map<String, ShakeConfigData> soundShakes) {
        this.soundShakes = soundShakes;
    }

    @Override
    public String toString() {
        return "ShakeConfig(fallShakes=" + String.valueOf(this.getFallShakes()) + ", soundShakes=" + String.valueOf(this.getSoundShakes()) + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ShakeConfig)) {
            return false;
        }
        ShakeConfig other = (ShakeConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FallShakeConfigData this$fallShakes = this.getFallShakes();
        FallShakeConfigData other$fallShakes = other.getFallShakes();
        if (this$fallShakes == null ? other$fallShakes != null : !((Object)this$fallShakes).equals(other$fallShakes)) {
            return false;
        }
        Map<String, ShakeConfigData> this$soundShakes = this.getSoundShakes();
        Map<String, ShakeConfigData> other$soundShakes = other.getSoundShakes();
        return !(this$soundShakes == null ? other$soundShakes != null : !((Object)this$soundShakes).equals(other$soundShakes));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ShakeConfig;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        FallShakeConfigData $fallShakes = this.getFallShakes();
        result = result * 59 + ($fallShakes == null ? 43 : ((Object)$fallShakes).hashCode());
        Map<String, ShakeConfigData> $soundShakes = this.getSoundShakes();
        result = result * 59 + ($soundShakes == null ? 43 : ((Object)$soundShakes).hashCode());
        return result;
    }
}

