/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.perception.common.mixin.shakes;

import com.mojang.blaze3d.vertex.PoseStack;
import it.hurts.octostudios.perception.common.modules.shake.Shake;
import it.hurts.octostudios.perception.common.modules.shake.ShakeManager;
import java.util.Iterator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.world.entity.player.Player;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GameRenderer.class})
public class GameRendererMixin {
    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void onTick(CallbackInfo ci) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        Iterator<Shake> iterator = ShakeManager.SHAKES.values().iterator();
        while (iterator.hasNext()) {
            Shake effect = iterator.next();
            effect.update((Player)player);
            if (!effect.isFinished()) continue;
            iterator.remove();
        }
    }

    @Inject(method={"renderLevel"}, at={@At(value="HEAD")})
    private void onRenderLevel(float partialTicks, long l, PoseStack poseStack, CallbackInfo ci) {
        Minecraft MC = Minecraft.m_91087_();
        LocalPlayer player = MC.f_91074_;
        if (player == null) {
            return;
        }
        Vector3f shakeRotation = new Vector3f();
        Vector3f shakeOffset = new Vector3f();
        for (Shake effect : ShakeManager.SHAKES.values()) {
            shakeRotation.add((Vector3fc)effect.getShakeRotation((Player)player, partialTicks));
            shakeOffset.add((Vector3fc)effect.getShakeOffset((Player)player, partialTicks));
        }
        if (shakeRotation.lengthSquared() > 0.0f) {
            float rotationFactor = 10.0f;
            float rotationX = shakeRotation.x() * rotationFactor;
            float rotationY = shakeRotation.y() * rotationFactor;
            float rotationZ = shakeRotation.z() * rotationFactor;
            poseStack.m_252781_(new Quaternionf().rotateX(-rotationX * ((float)Math.PI / 180)).rotateY(-rotationY * ((float)Math.PI / 180)).rotateZ(-rotationZ * ((float)Math.PI / 180)));
        }
        if (shakeOffset.lengthSquared() > 0.0f) {
            poseStack.m_252880_(-shakeOffset.z(), shakeOffset.y(), shakeOffset.x());
        }
    }
}

