/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.level.levelgen.structure;

import com.mojang.datafixers.util.Pair;
import corgitaco.corgilib.math.blendingfunction.BlendingFunction;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.data.worldgen.Structures;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.valueproviders.ConstantFloat;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformFloat;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.WeightedStateProvider;
import net.minecraft.world.level.levelgen.heightproviders.ConstantHeight;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSpawnOverride;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.structures.JigsawStructure;
import net.potionstudios.biomeswevegone.BiomesWeveGone;
import net.potionstudios.biomeswevegone.tags.BWGBiomeTags;
import net.potionstudios.biomeswevegone.world.level.block.BWGBlocks;
import net.potionstudios.biomeswevegone.world.level.levelgen.BWGWorldGenerationUtil;
import net.potionstudios.biomeswevegone.world.level.levelgen.CheckedBlockPlacement;
import net.potionstudios.biomeswevegone.world.level.levelgen.blockpredicates.RandomChancePredicate;
import net.potionstudios.biomeswevegone.world.level.levelgen.feature.placed.BWGOverworldVegationPlacedFeatures;
import net.potionstudios.biomeswevegone.world.level.levelgen.structure.BWGTemplatePools;
import net.potionstudios.biomeswevegone.world.level.levelgen.structure.BWGVillageTemplatePools;
import net.potionstudios.biomeswevegone.world.level.levelgen.structure.arch.ArchConfig;
import net.potionstudios.biomeswevegone.world.level.levelgen.structure.arch.ArchStructure;
import net.potionstudios.biomeswevegone.world.level.levelgen.structure.lake.LargeLakeConfig;
import net.potionstudios.biomeswevegone.world.level.levelgen.structure.lake.LargeLakeStructure;
import net.potionstudios.biomeswevegone.world.level.levelgen.structure.plateau.GourPlateauStructure;
import net.potionstudios.biomeswevegone.world.level.levelgen.structure.sharpenedrock.SharpenedRockConfig;
import net.potionstudios.biomeswevegone.world.level.levelgen.structure.sharpenedrock.SharpenedRockStructure;

public class BWGStructures {
    public static final Map<ResourceKey<Structure>, StructureFactory> STRUCTURE_FACTORIES = new Reference2ObjectOpenHashMap();
    public static final ResourceKey<Structure> SHARPENED_ROCK = BWGStructures.register("sharpened_rock", structureFactoryBootstapContext -> new SharpenedRockStructure(BWGStructures.structure((HolderSet<Biome>)structureFactoryBootstapContext.m_255420_(Registries.f_256952_).m_254956_(BWGBiomeTags.SHARPENED_ROCKS), GenerationStep.Decoration.RAW_GENERATION, TerrainAdjustment.NONE), new SharpenedRockConfig((IntProvider)UniformInt.m_146622_((int)20, (int)60), (FloatProvider)UniformFloat.m_146605_((float)40.0f, (float)50.0f), (FloatProvider)UniformFloat.m_146605_((float)0.0f, (float)360.0f))));
    public static final ResourceKey<Structure> IRONWOOD_GOUR_PLATEAU = BWGStructures.register("ironwood_gour_plateau", structureFactoryBootstapContext -> new GourPlateauStructure(BWGStructures.structure((HolderSet<Biome>)structureFactoryBootstapContext.m_255420_(Registries.f_256952_).m_254956_(BWGBiomeTags.IRONWOOD_GOUR_PLATEAU), GenerationStep.Decoration.RAW_GENERATION, TerrainAdjustment.NONE)));
    public static final ResourceKey<Structure> LARGE_LAKE = BWGStructures.register("large_cold_lake", structureFactoryBootstapContext -> {
        HolderGetter placedFeatureHolderGetter = structureFactoryBootstapContext.m_255420_(Registries.f_256988_);
        return new LargeLakeStructure(Structures.m_255028_((HolderSet)structureFactoryBootstapContext.m_255420_(Registries.f_256952_).m_254956_(BWGBiomeTags.LARGE_COLD_LAKE), Map.of(MobCategory.WATER_AMBIENT, new StructureSpawnOverride(StructureSpawnOverride.BoundingBoxType.PIECE, SimpleWeightedRandomList.m_146330_((WeightedEntry[])new MobSpawnSettings.SpawnerData[]{new MobSpawnSettings.SpawnerData(EntityType.f_20519_, 5, 4, 10)}))), (GenerationStep.Decoration)GenerationStep.Decoration.RAW_GENERATION, (TerrainAdjustment)TerrainAdjustment.NONE), new LargeLakeConfig((HolderSet<PlacedFeature>)HolderSet.m_205809_((Holder[])new Holder[]{placedFeatureHolderGetter.m_255043_(BWGOverworldVegationPlacedFeatures.COLD_LAKE_VEGETATION)}), (IntProvider)UniformInt.m_146622_((int)96, (int)128), (IntProvider)UniformInt.m_146622_((int)20, (int)30)));
    });
    public static final ResourceKey<Structure> LUSH_ARCH = BWGStructures.register("lush_arch", structureFactoryBootstapContext -> new ArchStructure(BWGStructures.structure((HolderSet<Biome>)structureFactoryBootstapContext.m_255420_(Registries.f_256952_).m_254956_(BWGBiomeTags.LUSH_ARCH), GenerationStep.Decoration.RAW_GENERATION, TerrainAdjustment.NONE), new ArchConfig((IntProvider)UniformInt.m_146622_((int)64, (int)200), (IntProvider)UniformInt.m_146622_((int)50, (int)150), new CheckedBlockPlacement(List.of(Pair.of((Object)BlockPredicate.f_190394_, (Object)BlockStateProvider.m_191382_((Block)Blocks.f_50069_)), Pair.of((Object)BlockPredicate.m_190404_((BlockPredicate)new RandomChancePredicate((FloatProvider)ConstantFloat.m_146458_((float)0.4f)), (BlockPredicate)BlockPredicate.m_190425_(BWGWorldGenerationUtil.blockMatchesInAllDirections(blockPos -> BlockPredicate.m_224774_((Vec3i)blockPos, (Block[])new Block[]{Blocks.f_50016_, Blocks.f_50627_})))), (Object)new WeightedStateProvider(new SimpleWeightedRandomList.Builder().m_146271_((Object)Blocks.f_152544_.m_49966_(), 1).m_146271_((Object)Blocks.f_50079_.m_49966_(), 2))))), new ArchConfig.ArchGeneratorConfig(8, 8, (SimpleWeightedRandomList<ArchConfig.GenerationConfig>)SimpleWeightedRandomList.m_185862_((Object)new ArchConfig.GenerationConfig((IntProvider)UniformInt.m_146622_((int)10, (int)30), (FloatProvider)UniformFloat.m_146605_((float)0.05f, (float)0.1f))), (SimpleWeightedRandomList<BlendingFunction>)SimpleWeightedRandomList.m_146263_().m_146271_((Object)BlendingFunction.EaseOutCubic.INSTANCE, 1).m_146271_((Object)BlendingFunction.EaseInCirc.INSTANCE, 1).m_146271_((Object)BlendingFunction.EaseOutQuint.INSTANCE, 1).m_146271_((Object)BlendingFunction.EaseOutElastic.INSTANCE, 1).m_146271_((Object)BlendingFunction.EaseOutBounce.INSTANCE, 1).m_146270_()))));
    public static final ResourceKey<Structure> DRIPSTONE_ARCH = BWGStructures.register("dripstone_arch", structureFactoryBootstapContext -> new ArchStructure(BWGStructures.structure((HolderSet<Biome>)structureFactoryBootstapContext.m_255420_(Registries.f_256952_).m_254956_(BWGBiomeTags.DRIPSTONE_ARCH), GenerationStep.Decoration.RAW_GENERATION, TerrainAdjustment.NONE), new ArchConfig((IntProvider)UniformInt.m_146622_((int)64, (int)200), (IntProvider)UniformInt.m_146622_((int)50, (int)150), new CheckedBlockPlacement(List.of(Pair.of((Object)BlockPredicate.f_190394_, (Object)BlockStateProvider.m_191382_((Block)Blocks.f_50069_)), Pair.of((Object)BlockPredicate.m_190404_((BlockPredicate)new RandomChancePredicate((FloatProvider)ConstantFloat.m_146458_((float)0.4f)), (BlockPredicate)BlockPredicate.m_190425_(BWGWorldGenerationUtil.blockMatchesInAllDirections(blockPos -> BlockPredicate.m_224774_((Vec3i)blockPos, (Block[])new Block[]{Blocks.f_50016_, Blocks.f_50627_, Blocks.f_49990_})))), (Object)new WeightedStateProvider(new SimpleWeightedRandomList.Builder().m_146271_((Object)Blocks.f_152537_.m_49966_(), 1))))), new ArchConfig.ArchGeneratorConfig(8, 8, (SimpleWeightedRandomList<ArchConfig.GenerationConfig>)SimpleWeightedRandomList.m_185862_((Object)new ArchConfig.GenerationConfig((IntProvider)UniformInt.m_146622_((int)10, (int)30), (FloatProvider)UniformFloat.m_146605_((float)0.09f, (float)0.2f))), (SimpleWeightedRandomList<BlendingFunction>)SimpleWeightedRandomList.m_146263_().m_146271_((Object)BlendingFunction.EaseOutCubic.INSTANCE, 1).m_146271_((Object)BlendingFunction.EaseInCirc.INSTANCE, 1).m_146271_((Object)BlendingFunction.EaseOutQuint.INSTANCE, 1).m_146271_((Object)BlendingFunction.EaseOutBounce.INSTANCE, 1).m_146270_()))));
    public static final ResourceKey<Structure> RED_ROCK_ARCH = BWGStructures.register("red_rock_arch", structureFactoryBootstapContext -> new ArchStructure(BWGStructures.structure((HolderSet<Biome>)structureFactoryBootstapContext.m_255420_(Registries.f_256952_).m_254956_(BWGBiomeTags.RED_ROCK_ARCH), GenerationStep.Decoration.RAW_GENERATION, TerrainAdjustment.NONE), new ArchConfig((IntProvider)UniformInt.m_146622_((int)64, (int)200), (IntProvider)UniformInt.m_146622_((int)50, (int)150), new CheckedBlockPlacement(List.of(Pair.of((Object)BlockPredicate.f_190394_, (Object)BlockStateProvider.m_191382_((Block)BWGBlocks.RED_ROCK_SET.getBase())), Pair.of((Object)BlockPredicate.m_190404_((BlockPredicate)new RandomChancePredicate((FloatProvider)ConstantFloat.m_146458_((float)0.4f)), (BlockPredicate)BlockPredicate.m_190425_(BWGWorldGenerationUtil.blockMatchesInAllDirections(blockPos -> BlockPredicate.m_224774_((Vec3i)blockPos, (Block[])new Block[]{Blocks.f_50016_, Blocks.f_50627_, Blocks.f_49990_})))), (Object)new WeightedStateProvider(new SimpleWeightedRandomList.Builder().m_146271_((Object)Blocks.f_50288_.m_49966_(), 1))))), new ArchConfig.ArchGeneratorConfig(4, 4, (SimpleWeightedRandomList<ArchConfig.GenerationConfig>)SimpleWeightedRandomList.m_185862_((Object)new ArchConfig.GenerationConfig((IntProvider)UniformInt.m_146622_((int)20, (int)25), (FloatProvider)UniformFloat.m_146605_((float)0.05f, (float)0.1f))), (SimpleWeightedRandomList<BlendingFunction>)SimpleWeightedRandomList.m_146263_().m_146271_((Object)BlendingFunction.EaseOutCubic.INSTANCE, 1).m_146271_((Object)BlendingFunction.EaseInCirc.INSTANCE, 1).m_146271_((Object)BlendingFunction.EaseOutQuint.INSTANCE, 1).m_146271_((Object)BlendingFunction.EaseOutBounce.INSTANCE, 1).m_146270_()))));
    public static final ResourceKey<Structure> PRAIRIE_HOUSE = BWGStructures.register("prairie_house", structureFactoryBootstapContext -> BWGStructures.createJigsaw(BWGStructures.structure((HolderSet<Biome>)structureFactoryBootstapContext.m_255420_(Registries.f_256952_).m_254956_(BWGBiomeTags.StructureHasTags.HAS_PRAIRIE_HOUSE), TerrainAdjustment.BEARD_THIN), (Holder<StructureTemplatePool>)structureFactoryBootstapContext.m_255420_(Registries.f_256948_).m_255043_(BWGTemplatePools.PRAIRIE_HOUSE), 1, (HeightProvider)ConstantHeight.m_161956_((VerticalAnchor)VerticalAnchor.m_158922_((int)1)), Heightmap.Types.WORLD_SURFACE_WG));
    public static final ResourceKey<Structure> ABANDONED_PRAIRIE_HOUSE = BWGStructures.register("abandoned_prairie_house", structureFactoryBootstapContext -> BWGStructures.createJigsaw(BWGStructures.structure((HolderSet<Biome>)structureFactoryBootstapContext.m_255420_(Registries.f_256952_).m_254956_(BWGBiomeTags.StructureHasTags.HAS_PRAIRIE_HOUSE), TerrainAdjustment.BEARD_THIN), (Holder<StructureTemplatePool>)structureFactoryBootstapContext.m_255420_(Registries.f_256948_).m_255043_(BWGTemplatePools.ABANDONED_PRAIRIE_HOUSE), 1, (HeightProvider)ConstantHeight.m_161956_((VerticalAnchor)VerticalAnchor.m_158922_((int)1)), Heightmap.Types.WORLD_SURFACE_WG));
    public static final ResourceKey<Structure> RUGGED_FOSSIL = BWGStructures.register("rugged_fossil", structureFactoryBootstapContext -> BWGStructures.createJigsaw(BWGStructures.structure((HolderSet<Biome>)structureFactoryBootstapContext.m_255420_(Registries.f_256952_).m_254956_(BWGBiomeTags.StructureHasTags.HAS_RUGGED_FOSSIL), TerrainAdjustment.NONE), (Holder<StructureTemplatePool>)structureFactoryBootstapContext.m_255420_(Registries.f_256948_).m_255043_(BWGTemplatePools.RUGGED_FOSSIL), 1, (HeightProvider)ConstantHeight.m_161956_((VerticalAnchor)VerticalAnchor.m_158922_((int)1)), Heightmap.Types.WORLD_SURFACE_WG));
    public static final ResourceKey<Structure> ASPEN_MANOR_1 = BWGStructures.register("aspen_manor_1", structureFactoryBootstapContext -> BWGStructures.createJigsaw(BWGStructures.structure((HolderSet<Biome>)structureFactoryBootstapContext.m_255420_(Registries.f_256952_).m_254956_(BWGBiomeTags.StructureHasTags.HAS_ASPEN_MANOR), Map.of(MobCategory.MONSTER, new StructureSpawnOverride(StructureSpawnOverride.BoundingBoxType.STRUCTURE, SimpleWeightedRandomList.m_146330_((WeightedEntry[])new MobSpawnSettings.SpawnerData[]{new MobSpawnSettings.SpawnerData(EntityType.f_20493_, 25, 2, 4)}))), TerrainAdjustment.BEARD_THIN), (Holder<StructureTemplatePool>)structureFactoryBootstapContext.m_255420_(Registries.f_256948_).m_255043_(BWGTemplatePools.ASPEN_MANOR_1), 1, (HeightProvider)ConstantHeight.m_161956_((VerticalAnchor)VerticalAnchor.m_158922_((int)1)), Heightmap.Types.WORLD_SURFACE_WG));
    public static final ResourceKey<Structure> ASPEN_MANOR_2 = BWGStructures.register("aspen_manor_2", structureFactoryBootstapContext -> BWGStructures.createJigsaw(BWGStructures.structure((HolderSet<Biome>)structureFactoryBootstapContext.m_255420_(Registries.f_256952_).m_254956_(BWGBiomeTags.StructureHasTags.HAS_ASPEN_MANOR), Map.of(MobCategory.MONSTER, new StructureSpawnOverride(StructureSpawnOverride.BoundingBoxType.STRUCTURE, SimpleWeightedRandomList.m_146330_((WeightedEntry[])new MobSpawnSettings.SpawnerData[]{new MobSpawnSettings.SpawnerData(EntityType.f_20493_, 25, 2, 4)}))), TerrainAdjustment.BEARD_THIN), (Holder<StructureTemplatePool>)structureFactoryBootstapContext.m_255420_(Registries.f_256948_).m_255043_(BWGTemplatePools.ASPEN_MANOR_2), 1, (HeightProvider)ConstantHeight.m_161956_((VerticalAnchor)VerticalAnchor.m_158922_((int)1)), Heightmap.Types.WORLD_SURFACE_WG));
    public static final ResourceKey<Structure> FORGOTTEN_VILLAGE = BWGStructures.register("village/forgotten", structureFactoryBootstapContext -> BWGStructures.createJigsawWithExpansion(BWGStructures.structure((HolderSet<Biome>)structureFactoryBootstapContext.m_255420_(Registries.f_256952_).m_254956_(BWGBiomeTags.StructureHasTags.HAS_VILLAGE_FORGOTTEN), TerrainAdjustment.BEARD_THIN), (Holder<StructureTemplatePool>)structureFactoryBootstapContext.m_255420_(Registries.f_256948_).m_255043_(BWGVillageTemplatePools.FORGOTTEN_TOWN_CENTERS), 6, (HeightProvider)ConstantHeight.m_161956_((VerticalAnchor)VerticalAnchor.m_158922_((int)1)), Heightmap.Types.WORLD_SURFACE_WG));
    public static final ResourceKey<Structure> SKYRIS_VILLAGE = BWGStructures.register("village/skyris", structureFactoryBootstapContext -> BWGStructures.createJigsawWithExpansion(BWGStructures.structure((HolderSet<Biome>)structureFactoryBootstapContext.m_255420_(Registries.f_256952_).m_254956_(BWGBiomeTags.StructureHasTags.HAS_VILLAGE_SKYRIS), TerrainAdjustment.BEARD_THIN), (Holder<StructureTemplatePool>)structureFactoryBootstapContext.m_255420_(Registries.f_256948_).m_255043_(BWGVillageTemplatePools.SKYRIS_TOWN_CENTERS), 6, (HeightProvider)ConstantHeight.m_161956_((VerticalAnchor)VerticalAnchor.m_158922_((int)1)), Heightmap.Types.WORLD_SURFACE_WG));
    public static final ResourceKey<Structure> SALEM_VILLAGE = BWGStructures.register("village/salem", structureFactoryBootstapContext -> BWGStructures.createJigsawWithExpansion(BWGStructures.structure((HolderSet<Biome>)structureFactoryBootstapContext.m_255420_(Registries.f_256952_).m_254956_(BWGBiomeTags.StructureHasTags.HAS_VILLAGE_SALEM), TerrainAdjustment.BEARD_THIN), (Holder<StructureTemplatePool>)structureFactoryBootstapContext.m_255420_(Registries.f_256948_).m_255043_(BWGVillageTemplatePools.SALEM_TOWN_CENTERS), 6, (HeightProvider)ConstantHeight.m_161956_((VerticalAnchor)VerticalAnchor.m_158922_((int)1)), Heightmap.Types.WORLD_SURFACE_WG));
    public static final ResourceKey<Structure> RED_ROCK_VILLAGE = BWGStructures.register("village/red_rock", structureFactoryBootstapContext -> BWGStructures.createJigsawWithExpansion(BWGStructures.structure((HolderSet<Biome>)structureFactoryBootstapContext.m_255420_(Registries.f_256952_).m_254956_(BWGBiomeTags.StructureHasTags.HAS_VILLAGE_RED_ROCK), TerrainAdjustment.BEARD_THIN), (Holder<StructureTemplatePool>)structureFactoryBootstapContext.m_255420_(Registries.f_256948_).m_255043_(BWGVillageTemplatePools.RED_ROCK_TOWN_CENTERS), 6, (HeightProvider)ConstantHeight.m_161956_((VerticalAnchor)VerticalAnchor.m_158922_((int)1)), Heightmap.Types.WORLD_SURFACE_WG));
    public static final ResourceKey<Structure> PUMPKIN_PATCH_VILLAGE = BWGStructures.register("village/pumpkin_patch", structureFactoryBootstapContext -> BWGStructures.createJigsawWithExpansion(BWGStructures.structure((HolderSet<Biome>)structureFactoryBootstapContext.m_255420_(Registries.f_256952_).m_254956_(BWGBiomeTags.StructureHasTags.HAS_VILLAGE_PUMPKIN_PATCH), TerrainAdjustment.BEARD_THIN), (Holder<StructureTemplatePool>)structureFactoryBootstapContext.m_255420_(Registries.f_256948_).m_255043_(BWGVillageTemplatePools.PUMPKIN_PATCH_TOWN_CENTERS), 6, (HeightProvider)ConstantHeight.m_161956_((VerticalAnchor)VerticalAnchor.m_158922_((int)1)), Heightmap.Types.WORLD_SURFACE_WG));

    private static ResourceKey<Structure> register(String id, StructureFactory factory) {
        ResourceKey structureSetResourceKey = BiomesWeveGone.key(Registries.f_256944_, id);
        STRUCTURE_FACTORIES.put(structureSetResourceKey, factory);
        return structureSetResourceKey;
    }

    private static Structure.StructureSettings structure(HolderSet<Biome> tag, TerrainAdjustment adj) {
        return Structures.m_255028_(tag, Map.of(), (GenerationStep.Decoration)GenerationStep.Decoration.SURFACE_STRUCTURES, (TerrainAdjustment)adj);
    }

    private static Structure.StructureSettings structure(HolderSet<Biome> tag, Map<MobCategory, StructureSpawnOverride> spawnOverrides, TerrainAdjustment adj) {
        return Structures.m_255028_(tag, spawnOverrides, (GenerationStep.Decoration)GenerationStep.Decoration.SURFACE_STRUCTURES, (TerrainAdjustment)adj);
    }

    private static Structure.StructureSettings structure(HolderSet<Biome> tag, GenerationStep.Decoration decoration, TerrainAdjustment adj) {
        return Structures.m_255028_(tag, Map.of(), (GenerationStep.Decoration)decoration, (TerrainAdjustment)adj);
    }

    private static JigsawStructure createJigsaw(Structure.StructureSettings settings, Holder<StructureTemplatePool> startPool, int maxDepth, HeightProvider startHeight, boolean useExpansionHack) {
        return new JigsawStructure(settings, startPool, maxDepth, startHeight, useExpansionHack);
    }

    private static JigsawStructure createJigsaw(Structure.StructureSettings settings, Holder<StructureTemplatePool> startPool, int maxDepth, HeightProvider startHeight, Heightmap.Types projectStartToHeightmap) {
        return new JigsawStructure(settings, startPool, maxDepth, startHeight, false, projectStartToHeightmap);
    }

    private static JigsawStructure createJigsawWithExpansion(Structure.StructureSettings settings, Holder<StructureTemplatePool> startPool, int maxDepth, HeightProvider startHeight, Heightmap.Types projectStartToHeightmap) {
        return new JigsawStructure(settings, startPool, maxDepth, startHeight, true, projectStartToHeightmap);
    }

    @FunctionalInterface
    public static interface StructureFactory {
        public Structure generate(BootstapContext<Structure> var1);
    }
}

