/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.level.levelgen.structure;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadType;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import net.potionstudios.biomeswevegone.BiomesWeveGone;
import net.potionstudios.biomeswevegone.world.level.levelgen.structure.BWGStructures;

public class BWGStructureSets {
    public static final Map<ResourceKey<StructureSet>, StructureSetFactory> STRUCTURE_SET_FACTORIES = new Reference2ObjectOpenHashMap();
    public static final ResourceKey<StructureSet> SHARPENED_ROCKS = BWGStructureSets.register("sharpened_rocks", structureHolderGetter -> new StructureSet((List)ImmutableList.of((Object)StructureSet.m_210015_((Holder)structureHolderGetter.m_255043_(BWGStructures.SHARPENED_ROCK))), (StructurePlacement)new RandomSpreadStructurePlacement(12, 3, RandomSpreadType.TRIANGULAR, 348457856)));
    public static final ResourceKey<StructureSet> IRONWOOD_GOUR_PLATEAU = BWGStructureSets.register("ironwood_gour_plateau", structureHolderGetter -> new StructureSet((List)ImmutableList.of((Object)StructureSet.m_210015_((Holder)structureHolderGetter.m_255043_(BWGStructures.IRONWOOD_GOUR_PLATEAU))), (StructurePlacement)new RandomSpreadStructurePlacement(4, 1, RandomSpreadType.TRIANGULAR, 596586)));
    public static final ResourceKey<StructureSet> LARGE_COLD_LAKE = BWGStructureSets.register("large_cold_lake", structureHolderGetter -> new StructureSet((List)ImmutableList.of((Object)StructureSet.m_210015_((Holder)structureHolderGetter.m_255043_(BWGStructures.LARGE_LAKE))), (StructurePlacement)new RandomSpreadStructurePlacement(32, 8, RandomSpreadType.TRIANGULAR, 546451665)));
    public static final ResourceKey<StructureSet> LUSH_ARCHES = BWGStructureSets.register("lush_arch", structureHolderGetter -> new StructureSet((List)ImmutableList.of((Object)StructureSet.m_210015_((Holder)structureHolderGetter.m_255043_(BWGStructures.LUSH_ARCH))), (StructurePlacement)new RandomSpreadStructurePlacement(8, 2, RandomSpreadType.TRIANGULAR, 54546651)));
    public static final ResourceKey<StructureSet> DRIPSTONE_ARCHES = BWGStructureSets.register("dripstone_arches", structureHolderGetter -> new StructureSet((List)ImmutableList.of((Object)StructureSet.m_210015_((Holder)structureHolderGetter.m_255043_(BWGStructures.DRIPSTONE_ARCH))), (StructurePlacement)new RandomSpreadStructurePlacement(8, 2, RandomSpreadType.TRIANGULAR, 1151551458)));
    public static final ResourceKey<StructureSet> RED_ROCK_ARCHES = BWGStructureSets.register("red_rock_arches", structureHolderGetter -> new StructureSet((List)ImmutableList.of((Object)StructureSet.m_210015_((Holder)structureHolderGetter.m_255043_(BWGStructures.RED_ROCK_ARCH))), (StructurePlacement)new RandomSpreadStructurePlacement(16, 4, RandomSpreadType.TRIANGULAR, 5454151)));
    private static final ResourceKey<StructureSet> PRAIRIE_HOUSES = BWGStructureSets.register("prairie_houses", structureHolderGetter -> new StructureSet((List)ImmutableList.of((Object)StructureSet.m_210017_((Holder)structureHolderGetter.m_255043_(BWGStructures.PRAIRIE_HOUSE), (int)5), (Object)StructureSet.m_210017_((Holder)structureHolderGetter.m_255043_(BWGStructures.ABANDONED_PRAIRIE_HOUSE), (int)4)), (StructurePlacement)new RandomSpreadStructurePlacement(25, 20, RandomSpreadType.LINEAR, 703905857)));
    private static final ResourceKey<StructureSet> RUGGED_FOSSILS = BWGStructureSets.register("rugged_fossils", structureHolderGetter -> new StructureSet((List)ImmutableList.of((Object)StructureSet.m_210017_((Holder)structureHolderGetter.m_255043_(BWGStructures.RUGGED_FOSSIL), (int)5)), (StructurePlacement)new RandomSpreadStructurePlacement(8, 6, RandomSpreadType.LINEAR, 682594027)));
    private static final ResourceKey<StructureSet> ASPEN_MANORS = BWGStructureSets.register("aspen_manors", structureHolderGetter -> new StructureSet((List)ImmutableList.of((Object)StructureSet.m_210017_((Holder)structureHolderGetter.m_255043_(BWGStructures.ASPEN_MANOR_1), (int)1), (Object)StructureSet.m_210017_((Holder)structureHolderGetter.m_255043_(BWGStructures.ASPEN_MANOR_2), (int)1)), (StructurePlacement)new RandomSpreadStructurePlacement(50, 35, RandomSpreadType.LINEAR, 372893981)));
    private static final ResourceKey<StructureSet> VILLAGES = BWGStructureSets.register("villages", structureHolderGetter -> new StructureSet((List)ImmutableList.of((Object)StructureSet.m_210015_((Holder)structureHolderGetter.m_255043_(BWGStructures.FORGOTTEN_VILLAGE)), (Object)StructureSet.m_210015_((Holder)structureHolderGetter.m_255043_(BWGStructures.SKYRIS_VILLAGE)), (Object)StructureSet.m_210015_((Holder)structureHolderGetter.m_255043_(BWGStructures.SALEM_VILLAGE)), (Object)StructureSet.m_210015_((Holder)structureHolderGetter.m_255043_(BWGStructures.RED_ROCK_VILLAGE)), (Object)StructureSet.m_210015_((Holder)structureHolderGetter.m_255043_(BWGStructures.PUMPKIN_PATCH_VILLAGE))), (StructurePlacement)new RandomSpreadStructurePlacement(34, 8, RandomSpreadType.LINEAR, 437845874)));

    private static ResourceKey<StructureSet> register(String id, StructureSetFactory factory) {
        ResourceKey structureSetResourceKey = BiomesWeveGone.key(Registries.f_256998_, id);
        STRUCTURE_SET_FACTORIES.put(structureSetResourceKey, factory);
        return structureSetResourceKey;
    }

    @FunctionalInterface
    public static interface StructureSetFactory {
        public StructureSet generate(HolderGetter<Structure> var1);
    }
}

