/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.entity.npc;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.potionstudios.biomeswevegone.config.configs.BWGTradesConfig;
import net.potionstudios.biomeswevegone.world.entity.npc.BWGVillagerProfessions;
import net.potionstudios.biomeswevegone.world.item.BWGItems;
import net.potionstudios.biomeswevegone.world.level.block.BWGBlocks;
import net.potionstudios.biomeswevegone.world.level.block.sand.BWGSandSet;
import net.potionstudios.biomeswevegone.world.level.block.wood.BWGWood;

public class BWGVillagerTrades {
    public static final Map<VillagerProfession, Int2ObjectMap<List<MerchantOffer>>> TRADES = new HashMap<VillagerProfession, Int2ObjectMap<List<MerchantOffer>>>();
    public static final Int2ObjectMap<List<MerchantOffer>> WANDERING_TRADER_TRADES = new Int2ObjectOpenHashMap();

    public static void makeTrades() {
        if (BWGTradesConfig.INSTANCE.villagerTrades.allowBWGForagerTrades.value().booleanValue()) {
            TRADES.put(BWGVillagerProfessions.FORAGER.get(), BWGVillagerTrades.toIntMap((ImmutableMap<Integer, List<MerchantOffer>>)ImmutableMap.of((Object)1, (Object)ImmutableList.of((Object)BWGVillagerTrades.createEmeraldForItemsOffer((ItemLike)Items.f_41953_, 10, 12, 2), (Object)BWGVillagerTrades.createEmeraldForItemsOffer((ItemLike)Items.f_41952_, 10, 12, 2), (Object)BWGVillagerTrades.createEmeraldForItemsOffer((ItemLike)BWGBlocks.GREEN_MUSHROOM.get(), 10, 12, 2)), (Object)2, (Object)ImmutableList.of((Object)BWGVillagerTrades.createEmeraldForItemsOffer((ItemLike)BWGBlocks.WOOD_BLEWIT.get(), 8, 12, 3), (Object)BWGVillagerTrades.createItemsForEmeraldsOffer((ItemLike)BWGItems.WHITE_PUFFBALL_CAP.get(), 4, 5, 4, 2, 0.05f)), (Object)3, (Object)ImmutableList.of((Object)BWGVillagerTrades.createEmeraldForItemsOffer((ItemLike)BWGItems.WHITE_PUFFBALL_SPORES.get(), 4, 5, 4)), (Object)4, (Object)ImmutableList.of((Object)BWGVillagerTrades.createItemsForEmeraldsOffer((ItemLike)BWGBlocks.WITCH_HAZEL_BRANCH.get(), 4, 9, 4, 3, 0.05f), (Object)BWGVillagerTrades.createItemsForEmeraldsOffer((ItemLike)BWGBlocks.WITCH_HAZEL_BLOSSOM.get(), 10, 1, 10, 3, 0.05f)), (Object)5, (Object)ImmutableList.of((Object)BWGVillagerTrades.createItemsForEmeraldsOffer((ItemLike)BWGBlocks.SHELF_FUNGI.get(), 3, 9, 4, 4, 0.05f), (Object)BWGVillagerTrades.createEmeraldForItemsOffer((ItemLike)Items.f_42780_, 16, 4, 2), (Object)BWGVillagerTrades.createEmeraldForItemsOffer((ItemLike)BWGItems.BLUEBERRIES.get(), 16, 4, 2)))));
        }
        if (!BWGTradesConfig.INSTANCE.villagerTrades.enableBWGVanillaProfessionTradeAdditions.value().booleanValue()) {
            return;
        }
        TRADES.put(VillagerProfession.f_35587_, BWGVillagerTrades.toIntMap((ImmutableMap<Integer, List<MerchantOffer>>)ImmutableMap.of((Object)2, (Object)ImmutableList.of((Object)BWGVillagerTrades.createEmeraldForItemsOffer((ItemLike)BWGItems.BLUEBERRIES.get(), 10, 12, 2)))));
        TRADES.put(VillagerProfession.f_35590_, BWGVillagerTrades.toIntMap((ImmutableMap<Integer, List<MerchantOffer>>)ImmutableMap.of((Object)1, (Object)ImmutableList.of((Object)BWGVillagerTrades.createEmeraldForItemsOffer((ItemLike)BWGItems.CATTAIL_SPROUT.get(), 24, 12, 2)), (Object)2, (Object)ImmutableList.of((Object)BWGVillagerTrades.createEmeraldForItemsOffer((ItemLike)BWGItems.BAOBAB_FRUIT.get(), 10, 12, 2), (Object)BWGVillagerTrades.createEmeraldForItemsOffer((ItemLike)BWGItems.GREEN_APPLE.get(), 24, 12, 2), (Object)BWGVillagerTrades.createEmeraldForItemsOffer((ItemLike)BWGBlocks.ALOE_VERA.get(), 16, 12, 2)), (Object)3, (Object)ImmutableList.of((Object)BWGVillagerTrades.createEmeraldForItemsOffer((ItemLike)BWGItems.YUCCA_FRUIT.get(), 10, 12, 2)))));
        TRADES.put(VillagerProfession.f_35595_, BWGVillagerTrades.toIntMap((ImmutableMap<Integer, List<MerchantOffer>>)ImmutableMap.of((Object)3, (Object)ImmutableList.of((Object)BWGVillagerTrades.createEmeraldForItemsOffer((ItemLike)BWGBlocks.ROCKY_STONE_SET.getBase(), 12, 12, 20), (Object)BWGVillagerTrades.createItemsForEmeraldsOffer((ItemLike)BWGBlocks.ROCKY_STONE_SET.getBase(), 1, 1, 12, 10, 0.05f), (Object)BWGVillagerTrades.createEmeraldForItemsOffer((ItemLike)BWGBlocks.MOSSY_STONE_SET.getBase(), 12, 12, 20), (Object)BWGVillagerTrades.createItemsForEmeraldsOffer((ItemLike)BWGBlocks.MOSSY_STONE_SET.getBase(), 1, 1, 12, 10, 0.05f)), (Object)4, (Object)ImmutableList.of((Object)BWGVillagerTrades.createEmeraldForItemsOffer((ItemLike)BWGBlocks.DACITE_SET.getBase(), 12, 12, 30), (Object)BWGVillagerTrades.createItemsForEmeraldsOffer((ItemLike)BWGBlocks.DACITE_SET.getBase(), 1, 1, 12, 15, 0.05f), (Object)BWGVillagerTrades.createEmeraldForItemsOffer((ItemLike)BWGBlocks.RED_ROCK_SET.getBase(), 12, 12, 30), (Object)BWGVillagerTrades.createItemsForEmeraldsOffer((ItemLike)BWGBlocks.RED_ROCK_SET.getBase(), 1, 1, 12, 15, 0.05f)))));
    }

    public static void makeWanderingTrades() {
        ArrayList<MerchantOffer> level1Items = new ArrayList<MerchantOffer>();
        BWGWood.WOOD.stream().filter(item -> item.get() instanceof SaplingBlock).forEach(item -> level1Items.add(BWGVillagerTrades.createItemsForEmeraldsOffer((ItemLike)item.get(), 5, 1, 8, 1, 0.05f)));
        BWGSandSet.getSandSets().forEach(bwgSandSet -> level1Items.add(BWGVillagerTrades.createItemsForEmeraldsOffer((ItemLike)bwgSandSet.getSand(), 1, 8, 8, 1, 0.05f)));
        BWGBlocks.BLOCKS.stream().filter(block -> block.get() instanceof FlowerBlock).forEach(block -> level1Items.add(BWGVillagerTrades.createItemsForEmeraldsOffer((ItemLike)block.get(), 1, 1, 13, 1, 0.05f)));
        level1Items.add(BWGVillagerTrades.createItemsForEmeraldsOffer((ItemLike)BWGItems.TINY_LILY_PADS.get(), 1, 2, 5, 1, 0.05f));
        level1Items.add(BWGVillagerTrades.createItemsForEmeraldsOffer((ItemLike)BWGItems.FLOWERING_TINY_LILY_PADS.get(), 1, 2, 5, 1, 0.05f));
        level1Items.add(BWGVillagerTrades.createItemsForEmeraldsOffer((ItemLike)BWGBlocks.WEEPING_MILKCAP.get(), 1, 1, 12, 1, 0.05f));
        level1Items.add(BWGVillagerTrades.createItemsForEmeraldsOffer((ItemLike)BWGBlocks.GREEN_MUSHROOM.get(), 1, 1, 12, 1, 0.05f));
        level1Items.add(BWGVillagerTrades.createItemsForEmeraldsOffer((ItemLike)BWGBlocks.WOOD_BLEWIT.get(), 1, 1, 12, 1, 0.05f));
        WANDERING_TRADER_TRADES.put(1, level1Items);
    }

    private static MerchantOffer createEmeraldForItemsOffer(ItemLike item, int cost, int maxUses, int villagerXp) {
        return new MerchantOffer(new ItemStack(item, cost), new ItemStack((ItemLike)Items.f_42616_), maxUses, villagerXp, 0.05f);
    }

    private static MerchantOffer createItemsForEmeraldsOffer(ItemLike item, int emeraldCost, int numberOfItems, int maxUses, int villagerXp, float priceMultiplier) {
        return new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, emeraldCost), new ItemStack(item, numberOfItems), maxUses, villagerXp, priceMultiplier);
    }

    private static Int2ObjectMap<List<MerchantOffer>> toIntMap(ImmutableMap<Integer, List<MerchantOffer>> map) {
        return new Int2ObjectOpenHashMap(map);
    }
}

