/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.entity;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.level.levelgen.Heightmap;
import net.potionstudios.biomeswevegone.BiomesWeveGone;
import net.potionstudios.biomeswevegone.PlatformHandler;
import net.potionstudios.biomeswevegone.world.entity.boats.BWGBoatEntity;
import net.potionstudios.biomeswevegone.world.entity.boats.BWGChestBoatEntity;
import net.potionstudios.biomeswevegone.world.entity.manowar.ManOWar;
import net.potionstudios.biomeswevegone.world.entity.oddion.Oddion;
import net.potionstudios.biomeswevegone.world.entity.pumpkinwarden.PumpkinWarden;

public class BWGEntities {
    public static final Supplier<EntityType<ManOWar>> MAN_O_WAR = BWGEntities.createEntity("man_o_war", ManOWar::new, MobCategory.WATER_CREATURE, 0.6f, 1.0f);
    public static final Supplier<EntityType<PumpkinWarden>> PUMPKIN_WARDEN = BWGEntities.createEntity("pumpkin_warden", PumpkinWarden::new, MobCategory.MISC, 0.64f, 1.1f);
    public static final Supplier<EntityType<Oddion>> ODDION = BWGEntities.createEntity("oddion", Oddion::new, MobCategory.CREATURE, 0.5f, 0.75f);
    public static final Supplier<EntityType<BWGBoatEntity>> BWG_BOAT = BWGEntities.createEntity("boat", BWGBoatEntity::new, MobCategory.MISC, EntityType.f_20552_.m_20678_(), EntityType.f_20552_.m_20679_(), 10);
    public static final Supplier<EntityType<BWGChestBoatEntity>> BWG_CHEST_BOAT = BWGEntities.createEntity("chest_boat", BWGChestBoatEntity::new, MobCategory.MISC, EntityType.f_217016_.m_20678_(), EntityType.f_217016_.m_20679_(), 10);

    private static <E extends Entity> Supplier<EntityType<E>> createEntity(String id, EntityType.EntityFactory<E> factory, MobCategory category, float width, float height) {
        return PlatformHandler.PLATFORM_HANDLER.registerEntity(id, factory, category, width, height);
    }

    private static <E extends Entity> Supplier<EntityType<E>> createEntity(String id, EntityType.EntityFactory<E> factory, MobCategory category, float width, float height, int trackingRange) {
        return PlatformHandler.PLATFORM_HANDLER.registerEntity(id, factory, category, width, height, trackingRange);
    }

    public static <T extends Mob> void registerSpawnPlacements(Consumer<SpawnPlacement<T>> consumer) {
        consumer.accept(new SpawnPlacement<ManOWar>(MAN_O_WAR.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, ManOWar::checkManOWarSpawnRules));
        consumer.accept(new SpawnPlacement<Oddion>(ODDION.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.WORLD_SURFACE, Oddion::checkOddionSpawnRules));
    }

    public static void registerEntityAttributes(BiConsumer<EntityType<? extends LivingEntity>, AttributeSupplier> consumer) {
        consumer.accept(MAN_O_WAR.get(), ManOWar.createAttributes().m_22265_());
        consumer.accept(PUMPKIN_WARDEN.get(), PumpkinWarden.createAttributes().m_22265_());
        consumer.accept(ODDION.get(), Oddion.createAttributes().m_22265_());
    }

    public static void entities() {
        BiomesWeveGone.LOGGER.info("Registering Oh The Biomes We've Gone Entities");
    }

    public record SpawnPlacement<T extends Mob>(EntityType<T> entityType, SpawnPlacements.Type spawnPlacementType, Heightmap.Types heightmapType, SpawnPlacements.SpawnPredicate<T> predicate) {
    }
}

