/*
 * Decompiled with CFR 0.152.
 */
package io.github.lieonlion.mcv.client.renderer;

import io.github.lieonlion.mcv.MoreChestVariants;
import io.github.lieonlion.mcv.block.entity.MoreChestBlockEntity;
import java.util.Calendar;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.ChestRenderer;
import net.minecraft.client.resources.model.Material;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MoreChestRenderer
extends ChestRenderer<MoreChestBlockEntity> {
    public static boolean christmas;
    public static boolean starwarsday;

    public MoreChestRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
        Calendar calendar = Calendar.getInstance();
        if (calendar.get(2) + 1 == 12 && calendar.get(5) >= 24 && calendar.get(5) <= 26) {
            christmas = true;
        }
        if (calendar.get(2) + 1 == 5 && calendar.get(5) >= 3 && calendar.get(5) <= 5) {
            starwarsday = true;
        }
    }

    protected Material getMaterial(MoreChestBlockEntity blockEntity, ChestType chestType) {
        return this.getChestMaterial(blockEntity, chestType);
    }

    public static Material chooseMaterial(ChestType type, Material left, Material right, Material single) {
        return switch (type) {
            case ChestType.LEFT -> left;
            case ChestType.RIGHT -> right;
            default -> single;
        };
    }

    public static Material getChestPath(String path) {
        return new Material(Sheets.f_110740_, MoreChestVariants.asId("entity/chest/" + path));
    }

    private Material getChestMaterial(MoreChestBlockEntity blockEntity, ChestType type) {
        if (christmas) {
            return Sheets.m_110767_((BlockEntity)blockEntity, (ChestType)type, (boolean)true);
        }
        if (starwarsday) {
            return MoreChestRenderer.chooseMaterial(type, MoreChestRenderer.getChestPath("starwars_left"), MoreChestRenderer.getChestPath("starwars_right"), MoreChestRenderer.getChestPath("starwars"));
        }
        return MoreChestRenderer.chooseMaterial(type, MoreChestRenderer.getChestPath(blockEntity.getBlock().chestType + "_left"), MoreChestRenderer.getChestPath(blockEntity.getBlock().chestType + "_right"), MoreChestRenderer.getChestPath(blockEntity.getBlock().chestType));
    }
}

