/*
 * Decompiled with CFR 0.152.
 */
package io.github.lieonlion.mcvbmo.client;

import io.github.lieonlion.mcv.client.MoreChestRenderer;
import io.github.lieonlion.mcvbmo.blocks.MoreChestBMOBlockEntity;
import io.github.lieonlion.mcvbmo.blocks.MoreChestBMOEnum;
import java.util.Calendar;
import java.util.Locale;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.ChestRenderer;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MoreChestBMORenderer
extends ChestRenderer<MoreChestBMOBlockEntity> {
    public static Material[] single = new Material[MoreChestBMOEnum.VALUES.length];
    public static Material[] left = new Material[MoreChestBMOEnum.VALUES.length];
    public static Material[] right = new Material[MoreChestBMOEnum.VALUES.length];
    private static boolean christmas;
    private static boolean starwarsday;

    public MoreChestBMORenderer(BlockEntityRendererProvider.Context context) {
        super(context);
        Calendar calendar = Calendar.getInstance();
        if (calendar.get(2) + 1 == 12 && calendar.get(5) >= 24 && calendar.get(5) <= 26) {
            christmas = true;
        }
        if (calendar.get(2) + 1 == 5 && calendar.get(5) >= 3 && calendar.get(5) <= 5) {
            starwarsday = true;
        }
    }

    protected Material getMaterial(MoreChestBMOBlockEntity blockEntity, ChestType chestType) {
        return this.getChestMaterial(blockEntity, chestType);
    }

    public static Material getChestMaterial(String path) {
        return new Material(Sheets.f_110740_, new ResourceLocation("lolmcvbmo", "entity/chest/" + path));
    }

    private Material getChestMaterial(MoreChestBMOBlockEntity tile, ChestType type) {
        if (christmas) {
            return Sheets.m_110767_((BlockEntity)tile, (ChestType)type, (boolean)christmas);
        }
        if (starwarsday) {
            return MoreChestRenderer.chooseMaterial((ChestType)type, (Material)MoreChestRenderer.getChestMaterial((String)"starwars_left"), (Material)MoreChestRenderer.getChestMaterial((String)"starwars_right"), (Material)MoreChestRenderer.getChestMaterial((String)"starwars"));
        }
        return MoreChestRenderer.chooseMaterial((ChestType)type, (Material)left[tile.getChestType().ordinal()], (Material)right[tile.getChestType().ordinal()], (Material)single[tile.getChestType().ordinal()]);
    }

    static {
        for (MoreChestBMOEnum type : MoreChestBMOEnum.VALUES) {
            MoreChestBMORenderer.single[type.ordinal()] = MoreChestBMORenderer.getChestMaterial(type.name().toLowerCase(Locale.ENGLISH));
            MoreChestBMORenderer.left[type.ordinal()] = MoreChestBMORenderer.getChestMaterial(type.name().toLowerCase(Locale.ENGLISH) + "_left");
            MoreChestBMORenderer.right[type.ordinal()] = MoreChestBMORenderer.getChestMaterial(type.name().toLowerCase(Locale.ENGLISH) + "_right");
        }
    }
}

