/*
 * Decompiled with CFR 0.152.
 */
package shadowmaster435.impactfulweather.core.init;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.javafmlmod.FMLModContainer;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;
import org.apache.commons.lang3.StringUtils;
import shadowmaster435.impactfulweather.core.init.ForgeRegistryReference;
import shadowmaster435.impactfulweather.core.init.RegistryManager;
import shadowmaster435.impactfulweather.core.init.RegistryReference;

public class ForgeRegistryManager
implements RegistryManager {
    private static final Map<ResourceKey<? extends Registry<?>>, DeferredRegister<?>> DEFERRED_REGISTERS = Maps.newConcurrentMap();
    private final String namespace;
    private final IEventBus modEventBus;

    private ForgeRegistryManager(String namespace) {
        this.namespace = namespace;
        this.modEventBus = ModList.get().getModContainerById(namespace).map(container -> (FMLModContainer)container).map(FMLModContainer::getEventBus).orElseThrow();
    }

    @Override
    public String namespace() {
        return this.namespace;
    }

    @Override
    public <T> RegistryReference<T> register(ResourceKey<? extends Registry<? super T>> registryKey, String path, Supplier<T> supplier) {
        DeferredRegister register = DEFERRED_REGISTERS.computeIfAbsent(registryKey, key -> {
            DeferredRegister deferredRegister = DeferredRegister.create((ResourceKey)registryKey, (String)this.namespace);
            deferredRegister.register(this.modEventBus);
            return deferredRegister;
        });
        if (StringUtils.isEmpty((CharSequence)path)) {
            throw new IllegalArgumentException("Can't register object without name");
        }
        RegistryObject registryObject = register.register(path, supplier);
        return new ForgeRegistryReference(registryObject, registryKey);
    }

    public static RegistryManager of(String namespace) {
        return MOD_TO_REGISTRY.computeIfAbsent(namespace, ForgeRegistryManager::new);
    }
}

